/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class DynamicInvocationHandler
implements InvocationHandler {
    private final CallFrame callFrameProxy;
    private final Map<String, VncFunction> methods;
    private final IInterceptor parentInterceptor;
    private final AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals;

    private DynamicInvocationHandler(CallFrame callFrameProxy, Map<String, VncFunction> methods) {
        this.callFrameProxy = callFrameProxy;
        this.methods = methods;
        this.parentInterceptor = JavaInterop.getInterceptor();
        this.parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        VncFunction fn = this.methods.get(method.getName());
        if (fn != null) {
            VncList fnArgs = DynamicInvocationHandler.toVncArgs(args);
            CallStack callStack = ThreadLocalMap.getCallStack();
            CallFrame callFrameMethod = CallFrame.fromVal("proxy(:" + method.getName() + ")->" + fn.getQualifiedName(), fn.getMeta());
            IInterceptor proxyInterceptor = JavaInterop.getInterceptor();
            if (proxyInterceptor == this.parentInterceptor) {
                try {
                    callStack.push(this.callFrameProxy);
                    callStack.push(callFrameMethod);
                    Object object = fn.apply(fnArgs).convertToJavaObject();
                    return object;
                }
                finally {
                    callStack.pop();
                    callStack.pop();
                }
            }
            try {
                ThreadLocalMap.clear();
                ThreadLocalMap.setValues(this.parentThreadLocals.get());
                JavaInterop.register(this.parentInterceptor);
                callStack.push(this.callFrameProxy);
                callStack.push(callFrameMethod);
                Object object = fn.apply(fnArgs).convertToJavaObject();
                return object;
            }
            finally {
                callStack.pop();
                callStack.pop();
                JavaInterop.unregister();
                ThreadLocalMap.remove();
            }
        }
        throw new UnsupportedOperationException(String.format("ProxyMethod %s", method.getName()));
    }

    public static Object proxify(CallFrame callFrame, Class<?> clazz, VncMap handlers) {
        return Proxy.newProxyInstance(DynamicInvocationHandler.class.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new DynamicInvocationHandler(callFrame, DynamicInvocationHandler.handlerMap(handlers)));
    }

    private static String name(VncVal val) {
        if (Types.isVncKeyword(val)) {
            return ((VncKeyword)val).getValue();
        }
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        throw new VncException("A proxy handler map key must be of type VncKeyword or VncString");
    }

    private static Map<String, VncFunction> handlerMap(VncMap handlers) {
        return handlers.entries().stream().collect(Collectors.toMap(e -> DynamicInvocationHandler.name(e.getKey()), e -> Coerce.toVncFunction(e.getValue())));
    }

    private static VncList toVncArgs(Object[] args) {
        if (args == null || args.length == 0) {
            return new VncList();
        }
        VncVal[] vncArgs = new VncVal[args.length];
        for (int ii = 0; ii < args.length; ++ii) {
            vncArgs[ii] = JavaInteropUtil.convertToVncVal(args[ii]);
        }
        return VncList.of(vncArgs);
    }
}

