/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.repackage.org.jline.terminal.Terminal;

public class ReplPrintStream
extends PrintStream {
    private final Terminal terminal;
    private final String colorEscape;

    public ReplPrintStream(String encoding, PrintStream ps, Terminal terminal, String colorEscape) throws UnsupportedEncodingException {
        super((OutputStream)ps, true, encoding);
        this.terminal = terminal;
        this.colorEscape = colorEscape;
    }

    @Override
    public void print(String s) {
        this.write(s);
    }

    @Override
    public void println(String s) {
        this.write(s + "\n");
    }

    private void write(String s) {
        if (this.colorEscape != null) {
            this.terminal.writer().print(this.colorEscape);
        }
        this.terminal.writer().print(s);
        if (this.colorEscape != null) {
            this.terminal.writer().print("\u001b[0m");
        }
        this.terminal.flush();
    }
}

