/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncInteger
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Integer value;

    public VncInteger(Integer v) {
        this(v, Constants.Nil);
    }

    public VncInteger(Long v) {
        this(v.intValue(), Constants.Nil);
    }

    public VncInteger(Integer v, VncVal meta) {
        super(meta);
        this.value = v;
    }

    @Override
    public VncInteger withMeta(VncVal meta) {
        return new VncInteger(this.value, meta);
    }

    public VncInteger negate() {
        return new VncInteger(this.value * -1);
    }

    public Integer getValue() {
        return this.value;
    }

    public Long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public int typeRank() {
        return 12;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).getValue());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).getIntValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(Numeric.doubleToInt((VncDouble)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToInt((VncBigDecimal)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncInteger other = (VncInteger)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString() + "I";
    }
}

