/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncKeyword
extends VncString
implements IVncFunction {
    private static final long serialVersionUID = -1848883965231344442L;

    public VncKeyword(String v) {
        this(v, Constants.Nil);
    }

    public VncKeyword(String v, VncVal meta) {
        super(v.startsWith(":") ? v.substring(1) : v, meta);
    }

    @Override
    public VncVal apply(VncList args) {
        FunctionsUtil.assertArity("keyword", args, 1, 2);
        VncVal first = args.first();
        if (first == Constants.Nil) {
            return args.second();
        }
        if (Types.isVncMap(first)) {
            VncMap map = (VncMap)first;
            if (args.size() == 1) {
                return map.get(this);
            }
            if (map.containsKey(this) == Constants.True) {
                return map.get(this);
            }
            return args.second();
        }
        if (Types.isVncSet(first)) {
            VncSet set = (VncSet)first;
            if (args.size() == 1) {
                return set.contains(this) ? this : Constants.Nil;
            }
            if (set.contains(this)) {
                return this;
            }
            return args.second();
        }
        throw new VncException(String.format("keyword as function does not allow arg %s.", Types.getType(first)));
    }

    @Override
    public VncKeyword withMeta(VncVal meta) {
        return new VncKeyword(this.getValue(), meta);
    }

    @Override
    public VncSymbol toSymbol() {
        return new VncSymbol(this.getValue());
    }

    @Override
    public int typeRank() {
        return 6;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncKeyword(o)) {
            return this.getValue().compareTo(((VncKeyword)o).getValue());
        }
        return super.compareTo(o);
    }

    @Override
    public String toString() {
        return ":" + this.getValue();
    }

    @Override
    public String toString(boolean print_readably) {
        return this.toString();
    }
}

