/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.util;

import java.io.Serializable;

public class Timer
implements Serializable {
    public final String name;
    public final int count;
    public final long elapsedNanos;
    private static final long serialVersionUID = -1L;

    public Timer(String name, long elapsedNanos) {
        this.name = name;
        this.count = 1;
        this.elapsedNanos = elapsedNanos;
    }

    public Timer(String name, int count, long elapsedNanos) {
        this.name = name;
        this.count = count;
        this.elapsedNanos = elapsedNanos;
    }

    public String getName() {
        return this.name;
    }

    public Timer add(long elapsedNanos) {
        return new Timer(this.name, this.count + 1, this.elapsedNanos + elapsedNanos);
    }

    public String toString() {
        return String.format("%s [%d]: %s", this.name, this.count, Timer.formatNanos(this.elapsedNanos));
    }

    public static String formatNanos(long nanos) {
        if (nanos < 1000L) {
            return Long.valueOf(nanos).toString() + " ns";
        }
        if (nanos < 1000000L) {
            return String.format("%.2f us", (double)nanos / 1000.0);
        }
        if (nanos < 9000000000L) {
            return String.format("%.2f ms", (double)nanos / 1000000.0);
        }
        return String.format("%.2f s ", (double)nanos / 1.0E9);
    }
}

