/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.GenSym;
import com.github.jlangch.venice.impl.types.VncSymbol;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;

public class AutoGenSym {
    private final Deque<Map<VncSymbol, VncSymbol>> stack = new ConcurrentLinkedDeque<Map<VncSymbol, VncSymbol>>();

    public void enterSyntaxQuote() {
        this.stack.push(new HashMap());
    }

    public void leaveSyntaxQuote() {
        this.stack.pop();
    }

    public boolean isWithinSyntaxQuote() {
        return !this.stack.isEmpty();
    }

    public boolean isAutoGenSymbol(VncSymbol sym) {
        String name = sym.getName();
        return name.length() > 1 && name.endsWith("#");
    }

    public VncSymbol lookup(VncSymbol sym) {
        if (this.stack.isEmpty()) {
            throw new VncException(String.format("Invalid autogen symbol (%s) usage outside of a syntax quote!", sym.getName()));
        }
        Map<VncSymbol, VncSymbol> autogenSymMap = this.stack.peek();
        return this.isAutoGenSymbol(sym) ? autogenSymMap.computeIfAbsent(sym, s -> this.genAutoSym((VncSymbol)s)) : sym;
    }

    private VncSymbol genAutoSym(VncSymbol sym) {
        return GenSym.generateAutoSym(this.stripTrailingHash(sym.getName()));
    }

    private String stripTrailingHash(String s) {
        return s.substring(0, s.length() - 1);
    }
}

