/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CustomTypeDefRegistry {
    private final Map<VncKeyword, VncCustomTypeDef> customTypes = new ConcurrentHashMap<VncKeyword, VncCustomTypeDef>();
    private final Map<VncKeyword, VncWrappingTypeDef> wrappedTypes = new ConcurrentHashMap<VncKeyword, VncWrappingTypeDef>();

    public void addCustomType(VncCustomTypeDef typeDef) {
        Objects.requireNonNull(typeDef);
        this.customTypes.put(typeDef.getType(), typeDef);
    }

    public void addWrappedType(VncWrappingTypeDef typeDef) {
        Objects.requireNonNull(typeDef);
        this.wrappedTypes.put(typeDef.getType(), typeDef);
    }

    public VncCustomTypeDef getCustomType(VncKeyword type) {
        Objects.requireNonNull(type);
        return this.customTypes.get(type);
    }

    public VncWrappingTypeDef getWrappedType(VncKeyword type) {
        Objects.requireNonNull(type);
        return this.wrappedTypes.get(type);
    }

    public boolean existsCustomType(VncKeyword type) {
        Objects.requireNonNull(type);
        return this.customTypes.get(type) != null;
    }

    public boolean existsWrappedType(VncKeyword type) {
        Objects.requireNonNull(type);
        return this.wrappedTypes.get(type) != null;
    }

    public VncCustomTypeDef removeCustomType(VncKeyword type) {
        Objects.requireNonNull(type);
        return this.customTypes.remove(type);
    }

    public VncWrappingTypeDef removeWrappedType(VncKeyword type) {
        Objects.requireNonNull(type);
        return this.wrappedTypes.remove(type);
    }

    public void clear() {
        this.customTypes.clear();
        this.wrappedTypes.clear();
    }
}

