/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.AssertionException;
import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.Version;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.CustomTypeDefRegistry;
import com.github.jlangch.venice.impl.CustomWrappableTypes;
import com.github.jlangch.venice.impl.Destructuring;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.LoadPath;
import com.github.jlangch.venice.impl.MetaUtil;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.NamespaceRegistry;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.Reader;
import com.github.jlangch.venice.impl.RecursionPoint;
import com.github.jlangch.venice.impl.ReservedSymbols;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.Functions;
import com.github.jlangch.venice.impl.sandbox.SandboxMaxExecutionTimeChecker;
import com.github.jlangch.venice.impl.specialforms.DefTypeForm;
import com.github.jlangch.venice.impl.specialforms.DocForm;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncMultiArityFunction;
import com.github.jlangch.venice.impl.types.VncMultiFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMutableSet;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CatchBlock;
import com.github.jlangch.venice.impl.util.Inspector;
import com.github.jlangch.venice.impl.util.MeterRegistry;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.impl.util.reflect.ReflectionAccessor;
import com.github.jlangch.venice.javainterop.AcceptAllInterceptor;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class VeniceInterpreter
implements Serializable {
    private static final long serialVersionUID = -8130740279914790685L;
    private static final VncKeyword PRE_CONDITION_KEY = new VncKeyword(":pre");
    private static final VncSymbol LOADED_MODULES_SYMBOL = new VncSymbol("*loaded-modules*");
    private static final VncSymbol LOADED_FILES_SYMBOL = new VncSymbol("*loaded-files*");
    private static final VncSymbol VERSION_SYMBOL = new VncSymbol("*version*");
    private static final VncSymbol NEWLINE_SYMBOL = new VncSymbol("*newline*");
    private static final VncSymbol LOAD_PATH_SYMBOL = new VncSymbol("*load-path*");
    private static final VncSymbol RUN_MODE_SYMBOL = new VncSymbol("*run-mode*");
    private static final VncSymbol MACRO_EXPAND_ON_LOAD_SYMBOL = new VncSymbol("*macroexpand-on-load*");
    private static final VncString VERSION = new VncString(Version.VERSION);
    private static final VncString NEWLINE = new VncString(System.lineSeparator());
    private static final Var VERSION_VAR = new Var(VERSION_SYMBOL, VERSION, false);
    private static final Var NEWLINE_VAR = new Var(NEWLINE_SYMBOL, NEWLINE, false);
    private static final Var DISABLED_MACRO_EXPAND_ON_LOAD_SYMBOL_VAR = new Var(MACRO_EXPAND_ON_LOAD_SYMBOL, VncBoolean.False, true);
    private final IInterceptor interceptor;
    private final List<String> loadPaths;
    private final SandboxMaxExecutionTimeChecker sandboxMaxExecutionTimeChecker;
    private final MeterRegistry meterRegistry;
    private final NamespaceRegistry nsRegistry = new NamespaceRegistry();
    private final CustomTypeDefRegistry typeDefRegistry = new CustomTypeDefRegistry();
    private final CustomWrappableTypes wrappableTypes = new CustomWrappableTypes();
    private final AtomicBoolean sealedSystemNS = new AtomicBoolean(false);

    public VeniceInterpreter() {
        this(new MeterRegistry(false), new AcceptAllInterceptor(), null);
    }

    public VeniceInterpreter(IInterceptor interceptor, List<String> loadPaths) {
        this(new MeterRegistry(false), interceptor, loadPaths);
    }

    public VeniceInterpreter(MeterRegistry perfmeter, IInterceptor interceptor, List<String> loadPaths) {
        this.sandboxMaxExecutionTimeChecker = new SandboxMaxExecutionTimeChecker();
        this.meterRegistry = perfmeter;
        this.interceptor = interceptor;
        this.loadPaths = loadPaths;
    }

    public void initNS() {
        this.nsRegistry.clear();
        Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent(Namespaces.NS_USER));
    }

    public void sealSystemNS() {
        this.sealedSystemNS.set(true);
    }

    public VncVal READ(String script, String filename) {
        long nanos = System.nanoTime();
        VncVal val = Reader.read_str(script, filename);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.read", System.nanoTime() - nanos);
        }
        return val;
    }

    public VncVal EVAL(VncVal ast, Env env) {
        long nanos = System.nanoTime();
        VncVal val = this.evaluate(ast, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.eval", System.nanoTime() - nanos);
        }
        return val;
    }

    public VncVal MACROEXPAND(VncVal ast, Env env, boolean macroexpand) {
        VncFunction macroexpandFn;
        if (macroexpand && (macroexpandFn = (VncFunction)env.getGlobalOrNull(new VncSymbol("core/macroexpand-all"))) != null) {
            return macroexpandFn.apply(VncList.of(ast));
        }
        return ast;
    }

    public VncVal RE(String script, String name, Env env) {
        return this.EVAL(this.READ(script, name), env);
    }

    public VncVal RE(String script, String name, Env env, boolean macroexpand) {
        VncVal ast = this.READ(script, name);
        if (macroexpand) {
            ast = this.MACROEXPAND(ast, env, macroexpand);
        }
        return this.EVAL(ast, env);
    }

    public String PRINT(VncVal exp) {
        return Printer.pr_str(exp, true);
    }

    public Env createEnv(boolean macroexpandOnLoad, boolean ansiTerminal, VncKeyword runMode) {
        return this.createEnv(null, macroexpandOnLoad, ansiTerminal, runMode);
    }

    public Env createEnv(List<String> preloadExtensionModules, boolean macroexpandOnLoad, boolean ansiTerminal, VncKeyword runMode) {
        this.sealedSystemNS.set(false);
        Env env = new Env(null);
        VncMutableSet loadedModules = new VncMutableSet(ModuleLoader.PRELOADED_MODULES);
        for (Map.Entry<VncVal, VncVal> e : Functions.functions.entrySet()) {
            VncSymbol sym = (VncSymbol)e.getKey();
            VncFunction fn = (VncFunction)e.getValue();
            env.setGlobal(new Var(sym, fn, fn.isRedefinable()));
        }
        env.setGlobal(VERSION_VAR);
        env.setGlobal(NEWLINE_VAR);
        env.setGlobal(new Var(new VncSymbol("*ansi-term*"), VncBoolean.of(ansiTerminal), false));
        env.setGlobal(new Var(LOAD_PATH_SYMBOL, LoadPath.toVncList(this.loadPaths), false));
        env.setGlobal(new Var(RUN_MODE_SYMBOL, runMode == null ? Constants.Nil : runMode, false));
        env.setGlobal(DISABLED_MACRO_EXPAND_ON_LOAD_SYMBOL_VAR);
        env.setGlobal(new Var(LOADED_MODULES_SYMBOL, loadedModules, true));
        env.setGlobal(new Var(LOADED_FILES_SYMBOL, new VncMutableSet(), true));
        this.initNS();
        this.loadModule("core", env, loadedModules);
        if (macroexpandOnLoad) {
            env.setGlobal(new Var(MACRO_EXPAND_ON_LOAD_SYMBOL, VncBoolean.True, true));
        }
        this.sealedSystemNS.set(true);
        VeniceInterpreter.toEmpty(preloadExtensionModules).forEach(m -> this.loadModule((String)m, env, loadedModules));
        return env;
    }

    public List<String> getAvailableModules() {
        ArrayList<String> modules = new ArrayList<String>(ModuleLoader.VALID_MODULES);
        modules.removeAll(Arrays.asList("core", "test", "http", "jackson"));
        Collections.sort(modules);
        return modules;
    }

    private void loadModule(String module, Env env, VncMutableSet loadedModules) {
        long nanos = System.nanoTime();
        this.RE("(eval " + ModuleLoader.loadModule(module) + ")", module, env);
        if (this.meterRegistry.enabled) {
            this.meterRegistry.record("venice.module." + module + ".load", System.nanoTime() - nanos);
        }
        loadedModules.add(new VncKeyword(module));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private VncVal evaluate(VncVal orig_ast, Env env) {
        recursionPoint = null;
        block198: while (true) {
            if (!Types.isVncList(orig_ast)) {
                return this.eval_ast(orig_ast, env);
            }
            expanded = this.macroexpand(orig_ast, env);
            if (!Types.isVncList(expanded)) {
                return this.eval_ast(expanded, env);
            }
            ast = (VncList)expanded;
            if (ast.isEmpty()) {
                return ast;
            }
            a0 = ast.first();
            var8_8 = a0sym = Types.isVncSymbol(a0) != false ? ((VncSymbol)a0).getName() : "__<*fn*>__";
            var9_9 = -1;
            switch (var8_8.hashCode()) {
                case 3211: {
                    if (!var8_8.equals("do")) break;
                    var9_9 = 0;
                    break;
                }
                case 99333: {
                    if (!var8_8.equals("def")) break;
                    var9_9 = 1;
                    break;
                }
                case 1545213958: {
                    if (!var8_8.equals("defonce")) break;
                    var9_9 = 2;
                    break;
                }
                case 1590555255: {
                    if (!var8_8.equals("def-dynamic")) break;
                    var9_9 = 3;
                    break;
                }
                case 654758631: {
                    if (!var8_8.equals("defmacro")) break;
                    var9_9 = 4;
                    break;
                }
                case 1545373887: {
                    if (!var8_8.equals("deftype")) break;
                    var9_9 = 5;
                    break;
                }
                case 479068581: {
                    if (!var8_8.equals("deftype-of")) break;
                    var9_9 = 6;
                    break;
                }
                case 1484: {
                    if (!var8_8.equals(".:")) break;
                    var9_9 = 7;
                    break;
                }
                case 3526655: {
                    if (!var8_8.equals("set!")) break;
                    var9_9 = 8;
                    break;
                }
                case 655363156: {
                    if (!var8_8.equals("defmulti")) break;
                    var9_9 = 9;
                    break;
                }
                case -1173127898: {
                    if (!var8_8.equals("defmethod")) break;
                    var9_9 = 10;
                    break;
                }
                case 3525: {
                    if (!var8_8.equals("ns")) break;
                    var9_9 = 11;
                    break;
                }
                case 1951546764: {
                    if (!var8_8.equals("ns-remove")) break;
                    var9_9 = 12;
                    break;
                }
                case -1180934629: {
                    if (!var8_8.equals("ns-unmap")) break;
                    var9_9 = 13;
                    break;
                }
                case -1184795739: {
                    if (!var8_8.equals("import")) break;
                    var9_9 = 14;
                    break;
                }
                case 1926037870: {
                    if (!var8_8.equals("imports")) break;
                    var9_9 = 15;
                    break;
                }
                case 1097368044: {
                    if (!var8_8.equals("resolve")) break;
                    var9_9 = 16;
                    break;
                }
                case 235003824: {
                    if (!var8_8.equals("var-get")) break;
                    var9_9 = 17;
                    break;
                }
                case 1957454356: {
                    if (!var8_8.equals("inspect")) break;
                    var9_9 = 18;
                    break;
                }
                case 820867430: {
                    if (!var8_8.equals("macroexpand")) break;
                    var9_9 = 19;
                    break;
                }
                case 107953788: {
                    if (!var8_8.equals("quote")) break;
                    var9_9 = 20;
                    break;
                }
                case 1896636553: {
                    if (!var8_8.equals("quasiquote")) break;
                    var9_9 = 21;
                    break;
                }
                case 99640: {
                    if (!var8_8.equals("doc")) break;
                    var9_9 = 22;
                    break;
                }
                case 3125404: {
                    if (!var8_8.equals("eval")) break;
                    var9_9 = 23;
                    break;
                }
                case 107035: {
                    if (!var8_8.equals("let")) break;
                    var9_9 = 24;
                    break;
                }
                case -108220795: {
                    if (!var8_8.equals("binding")) break;
                    var9_9 = 25;
                    break;
                }
                case -1383205247: {
                    if (!var8_8.equals("bound?")) break;
                    var9_9 = 26;
                    break;
                }
                case -173865320: {
                    if (!var8_8.equals("global-vars-count")) break;
                    var9_9 = 27;
                    break;
                }
                case 3327652: {
                    if (!var8_8.equals("loop")) break;
                    var9_9 = 28;
                    break;
                }
                case 108389165: {
                    if (!var8_8.equals("recur")) break;
                    var9_9 = 29;
                    break;
                }
                case 115131: {
                    if (!var8_8.equals("try")) break;
                    var9_9 = 30;
                    break;
                }
                case 1908075928: {
                    if (!var8_8.equals("try-with")) break;
                    var9_9 = 31;
                    break;
                }
                case 95772192: {
                    if (!var8_8.equals("dorun")) break;
                    var9_9 = 32;
                    break;
                }
                case 1827513477: {
                    if (!var8_8.equals("dobench")) break;
                    var9_9 = 33;
                    break;
                }
                case 3357: {
                    if (!var8_8.equals("if")) break;
                    var9_9 = 34;
                    break;
                }
                case 3272: {
                    if (!var8_8.equals("fn")) break;
                    var9_9 = 35;
                    break;
                }
                case 3449689: {
                    if (!var8_8.equals("prof")) break;
                    var9_9 = 36;
                    break;
                }
                case 338706135: {
                    if (!var8_8.equals("locking")) break;
                    var9_9 = 37;
                }
            }
            switch (var9_9) {
                case 0: {
                    expressions = ast.rest();
                    this.eval_ast(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case 1: {
                    name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    val = ast.third();
                    res = this.evaluate((VncVal)val, env).withMeta(name.getMeta());
                    env.setGlobal(new Var(name, res, true));
                    return name;
                }
                case 2: {
                    name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    val = ast.third();
                    res = this.evaluate((VncVal)val, env).withMeta(name.getMeta());
                    env.setGlobal(new Var(name, res, false));
                    return name;
                }
                case 3: {
                    name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    val = ast.third();
                    res = this.evaluate((VncVal)val, env).withMeta(name.getMeta());
                    env.setGlobalDynamic(name, res);
                    return name;
                }
                case 4: {
                    cs = new WithCallStack(CallFrame.fromVal("defmacro", ast));
                    val = null;
                    try {
                        res = this.defmacro_(ast, env);
                        return res;
                    }
                    catch (Throwable res) {
                        val = res;
                        throw res;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var13_44) {
                                    val.addSuppressed(var13_44);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 5: {
                    cs = new WithCallStack(CallFrame.fromVal("deftype", ast));
                    val = null;
                    try {
                        type = Coerce.toVncKeyword(ast.second());
                        fields = Coerce.toVncVector(ast.third());
                        validationFn = ast.size() == 4 ? Coerce.toVncFunction(this.evaluate(ast.fourth(), env)) : null;
                        var15_65 = DefTypeForm.defineCustomType(type, fields, validationFn, this.typeDefRegistry);
                        return var15_65;
                    }
                    catch (Throwable type) {
                        val = type;
                        throw type;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var16_68) {
                                    val.addSuppressed(var16_68);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 6: {
                    cs = new WithCallStack(CallFrame.fromVal("deftype-of", ast));
                    val = null;
                    try {
                        type = Coerce.toVncKeyword(ast.second());
                        baseType = Coerce.toVncKeyword(ast.third());
                        validationFn = ast.size() == 4 ? Coerce.toVncFunction(this.evaluate(ast.fourth(), env)) : null;
                        var15_65 = DefTypeForm.defineCustomWrapperType(type, baseType, validationFn, this.typeDefRegistry, this.wrappableTypes);
                        return var15_65;
                    }
                    catch (Throwable type) {
                        val = type;
                        throw type;
                    }
                    finally {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var16_69) {
                                    val.addSuppressed(var16_69);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 7: {
                    args = new ArrayList<VncVal>();
                    for (VncVal v : ast.rest().getList()) {
                        args.add(this.evaluate(v, env));
                    }
                    return DefTypeForm.createType(args, this.typeDefRegistry);
                }
                case 8: {
                    name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    globVar = env.getGlobalVarOrNull(name);
                    if (globVar != null) {
                        expr = ast.third();
                        val = this.evaluate(expr, env).withMeta(name.getMeta());
                        if (globVar instanceof DynamicVar) {
                            env.popGlobalDynamic(globVar.getName());
                            env.pushGlobalDynamic(globVar.getName(), val);
                        } else {
                            env.setGlobal(new Var(globVar.getName(), val, globVar.isOverwritable()));
                        }
                        return val;
                    }
                    cs = new WithCallStack(CallFrame.fromVal(name));
                    val = null;
                    try {
                        try {
                            throw new VncException(String.format("The global var or thread-local '%s' does not exist!", new Object[]{name.getName()}));
                        }
                        catch (Throwable validationFn) {
                            val = validationFn;
                            throw validationFn;
                        }
                    }
                    catch (Throwable var21_82) {
                        if (cs != null) {
                            if (val != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var22_83) {
                                    val.addSuppressed(var22_83);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var21_82;
                    }
                }
                case 9: {
                    name = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.second(), env));
                    dispatchFn /* !! */  = Types.isVncKeyword(ast.third()) != false ? (VncKeyword)ast.third() : (Types.isVncSymbol(ast.third()) != false ? Coerce.toVncFunction(env.get((VncSymbol)ast.third())) : this.fn_(Coerce.toVncList(ast.third()), env));
                    multiFn = new VncMultiFunction(name.getName(), dispatchFn /* !! */ );
                    env.setGlobal(new Var(name, multiFn, false));
                    return multiFn;
                }
                case 10: {
                    multiFnName = this.qualifySymbolWithCurrNS(Coerce.toVncSymbol(ast.second()));
                    multiFnVal = env.getGlobalOrNull(multiFnName);
                    if (multiFnVal == null) {
                        cs = new WithCallStack(CallFrame.fromVal(ast));
                        val = null;
                        try {
                            try {
                                throw new VncException(String.format("No multifunction '%s' defined for the method definition", new Object[]{multiFnName.getName()}));
                            }
                            catch (Throwable validationFn) {
                                val = validationFn;
                                throw validationFn;
                            }
                        }
                        catch (Throwable var23_84) {
                            if (cs != null) {
                                if (val != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var24_85) {
                                        val.addSuppressed(var24_85);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var23_84;
                        }
                    }
                    multiFn = Coerce.toVncMultiFunction(multiFnVal);
                    dispatchVal = ast.third();
                    params = Coerce.toVncVector(ast.fourth());
                    if (params.size() != multiFn.getParams().size()) {
                        cs = new WithCallStack(CallFrame.fromVal(ast));
                        var16_67 = null;
                        try {
                            try {
                                throw new VncException(String.format("A method definition for the multifunction '%s' must have %d parameters", new Object[]{multiFnName.getName(), multiFn.getParams().size()}));
                            }
                            catch (Throwable var17_74) {
                                var16_67 = var17_74;
                                throw var17_74;
                            }
                        }
                        catch (Throwable var25_86) {
                            if (cs != null) {
                                if (var16_67 != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var26_87) {
                                        var16_67.addSuppressed(var26_87);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var25_86;
                        }
                    }
                    preConditions = this.getFnPreconditions(ast.nth(4));
                    body = ast.slice(preConditions == null ? 4 : 5);
                    fn = this.buildFunction(multiFnName.getName(), params, body, preConditions, env);
                    return multiFn.addFn(dispatchVal, fn);
                }
                case 11: {
                    ns = Coerce.toVncSymbol(ast.second());
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        throw new VncException("Namespace '" + ns.getName() + "' cannot be reopened!");
                    }
                    Namespaces.setCurrentNamespace(this.nsRegistry.computeIfAbsent((VncSymbol)ns));
                    return ns;
                }
                case 12: {
                    ns = Namespaces.lookupNS(ast.second(), env);
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        throw new VncException("Namespace '" + ns.getName() + "' cannot be removed!");
                    }
                    env.removeGlobalSymbolsByNS((VncSymbol)ns);
                    this.nsRegistry.remove((VncSymbol)ns);
                    return Constants.Nil;
                }
                case 13: {
                    ns = Namespaces.lookupNS(ast.second(), env);
                    if (Namespaces.isSystemNS(ns.getName()) && this.sealedSystemNS.get()) {
                        throw new VncException("Cannot remove a symbol from namespace '" + ns.getName() + "'!");
                    }
                    sym = Namespaces.qualifySymbol((VncSymbol)ns, Coerce.toVncSymbol(ast.third()));
                    env.removeGlobalSymbol((VncSymbol)sym);
                    return Constants.Nil;
                }
                case 14: {
                    cs = new WithCallStack(CallFrame.fromVal("import", ast));
                    sym = null;
                    try {
                        ast.rest().forEach((Consumer<VncVal>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$evaluate$1(com.github.jlangch.venice.impl.types.VncVal ), (Lcom/github/jlangch/venice/impl/types/VncVal;)V)());
                        multiFn = Constants.Nil;
                        return multiFn;
                    }
                    catch (Throwable multiFn) {
                        sym = multiFn;
                        throw multiFn;
                    }
                    finally {
                        if (cs != null) {
                            if (sym != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    sym.addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 15: {
                    if (ast.size() == 1) {
                        return Namespaces.getCurrentNamespace().getJavaImportsAsVncList();
                    }
                    ns = Coerce.toVncSymbol(ast.second());
                    namespace = this.nsRegistry.get((VncSymbol)ns);
                    if (namespace != null) {
                        return namespace.getJavaImportsAsVncList();
                    }
                    cs = new WithCallStack(CallFrame.fromVal("imports", ast));
                    dispatchVal = null;
                    try {
                        try {
                            throw new VncException(String.format("The namespace '%s' does not exist", new Object[]{ns.toString()}));
                        }
                        catch (Throwable params) {
                            dispatchVal = params;
                            throw params;
                        }
                    }
                    catch (Throwable var29_90) {
                        if (cs != null) {
                            if (dispatchVal != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var30_91) {
                                    dispatchVal.addSuppressed(var30_91);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var29_90;
                    }
                }
                case 16: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case 17: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return env.getOrNil(sym);
                }
                case 18: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return Inspector.inspect(env.get(sym));
                }
                case 19: {
                    cs = new WithCallStack(CallFrame.fromVal("macroexpand", ast));
                    namespace = null;
                    try {
                        cs = this.macroexpand(this.evaluate(ast.second(), env), env);
                        return cs;
                    }
                    catch (Throwable cs) {
                        namespace = cs;
                        throw cs;
                    }
                    finally {
                        if (cs != null) {
                            if (namespace != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable dispatchVal) {
                                    namespace.addSuppressed(dispatchVal);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 20: {
                    return ast.second();
                }
                case 21: {
                    orig_ast = VeniceInterpreter.quasiquote(ast.second());
                    break;
                }
                case 22: {
                    cs = new WithCallStack(CallFrame.fromVal("doc", ast));
                    namespace = null;
                    doc = DocForm.doc(ast.second(), env, this.typeDefRegistry);
                    orig_ast = VncTinyList.of(new VncVal[]{new VncSymbol("println"), doc});
                    if (cs == null) continue block198;
                    if (namespace == null) ** GOTO lbl472
                    try {
                        cs.close();
                    }
                    catch (Throwable doc) {
                        namespace.addSuppressed(doc);
                    }
                    continue block198;
lbl472:
                    // 1 sources

                    cs.close();
                    break;
                    catch (Throwable doc) {
                        try {
                            namespace = doc;
                            throw doc;
                        }
                        catch (Throwable var33_94) {
                            if (cs != null) {
                                if (namespace != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var34_95) {
                                        namespace.addSuppressed(var34_95);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var33_94;
                        }
                    }
                }
                case 23: {
                    ns = Namespaces.getCurrentNamespace();
                    try {
                        namespace = this.evaluate(Coerce.toVncSequence(this.eval_ast(ast.rest(), env)).last(), env);
                        return namespace;
                    }
                    finally {
                        Namespaces.setCurrentNamespace((Namespace)ns);
                    }
                }
                case 24: {
                    env = new Env(env);
                    bindings = Coerce.toVncVector(ast.second());
                    expressions = ast.slice(2);
                    for (i = 0; i < bindings.size(); i += 2) {
                        sym = bindings.nth(i);
                        val = this.evaluate(bindings.nth(i + 1), env);
                        env.addLocalBindings(Destructuring.destructure(sym, val));
                    }
                    if (expressions.isEmpty()) {
                        orig_ast = Constants.Nil;
                        break;
                    }
                    this.eval_ast(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case 25: {
                    return this.binding_(ast, new Env(env));
                }
                case 26: {
                    sym = Coerce.toVncSymbol(this.evaluate(ast.second(), env));
                    return VncBoolean.of(env.isBound(sym));
                }
                case 27: {
                    return new VncLong(env.globalsCount());
                }
                case 28: {
                    recursionPoint = null;
                    env = new Env(env);
                    bindings = Coerce.toVncVector(ast.second());
                    expressions = ast.slice(2);
                    bindingNames = new ArrayList<VncSymbol>();
                    for (i = 0; i < bindings.size(); i += 2) {
                        sym = bindings.nth(i);
                        val = this.evaluate(bindings.nth(i + 1), env);
                        env.setLocal((VncSymbol)sym, val);
                        bindingNames.add((VncSymbol)sym);
                    }
                    recursionPoint = new RecursionPoint(new VncList(bindingNames), (VncList)expressions, env);
                    if (expressions.size() == 1) {
                        orig_ast = expressions.first();
                        break;
                    }
                    this.eval_ast(expressions.butlast(), env);
                    orig_ast = expressions.last();
                    break;
                }
                case 29: {
                    if (recursionPoint == null) {
                        cs = new WithCallStack(CallFrame.fromVal("recur", ast));
                        expressions = null;
                        try {
                            try {
                                throw new VncException("The recur expression is not in tail position!");
                            }
                            catch (Throwable bindingNames) {
                                expressions = bindingNames;
                                throw bindingNames;
                            }
                        }
                        catch (Throwable var36_97) {
                            if (cs != null) {
                                if (expressions != null) {
                                    try {
                                        cs.close();
                                    }
                                    catch (Throwable var37_98) {
                                        expressions.addSuppressed(var37_98);
                                    }
                                } else {
                                    cs.close();
                                }
                            }
                            throw var36_97;
                        }
                    }
                    recur_env = recursionPoint.getLoopEnv();
                    switch (ast.size()) {
                        case 2: {
                            recur_env.setLocal(recursionPoint.getLoopBindingName(0), this.evaluate(ast.second(), env));
                            break;
                        }
                        case 3: {
                            v1 = this.evaluate(ast.second(), env);
                            v2 = this.evaluate(ast.third(), env);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(0), v1);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(1), v2);
                            break;
                        }
                        case 4: {
                            v1_ = this.evaluate(ast.second(), env);
                            v2_ = this.evaluate(ast.third(), env);
                            v3_ = this.evaluate(ast.fourth(), env);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(0), v1_);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(1), v2_);
                            recur_env.setLocal(recursionPoint.getLoopBindingName(2), v3_);
                            break;
                        }
                        default: {
                            values = ast.rest();
                            newValues = new VncVal[values.size()];
                            for (kk = 0; kk < values.size(); ++kk) {
                                newValues[kk++] = this.evaluate(values.nth(kk), env);
                            }
                            for (ii = 0; ii < recursionPoint.getLoopBindingNamesCount(); ++ii) {
                                recur_env.setLocal(recursionPoint.getLoopBindingName(ii), newValues[ii]);
                            }
                        }
                    }
                    expressions = recursionPoint.getLoopExpressions();
                    env = recur_env;
                    if (expressions.size() > 1) {
                        this.eval_ast(expressions.butlast(), env);
                    }
                    orig_ast = expressions.last();
                    break;
                }
                case 30: {
                    cs = new WithCallStack(CallFrame.fromVal("try", ast));
                    expressions = null;
                    try {
                        v2 = this.try_(ast, new Env(env));
                        return v2;
                    }
                    catch (Throwable v2) {
                        expressions = v2;
                        throw v2;
                    }
                    finally {
                        if (cs != null) {
                            if (expressions != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable v1_) {
                                    expressions.addSuppressed(v1_);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 31: {
                    cs = new WithCallStack(CallFrame.fromVal("try-with", ast));
                    expressions = null;
                    try {
                        v2 = this.try_with_(ast, new Env(env));
                        return v2;
                    }
                    catch (Throwable v2) {
                        expressions = v2;
                        throw v2;
                    }
                    finally {
                        if (cs != null) {
                            if (expressions != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable v1_) {
                                    expressions.addSuppressed(v1_);
                                }
                            } else {
                                cs.close();
                            }
                        }
                    }
                }
                case 32: {
                    return this.dorun_(ast, env);
                }
                case 33: {
                    return this.dobench_(ast, env);
                }
                case 34: {
                    cond = this.evaluate(ast.second(), env);
                    if (VncBoolean.isFalse(cond) || cond == Constants.Nil) {
                        if (ast.size() > 3) {
                            orig_ast = ast.nth(3);
                            break;
                        }
                        return Constants.Nil;
                    }
                    orig_ast = ast.nth(2);
                    break;
                }
                case 35: {
                    return this.fn_(ast, env);
                }
                case 36: {
                    return this.prof_(ast, env);
                }
                case 37: {
                    return this.locking_(ast, env);
                }
                default: {
                    el = (VncList)this.eval_ast(ast, env);
                    elFirst = el.first();
                    elArgs = el.rest();
                    if (Types.isVncFunction(elFirst)) {
                        fn = (VncFunction)elFirst;
                        fnName = fn.getQualifiedName();
                        nanos = System.nanoTime();
                        this.interceptor.validateVeniceFunction(fnName);
                        this.checkInterrupted(fnName);
                        if (this.sandboxMaxExecutionTimeChecker.enabled) {
                            this.sandboxMaxExecutionTimeChecker.check();
                        }
                        callStack = ThreadLocalMap.getCallStack();
                        callFrame = CallFrame.fromFunction(fn, a0);
                        try {
                            callStack.push(callFrame);
                            var20_81 = fn.apply(elArgs);
                            return var20_81;
                        }
                        finally {
                            callStack.pop();
                            this.checkInterrupted(fnName);
                            if (this.sandboxMaxExecutionTimeChecker.enabled) {
                                this.sandboxMaxExecutionTimeChecker.check();
                            }
                            if (this.meterRegistry.enabled) {
                                this.meterRegistry.record(fn.getQualifiedName(), System.nanoTime() - nanos);
                            }
                        }
                    }
                    if (Types.isIVncFunction(elFirst)) {
                        return ((IVncFunction)elFirst).apply(elArgs);
                    }
                    cs = new WithCallStack(CallFrame.fromVal(ast));
                    var15_65 = null;
                    try {
                        try {
                            throw new VncException(String.format("Not a function or keyword/map used as function: '%s'", new Object[]{this.PRINT(elFirst)}));
                        }
                        catch (Throwable var16_71) {
                            var15_65 = var16_71;
                            throw var16_71;
                        }
                    }
                    catch (Throwable var43_104) {
                        if (cs != null) {
                            if (var15_65 != null) {
                                try {
                                    cs.close();
                                }
                                catch (Throwable var44_105) {
                                    var15_65.addSuppressed(var44_105);
                                }
                            } else {
                                cs.close();
                            }
                        }
                        throw var43_104;
                    }
                }
            }
        }
    }

    private VncVal eval_ast(VncVal ast, Env env) {
        if (Types.isVncSymbol(ast)) {
            return env.get((VncSymbol)ast);
        }
        if (ast.isVncCollection()) {
            if (Types.isVncSequence(ast)) {
                VncSequence seq = (VncSequence)ast;
                switch (seq.size()) {
                    case 0: {
                        return seq;
                    }
                    case 1: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env));
                    }
                    case 2: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env));
                    }
                    case 3: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env));
                    }
                    case 4: {
                        return seq.withVariadicValues(this.evaluate(seq.first(), env), this.evaluate(seq.second(), env), this.evaluate(seq.third(), env), this.evaluate(seq.fourth(), env));
                    }
                }
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : seq.getList()) {
                    vals.add(this.evaluate(v, env));
                }
                return seq.withValues(vals);
            }
            if (Types.isVncMap(ast)) {
                VncMap map = (VncMap)ast;
                HashMap<VncVal, VncVal> vals = new HashMap<VncVal, VncVal>();
                for (Map.Entry<VncVal, VncVal> e : map.getMap().entrySet()) {
                    vals.put(this.evaluate(e.getKey(), env), this.evaluate(e.getValue(), env));
                }
                return map.withValues(vals);
            }
            if (Types.isVncSet(ast)) {
                VncSet set = (VncSet)ast;
                ArrayList<VncVal> vals = new ArrayList<VncVal>();
                for (VncVal v : set.getList()) {
                    vals.add(this.evaluate(v, env));
                }
                return set.withValues(vals);
            }
            return ast;
        }
        return ast;
    }

    private VncVal macroexpand(VncVal ast, Env env) {
        VncVal fn;
        VncVal a0;
        long nanos = System.nanoTime();
        VncVal ast_ = ast;
        boolean expanded = false;
        while (Types.isVncSymbol(a0 = ((VncList)ast_).first()) && Types.isVncMacro(fn = env.getGlobalOrNull((VncSymbol)a0))) {
            VncFunction macro = (VncFunction)fn;
            this.interceptor.validateVeniceFunction(macro.getQualifiedName());
            expanded = true;
            if (Types.isVncList(ast_ = macro.apply(((VncList)ast_).rest()))) continue;
        }
        if (expanded && this.meterRegistry.enabled) {
            this.meterRegistry.record("macroexpand", System.nanoTime() - nanos);
        }
        return ast_;
    }

    private static boolean is_pair(VncVal x) {
        return Types.isVncSequence(x) && !((VncSequence)x).isEmpty();
    }

    private static VncVal quasiquote(VncVal ast) {
        VncVal a00;
        if (!VeniceInterpreter.is_pair(ast)) {
            return VncTinyList.of(new VncSymbol("quote"), ast);
        }
        VncVal a0 = Coerce.toVncSequence(ast).first();
        if (Types.isVncSymbol(a0) && ((VncSymbol)a0).getName().equals("unquote")) {
            return ((VncSequence)ast).second();
        }
        if (VeniceInterpreter.is_pair(a0) && Types.isVncSymbol(a00 = Coerce.toVncSequence(a0).first()) && ((VncSymbol)a00).getName().equals("splice-unquote")) {
            return VncTinyList.of(new VncSymbol("concat"), Coerce.toVncSequence(a0).second(), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
        }
        return VncTinyList.of(new VncSymbol("cons"), VeniceInterpreter.quasiquote(a0), VeniceInterpreter.quasiquote(((VncSequence)ast).rest()));
    }

    private VncFunction defmacro_(VncList ast, Env env) {
        int argPos = 1;
        VncSymbol macroName = this.qualifySymbolWithCurrNS(this.evaluateSymbolMetaData(ast.nth(argPos++), env));
        VncVal meta = macroName.getMeta();
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        String name = macroName.getName();
        String ns = Namespaces.getNamespace(macroName.getName());
        if (ns == null && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS().getName())) {
            name = ns + "/" + name;
        }
        meta = MetaUtil.addMetaVal(meta, MetaUtil.NS, new VncString(ns), MetaUtil.MACRO, VncBoolean.True);
        VncSymbol macroName_ = new VncSymbol(name, meta);
        if (Types.isVncVector(paramsOrSig)) {
            VncVector params = (VncVector)paramsOrSig;
            int n = ++argPos;
            ++argPos;
            VncVal body = ast.nth(n);
            VncFunction macroFn = this.buildFunction(macroName_.getName(), params, VncTinyList.of(body), null, env);
            macroFn.setMacro();
            macroFn.setNamespace(ns);
            env.setGlobal(new Var(macroName_, macroFn.withMeta(meta), false));
            return macroFn;
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList fnSig = Coerce.toVncList(s);
            VncVector fnParams = Coerce.toVncVector(fnSig.nth(pos++));
            VncList fnBody = fnSig.slice(pos);
            fns.add(this.buildFunction(macroName_.getName() + "-arity-" + fnParams.size(), fnParams, fnBody, null, env));
        });
        VncMultiArityFunction macroFn = new VncMultiArityFunction(macroName_.getName(), fns).withMeta(meta);
        macroFn.setMacro();
        macroFn.setNamespace(ns);
        env.setGlobal(new Var(macroName_, macroFn, false));
        return macroFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dorun_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dorun", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dorun requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        long count = Coerce.toVncLong(ast.second()).getValue();
        if (count <= 0L) {
            return Constants.Nil;
        }
        VncVal expr = ast.third();
        try {
            VncVal first = this.evaluate(expr, env);
            int ii = 1;
            while ((long)ii < count) {
                VncVal result = this.evaluate(expr, env);
                this.checkInterrupted("dorun");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncVal vncVal = first;
            return vncVal;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal dobench_(VncList ast, Env env) {
        if (ast.size() != 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("dobench", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("dobench requires two arguments a count and an expression to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        try {
            long count = Coerce.toVncLong(ast.second()).getValue();
            VncVal expr = ast.third();
            ArrayList<VncLong> elapsed = new ArrayList<VncLong>();
            int ii = 0;
            while ((long)ii < count) {
                long start = System.nanoTime();
                VncVal result = this.evaluate(expr, env);
                long end = System.nanoTime();
                elapsed.add(new VncLong(end - start));
                this.checkInterrupted("dobench");
                ThreadLocalMap.set(new VncKeyword("*benchmark-val*"), result);
                ++ii;
            }
            VncList vncList = new VncList(elapsed);
            return vncList;
        }
        finally {
            ThreadLocalMap.remove(new VncKeyword("*benchmark-val*"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal locking_(VncList ast, Env env) {
        VncVal mutex;
        if (ast.size() < 3) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal("locking", ast));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException("locking requires a lockee and one or more expressions to run");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        VncVal vncVal = mutex = this.evaluate(ast.second(), env);
        synchronized (vncVal) {
            return this.evaluateBody(ast.slice(2), env);
        }
    }

    private VncFunction fn_(VncList ast, Env env) {
        VncSymbol name;
        int argPos;
        if (Types.isVncSymbol(ast.second())) {
            argPos = 2;
            name = (VncSymbol)ast.second();
        } else {
            argPos = 1;
            name = new VncSymbol(VncFunction.createAnonymousFuncName());
        }
        VncSymbol fnName = this.qualifySymbolWithCurrNS(name);
        ReservedSymbols.validateNotReservedSymbol(fnName);
        VncSequence paramsOrSig = Coerce.toVncSequence(ast.nth(argPos));
        if (Types.isVncVector(paramsOrSig)) {
            VncVector preConditions;
            VncVector params = (VncVector)paramsOrSig;
            if ((preConditions = this.getFnPreconditions(ast.nth(++argPos))) != null) {
                ++argPos;
            }
            VncList body = ast.slice(argPos);
            return this.buildFunction(fnName.getName(), params, body, preConditions, env);
        }
        ArrayList<VncFunction> fns = new ArrayList<VncFunction>();
        ast.slice(argPos).forEach(s -> {
            int pos = 0;
            VncList sig = Coerce.toVncList(s);
            VncVector params = Coerce.toVncVector(sig.nth(pos++));
            VncVector preConditions = this.getFnPreconditions(sig.nth(pos));
            if (preConditions != null) {
                ++pos;
            }
            VncList body = sig.slice(pos);
            fns.add(this.buildFunction(fnName.getName(), params, body, preConditions, env));
        });
        return new VncMultiArityFunction(fnName.getName(), fns);
    }

    private VncVal prof_(VncList ast, Env env) {
        if (Types.isVncKeyword(ast.second())) {
            VncKeyword cmd = (VncKeyword)ast.second();
            switch (cmd.getValue()) {
                case "on": 
                case "enable": {
                    this.meterRegistry.enable();
                    return new VncKeyword("on");
                }
                case "off": 
                case "disable": {
                    this.meterRegistry.disable();
                    return new VncKeyword("off");
                }
                case "status": {
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear": {
                    this.meterRegistry.reset();
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "clear-all-but": {
                    this.meterRegistry.resetAllBut(Coerce.toVncSequence(ast.third()));
                    return new VncKeyword(this.meterRegistry.isEnabled() ? "on" : "off");
                }
                case "data": {
                    return this.meterRegistry.getVncTimerData();
                }
                case "data-formatted": {
                    String title = ast.size() == 3 ? Coerce.toVncString(ast.third()).getValue() : "Metrics";
                    return new VncString(this.meterRegistry.getTimerDataFormatted(title));
                }
            }
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal("prof", ast));
        Object object = null;
        try {
            try {
                throw new VncException("Function 'prof' expects a single keyword argument: :on, :off, :status, :clear, :clear-all-but, :data, or :data-formatted");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (cs != null) {
                if (object != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable2) {
                        ((Throwable)object).addSuppressed(throwable2);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal binding_(VncList ast, Env env) {
        VncSequence bindings = Coerce.toVncSequence(ast.second());
        VncList expressions = ast.slice(2);
        ArrayList<Var> vars = new ArrayList<Var>();
        for (int i = 0; i < bindings.size(); i += 2) {
            VncVal sym = bindings.nth(i);
            VncVal val = this.evaluate(bindings.nth(i + 1), env);
            for (Binding b : Destructuring.destructure(sym, val)) {
                vars.add(new Var(b.sym, b.val));
            }
        }
        try {
            vars.forEach(v -> env.pushGlobalDynamic(v.getName(), v.getVal()));
            this.eval_ast(expressions.butlast(), env);
            VncVal vncVal = this.evaluate(expressions.last(), env);
            return vncVal;
        }
        finally {
            vars.forEach(v -> env.popGlobalDynamic(v.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_(VncList ast, Env env) {
        VncVal result = Constants.Nil;
        try {
            result = this.evaluateBody(this.getTryBody(ast), env);
        }
        catch (Throwable th) {
            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
            if (catchBlock == null) {
                throw th;
            }
            env.setLocal(catchBlock.getExSym(), new VncJavaObject(th));
            VncVal vncVal = this.evaluateBody(catchBlock.getBody(), env);
            return vncVal;
        }
        finally {
            VncList finallyBlock = this.findFirstFinallyBlock(ast);
            if (finallyBlock != null) {
                this.eval_ast(finallyBlock.rest(), env);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VncVal try_with_(VncList ast, Env env) {
        VncVal result;
        block12: {
            VncSequence bindings = Coerce.toVncSequence(ast.second());
            ArrayList<Binding> boundResources = new ArrayList<Binding>();
            for (int i = 0; i < bindings.size(); i += 2) {
                VncVal sym = bindings.nth(i);
                VncVal val = this.evaluate(bindings.nth(i + 1), env);
                if (!Types.isVncSymbol(sym)) {
                    throw new VncException(String.format("Invalid 'try-with' destructuring symbol value type %s. Expected symbol.", Types.getType(sym)));
                }
                env.setLocal((VncSymbol)sym, val);
                boundResources.add(new Binding((VncSymbol)sym, val));
            }
            result = Constants.Nil;
            try {
                try {
                    result = this.evaluateBody(this.getTryBody(ast), env);
                    VncList finallyBlock = this.findFirstFinallyBlock(ast);
                    if (finallyBlock == null) break block12;
                    this.eval_ast(finallyBlock.rest(), env);
                }
                catch (Throwable th) {
                    VncVal vncVal;
                    block13: {
                        try {
                            CatchBlock catchBlock = this.findCatchBlockMatchingThrowable(ast, th);
                            if (catchBlock == null) {
                                throw th;
                            }
                            env.setLocal(catchBlock.getExSym(), new VncJavaObject(th));
                            vncVal = this.evaluateBody(catchBlock.getBody(), env);
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock == null) break block13;
                            this.eval_ast(finallyBlock.rest(), env);
                        }
                        catch (Throwable throwable) {
                            VncList finallyBlock = this.findFirstFinallyBlock(ast);
                            if (finallyBlock != null) {
                                this.eval_ast(finallyBlock.rest(), env);
                            }
                            throw throwable;
                        }
                    }
                    Collections.reverse(boundResources);
                    boundResources.stream().forEach(b -> {
                        VncVal resource = b.val;
                        if (Types.isVncJavaObject(resource)) {
                            Object r = ((VncJavaObject)resource).getDelegate();
                            if (r instanceof AutoCloseable) {
                                try {
                                    ((AutoCloseable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                            if (r instanceof Closeable) {
                                try {
                                    ((Closeable)r).close();
                                }
                                catch (Exception ex) {
                                    throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                                }
                            }
                        }
                    });
                    return vncVal;
                }
            }
            finally {
                Collections.reverse(boundResources);
                boundResources.stream().forEach(b -> {
                    VncVal resource = b.val;
                    if (Types.isVncJavaObject(resource)) {
                        Object r = ((VncJavaObject)resource).getDelegate();
                        if (r instanceof AutoCloseable) {
                            try {
                                ((AutoCloseable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                        if (r instanceof Closeable) {
                            try {
                                ((Closeable)r).close();
                            }
                            catch (Exception ex) {
                                throw new VncException(String.format("'try-with' failed to close resource %s.", b.sym.getName()));
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    private VncList getTryBody(VncList ast) {
        String symName;
        VncVal first;
        VncVal e;
        ArrayList<VncVal> body = new ArrayList<VncVal>();
        Iterator<VncVal> iterator = ast.rest().getList().iterator();
        while (!(!iterator.hasNext() || Types.isVncList(e = iterator.next()) && Types.isVncSymbol(first = ((VncList)e).first()) && ((symName = ((VncSymbol)first).getName()).equals("catch") || symName.equals("finally")))) {
            body.add(e);
        }
        return new VncList(body);
    }

    private CatchBlock findCatchBlockMatchingThrowable(VncList blocks, Throwable th) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("catch") || !this.isCatchBlockMatchingThrowable(block, th)) continue;
            return new CatchBlock(Coerce.toVncSymbol(block.nth(2)), block.slice(3));
        }
        return null;
    }

    private boolean isCatchBlockMatchingThrowable(VncList block, Throwable th) {
        String className = this.resolveClassName(((VncString)block.second()).getValue());
        Class<?> targetClass = ReflectionAccessor.classForName(className);
        return targetClass.isAssignableFrom(th.getClass());
    }

    private VncList findFirstFinallyBlock(VncList blocks) {
        for (VncVal b : blocks.getList()) {
            VncList block;
            VncVal first;
            if (!Types.isVncList(b) || !Types.isVncSymbol(first = (block = (VncList)b).first()) || !((VncSymbol)first).getName().equals("finally")) continue;
            return block;
        }
        return null;
    }

    private VncFunction buildFunction(final String name, final VncVector params, final VncList body, final VncVector preConditions, final Env env) {
        final Namespace ns = Namespaces.getCurrentNamespace();
        return new VncFunction(name, params){
            private static final long serialVersionUID = -1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VncVal apply(VncList args) {
                Env localEnv = new Env(env);
                Namespace curr_ns = Namespaces.getCurrentNamespace();
                try {
                    if (!name.equals("macroexpand-all")) {
                        Namespaces.setCurrentNamespace(ns);
                    }
                    localEnv.addLocalBindings(Destructuring.destructure(params, args));
                    VeniceInterpreter.this.validateFnPreconditions(name, preConditions, localEnv);
                    VncVal vncVal = VeniceInterpreter.this.evaluateBody(body, localEnv);
                    return vncVal;
                }
                finally {
                    Namespaces.setCurrentNamespace(curr_ns);
                }
            }

            @Override
            public VncVal getBody() {
                return body;
            }
        };
    }

    private VncVector getFnPreconditions(VncVal prePostConditions) {
        VncVal val;
        if (Types.isVncMap(prePostConditions) && Types.isVncVector(val = ((VncMap)prePostConditions).get(PRE_CONDITION_KEY))) {
            return (VncVector)val;
        }
        return null;
    }

    private boolean isFnConditionTrue(VncVal result) {
        return Types.isVncSequence(result) ? VncBoolean.isTrue(((VncSequence)result).first()) : VncBoolean.isTrue(result);
    }

    private void validateFnPreconditions(String fnName, VncVector preConditions, Env env) {
        if (preConditions != null && !preConditions.isEmpty()) {
            Env local = new Env(env);
            for (VncVal v : preConditions.getList()) {
                if (this.isFnConditionTrue(this.evaluate(v, local))) continue;
                WithCallStack cs = new WithCallStack(CallFrame.fromVal(fnName, v));
                Throwable throwable = null;
                try {
                    try {
                        throw new AssertionException(String.format("pre-condition assert failed: %s", ((VncString)CoreFunctions.str.apply(VncTinyList.of(v))).getValue()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private VncVal evaluateBody(VncList body, Env env) {
        if (body.isEmpty()) {
            return Constants.Nil;
        }
        if (body.size() == 1) {
            return this.evaluate(body.first(), env);
        }
        if (body.size() == 2) {
            this.evaluate(body.first(), env);
            return this.evaluate(body.last(), env);
        }
        this.eval_ast(body.butlast(), env);
        return this.evaluate(body.last(), env);
    }

    private String resolveClassName(String className) {
        return Namespaces.getCurrentNamespace().getJavaImports().resolveClassName(className);
    }

    private void checkInterrupted(String fnName) {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted while processing function " + fnName);
        }
    }

    private VncSymbol evaluateSymbolMetaData(VncVal symVal, Env env) {
        VncSymbol sym = Coerce.toVncSymbol(symVal);
        ReservedSymbols.validateNotReservedSymbol(sym);
        return sym.withMeta(this.evaluate(sym.getMeta(), env));
    }

    private static <T> List<T> toEmpty(List<T> list) {
        return list == null ? new ArrayList() : list;
    }

    private VncSymbol qualifySymbolWithCurrNS(VncSymbol sym) {
        if (sym == null) {
            return null;
        }
        if (Namespaces.isQualified(sym)) {
            return new VncSymbol(sym.getName(), MetaUtil.setNamespace(sym.getMeta(), Namespaces.getNamespace(sym.getName())));
        }
        VncSymbol ns = Namespaces.getCurrentNS();
        return new VncSymbol(Namespaces.isCoreNS(ns) ? sym.getName() : ns.getName() + "/" + sym.getName(), MetaUtil.setNamespace(sym.getMeta(), ns.getName()));
    }

    private static /* synthetic */ void lambda$evaluate$1(VncVal i) {
        Namespaces.getCurrentNamespace().getJavaImports().add(Coerce.toVncString(i).getValue());
    }
}

