/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.CustomTypeDefRegistry;
import com.github.jlangch.venice.impl.CustomWrappableTypes;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncCustomType;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeFieldDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class DefTypeForm {
    public static VncVal defineCustomType(VncKeyword type, VncVector fields, VncFunction validationFn, CustomTypeDefRegistry registry) {
        if (fields.isEmpty() || fields.size() % 2 != 0) {
            throw new VncException("deftype invalid field definition.");
        }
        ArrayList<VncCustomTypeFieldDef> fieldDefs = new ArrayList<VncCustomTypeFieldDef>();
        List<VncVal> fieldItems = fields.getList();
        for (int ii = 0; ii < fieldItems.size() / 2; ++ii) {
            fieldDefs.add(new VncCustomTypeFieldDef(new VncKeyword(Coerce.toVncSymbol(fieldItems.get(ii * 2)).getName()), Types.qualify(Namespaces.NS_CORE, Coerce.toVncKeyword(fieldItems.get(ii * 2 + 1))), ii));
        }
        VncKeyword qualifiedType = Types.qualify(Namespaces.getCurrentNS(), type);
        if (registry.existsCustomType(qualifiedType)) {
            throw new VncException(String.format("deftype: the type :%s already exists.", qualifiedType.getValue()));
        }
        registry.addCustomType(new VncCustomTypeDef(qualifiedType, fieldDefs, validationFn));
        return qualifiedType;
    }

    public static VncVal defineCustomWrapperType(VncKeyword type, VncKeyword baseType, VncFunction validationFn, CustomTypeDefRegistry registry, CustomWrappableTypes wrappableTypes) {
        VncKeyword qualifiedType = Types.qualify(Namespaces.getCurrentNS(), type);
        VncKeyword qualifiedBaseType = Types.qualify(Namespaces.NS_CORE, baseType);
        if (!wrappableTypes.isWrappable(qualifiedBaseType)) {
            throw new VncException(String.format("deftype-of: the type :%s can not be wrapped.", baseType.getValue()));
        }
        if (registry.existsWrappedType(qualifiedType)) {
            throw new VncException(String.format("deftype: the type :%s already exists.", qualifiedType.getValue()));
        }
        registry.addWrappedType(new VncWrappingTypeDef(qualifiedType, qualifiedBaseType, validationFn));
        return qualifiedType;
    }

    public static VncVal createType(List<VncVal> args, CustomTypeDefRegistry registry) {
        VncKeyword type = Coerce.toVncKeyword(args.get(0));
        VncKeyword qualifiedType = Types.qualify(Namespaces.getCurrentNS(), type);
        VncCustomTypeDef customTypeDef = registry.getCustomType(qualifiedType);
        if (customTypeDef != null) {
            List<VncVal> typeArgs = args.subList(1, args.size());
            return DefTypeForm.createCustomType(customTypeDef, typeArgs, registry);
        }
        VncWrappingTypeDef wrappedTypeDef = registry.getWrappedType(qualifiedType);
        if (wrappedTypeDef != null) {
            return DefTypeForm.createWrappedType(wrappedTypeDef, args.get(1), registry);
        }
        throw new VncException(String.format("the custom type :%s is not defined.", qualifiedType.getValue()));
    }

    public static VncVal createCustomType(VncCustomTypeDef typeDef, List<VncVal> typeArgs, CustomTypeDefRegistry registry) {
        if (typeDef.count() != typeArgs.size()) {
            throw new VncException(String.format("deftype: the type :%s requires %d args. %d have been passed", typeDef.getType().getValue(), typeDef.count(), typeArgs.size()));
        }
        LinkedHashMap<VncVal, VncVal> fields = new LinkedHashMap<VncVal, VncVal>();
        for (int ii = 0; ii < typeArgs.size(); ++ii) {
            VncCustomTypeFieldDef fieldDef = typeDef.getFieldDef(ii);
            VncVal arg = typeArgs.get(ii);
            DefTypeForm.validateTypeCompatibility(typeDef.getType(), fieldDef, arg);
            fields.put(fieldDef.getName(), arg);
        }
        VncOrderedMap data = new VncOrderedMap(fields, (VncVal)Constants.Nil);
        typeDef.validate(data);
        return new VncCustomType(typeDef, data, Constants.Nil);
    }

    public static VncVal createWrappedType(VncWrappingTypeDef typeDef, VncVal val, CustomTypeDefRegistry registry) {
        typeDef.validate(val);
        return val.wrap(typeDef, val.getMeta());
    }

    private static void validateTypeCompatibility(VncKeyword type, VncCustomTypeFieldDef fieldDef, VncVal arg) {
        VncKeyword argType = Types.getType(arg);
        if (!fieldDef.getType().equals(argType)) {
            throw new VncException(String.format("deftype: the type :%s requires arg %d of type :%s instead the passed :%s", type.getValue(), fieldDef.getIndex() + 1, fieldDef.getType().getValue(), argType.getValue()));
        }
    }
}

