/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncBoolean
extends VncVal {
    public static final VncBoolean True = new VncBoolean(true);
    public static final VncBoolean False = new VncBoolean(false);
    public static final VncKeyword TYPE = new VncKeyword(":core/boolean");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Boolean value;

    public VncBoolean(Boolean v) {
        this(v, null, Constants.Nil);
    }

    public VncBoolean(Boolean v, VncVal meta) {
        this(v, null, meta);
    }

    public VncBoolean(Boolean v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    public static VncBoolean of(boolean bool) {
        return bool ? True : False;
    }

    public static boolean isTrue(VncVal val) {
        return val instanceof VncBoolean && ((VncBoolean)val).getValue() == Boolean.TRUE;
    }

    public static boolean isFalse(VncVal val) {
        return val instanceof VncBoolean && ((VncBoolean)val).getValue() == Boolean.FALSE;
    }

    @Override
    public VncBoolean withMeta(VncVal meta) {
        return new VncBoolean(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncBoolean wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncBoolean(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : new VncKeyword(":core/val");
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.BOOLEAN;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncBoolean(o)) {
            return this.value.compareTo(((VncBoolean)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncBoolean other = (VncBoolean)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value.toString();
    }
}

