/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class VncByteBuffer
extends VncVal {
    public static final VncKeyword TYPE = new VncKeyword(":core/bytebuf");
    private static final long serialVersionUID = -1848883965231344442L;
    private final ByteBuffer value;

    public VncByteBuffer(byte[] v) {
        this(ByteBuffer.wrap(v), null, Constants.Nil);
    }

    public VncByteBuffer(ByteBuffer v) {
        this(v, null, Constants.Nil);
    }

    public VncByteBuffer(ByteBuffer v, VncVal meta) {
        this(v, null, meta);
    }

    public VncByteBuffer(ByteBuffer v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    @Override
    public VncByteBuffer withMeta(VncVal meta) {
        return new VncByteBuffer(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncByteBuffer wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncByteBuffer(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : new VncKeyword(":core/val");
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public byte[] getBytes() {
        return this.value.array();
    }

    public int size() {
        return this.value.capacity();
    }

    public VncList toVncList() {
        ArrayList<VncLong> list = new ArrayList<VncLong>();
        byte[] buf = this.value.array();
        for (int ii = 0; ii < buf.length; ++ii) {
            list.add(new VncLong(buf[ii] & 0xFF));
        }
        return new VncList(list);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.BYTEBUFFER;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncByteBuffer(o)) {
            return this.getValue().compareTo(((VncByteBuffer)o).getValue());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncByteBuffer other = (VncByteBuffer)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        byte[] arr = this.value.array();
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int ii = 0; ii < 100 && ii < arr.length; ++ii) {
            if (ii > 0) {
                sb.append(" ");
            }
            sb.append((long)arr[ii] & 0xFFL);
        }
        if (arr.length > 100) {
            sb.append(" ...");
        }
        sb.append("]");
        return sb.toString();
    }
}

