/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.IVncFunction;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.concurrent.ConcurrentHashMap;

public class VncMultiFunction
extends VncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private static final VncKeyword DEFAULT_METHOD = new VncKeyword(":default");
    private static final VncVector keywordDiscriminatorFnParams = VncVector.of(new VncSymbol("x"));
    private final IVncFunction discriminatorFn;
    private final ConcurrentHashMap<VncVal, VncFunction> functions = new ConcurrentHashMap();

    public VncMultiFunction(String name, IVncFunction discriminatorFn) {
        super(name);
        if (discriminatorFn == null) {
            throw new VncException("A discriminator function must not be null");
        }
        this.discriminatorFn = discriminatorFn;
    }

    @Override
    public VncMultiFunction withMeta(VncVal meta) {
        super.withMeta(meta);
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(":core/multi-function");
    }

    @Override
    public VncKeyword getSupertype() {
        return new VncKeyword(":core/function");
    }

    public VncMultiFunction addFn(VncVal dispatchVal, VncFunction fn) {
        if (dispatchVal == null) {
            throw new VncException("A dispatch value must not be null");
        }
        if (fn == null) {
            throw new VncException("A multifunction method must not be null");
        }
        this.functions.put(dispatchVal, fn);
        return this;
    }

    public VncMultiFunction removeFn(VncVal dispatchVal) {
        if (dispatchVal == null) {
            throw new VncException("A dispatch value must not be null");
        }
        this.functions.remove(dispatchVal);
        return this;
    }

    @Override
    public VncVector getParams() {
        return this.discriminatorFn instanceof VncFunction ? ((VncFunction)this.discriminatorFn).getParams() : keywordDiscriminatorFnParams;
    }

    @Override
    public VncVal apply(VncList params) {
        VncVal dispatchVal = this.discriminatorFn.apply(params);
        return this.findMethod(dispatchVal).apply(params);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MULTI_FUNCTION;
    }

    @Override
    public String toString() {
        return "multi-fn " + this.getQualifiedName();
    }

    private VncFunction findMethod(VncVal dispatchVal) {
        VncFunction fn = this.functions.get(dispatchVal);
        if (fn != null) {
            return fn;
        }
        VncFunction defaultFn = this.functions.get(DEFAULT_METHOD);
        if (defaultFn != null) {
            return defaultFn;
        }
        throw new VncException(String.format("No matching '%s' multifunction method defined for dispatch value %s", this.getQualifiedName(), Printer.pr_str(dispatchVal, true)));
    }
}

