/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.util.Types;

public class VncSymbol
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;
    private final String value;

    public VncSymbol(VncString v) {
        this(v.getValue(), (VncVal)Constants.Nil);
    }

    public VncSymbol(VncString v, VncVal meta) {
        this(v.getValue(), meta);
    }

    public VncSymbol(String v) {
        this(v, (VncVal)Constants.Nil);
    }

    public VncSymbol(String v, VncVal meta) {
        super(meta);
        this.value = v;
    }

    @Override
    public VncSymbol withMeta(VncVal meta) {
        return new VncSymbol(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(":core/symbol");
    }

    @Override
    public VncKeyword getSupertype() {
        return new VncKeyword(":core/val");
    }

    public String getName() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.SYMBOL;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncSymbol(o)) {
            return this.getName().compareTo(((VncSymbol)o).getName());
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncSymbol other = (VncSymbol)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.value;
    }
}

