/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import java.util.Map;

public class VncThreadLocal
extends VncVal {
    private static final long serialVersionUID = -1848883965231344442L;

    public VncThreadLocal() {
        super(Constants.Nil);
    }

    public VncThreadLocal(Map<VncVal, VncVal> val) {
        super(Constants.Nil);
        val.entrySet().forEach(e -> this.set(Coerce.toVncKeyword((VncVal)e.getKey()), (VncVal)e.getValue()));
    }

    public VncThreadLocal(VncList lst) {
        super(Constants.Nil);
        this.assoc(lst);
    }

    @Override
    public VncThreadLocal withMeta(VncVal meta) {
        return this;
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(":core/thread-local");
    }

    @Override
    public VncKeyword getSupertype() {
        return new VncKeyword(":core/val");
    }

    public VncVal get(VncKeyword key) {
        return ThreadLocalMap.get(key);
    }

    public VncVal get(VncKeyword key, VncVal defaultValue) {
        return ThreadLocalMap.get(key, defaultValue);
    }

    public VncVal get(String key) {
        return this.get(new VncKeyword(key));
    }

    public VncVal get(String key, VncVal defaultValue) {
        return this.get(new VncKeyword(key), defaultValue);
    }

    public void set(VncKeyword key, VncVal val) {
        ThreadLocalMap.set(key, val);
    }

    public void remove(VncKeyword key) {
        ThreadLocalMap.remove(key);
    }

    public VncVal containsKey(VncKeyword key) {
        return VncBoolean.of(key != null && ThreadLocalMap.containsKey(key));
    }

    public VncThreadLocal assoc(VncVal ... kvs) {
        for (int ii = 0; ii < kvs.length; ii += 2) {
            this.set(Coerce.toVncKeyword(kvs[ii]), kvs[ii + 1]);
        }
        return this;
    }

    public VncThreadLocal assoc(VncList lst) {
        for (int i = 0; i < lst.getList().size(); i += 2) {
            this.set(Coerce.toVncKeyword(lst.nth(i)), lst.nth(i + 1));
        }
        return this;
    }

    public VncThreadLocal dissoc(VncList lst) {
        for (int i = 0; i < lst.getList().size(); ++i) {
            this.remove(Coerce.toVncKeyword(lst.nth(i)));
        }
        return this;
    }

    public VncThreadLocal dissoc(VncKeyword ... ks) {
        for (int ii = 0; ii < ks.length; ++ii) {
            this.remove(ks[ii]);
        }
        return this;
    }

    public VncThreadLocal clear() {
        ThreadLocalMap.clearValues();
        return this;
    }

    public static VncMap toMap() {
        return new VncHashMap(ThreadLocalMap.getValues());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.THREADLOCAL;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return "ThreadLocal";
    }
}

