/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;

public class VncVolatile
extends VncVal
implements IDeref {
    private static final long serialVersionUID = -1848883965231344442L;
    private volatile VncVal state = Constants.Nil;

    public VncVolatile(VncVal value, VncVal meta) {
        super(meta);
        this.state = value;
    }

    @Override
    public VncVolatile withMeta(VncVal meta) {
        return new VncVolatile(this.state, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(":core/volatile");
    }

    @Override
    public VncKeyword getSupertype() {
        return new VncKeyword(":core/val");
    }

    public VncVal reset(VncVal newVal) {
        this.state = newVal;
        return newVal;
    }

    @Override
    public VncVal deref() {
        return this.state;
    }

    public VncVal swap(VncFunction fn, VncList args) {
        VncList new_args = VncList.of(this.state).addAllAtEnd(args);
        this.state = fn.apply(new_args);
        return this.state;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.VOLATILE;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return "(volatile " + Printer.pr_str(this.state, true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(volatile " + Printer.pr_str(this.state, print_readably) + ")";
    }
}

