/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.custom;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeFieldDef;
import java.util.List;

public class VncCustomTypeDef {
    private final VncKeyword type;
    private final List<VncCustomTypeFieldDef> fieldDefs;
    private final VncFunction validationFn;

    public VncCustomTypeDef(VncKeyword type, List<VncCustomTypeFieldDef> fieldDefs, VncFunction validationFn) {
        this.type = type;
        this.fieldDefs = fieldDefs;
        this.validationFn = validationFn;
    }

    public VncKeyword getType() {
        return this.type;
    }

    public VncCustomTypeFieldDef getFieldDef(int index) {
        if (index >= 0 && index < this.fieldDefs.size()) {
            return this.fieldDefs.get(index);
        }
        throw new VncException(String.format("deftype: field def index %d out of bounds.", index));
    }

    public List<VncCustomTypeFieldDef> getFieldDefs() {
        return this.fieldDefs;
    }

    public VncFunction getValidationFn() {
        return this.validationFn;
    }

    public int count() {
        return this.fieldDefs.size();
    }

    public void validate(VncMap data) {
        if (this.validationFn != null) {
            this.validationFn.apply(VncList.of(data));
        }
    }
}

