/*
 * Decompiled with CFR 0.152.
 */
package org.repackage.org.jline.builtins;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.repackage.org.jline.builtins.CommandRegistry;
import org.repackage.org.jline.builtins.Widgets;
import org.repackage.org.jline.reader.Completer;
import org.repackage.org.jline.terminal.Terminal;

public interface SystemRegistry
extends CommandRegistry {
    public void setCommandRegistries(CommandRegistry ... var1);

    public void register(String var1, CommandRegistry var2);

    public void initialize(File var1);

    public Collection<String> getPipeNames();

    public Completer completer();

    public Widgets.CmdDesc commandDescription(Widgets.CmdLine var1);

    public Object execute(String var1) throws Exception;

    public void cleanUp();

    public void trace(Exception var1);

    public void trace(boolean var1, Exception var2);

    public Terminal terminal();

    public Object execute(String var1, String[] var2) throws Exception;

    public Object invoke(String var1, Object ... var2) throws Exception;

    public void close();

    public static SystemRegistry get() {
        return Registeries.getInstance().getSystemRegistry();
    }

    public static void add(SystemRegistry systemRegistry) {
        Registeries.getInstance().addRegistry(systemRegistry);
    }

    public static void remove() {
        Registeries.getInstance().removeRegistry();
    }

    public static class Registeries {
        private static Registeries instance = new Registeries();
        private Map<Long, SystemRegistry> systemRegisteries = new HashMap<Long, SystemRegistry>();

        private Registeries() {
        }

        public static Registeries getInstance() {
            return instance;
        }

        public void addRegistry(SystemRegistry systemRegistry) {
            this.systemRegisteries.put(Thread.currentThread().getId(), systemRegistry);
        }

        public SystemRegistry getSystemRegistry() {
            return this.systemRegisteries.getOrDefault(Thread.currentThread().getId(), null);
        }

        public void removeRegistry() {
            this.systemRegisteries.remove(Thread.currentThread().getId());
        }
    }
}

