/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class VncMultiArityFunction
extends VncFunction {
    private static final long serialVersionUID = -1848883965231344442L;
    private final List<VncFunction> variadicArgFunctions = new ArrayList<VncFunction>();
    private final VncFunction[] fixedArgFunctions;

    public VncMultiArityFunction(String name, List<VncFunction> functions) {
        super(name);
        if (functions == null || functions.isEmpty()) {
            throw new VncException("A multi-arity function must have at least one function");
        }
        int maxFixedArgs = -1;
        for (VncFunction fn : functions) {
            if (fn.hasVariadicArgs()) continue;
            maxFixedArgs = Math.max(maxFixedArgs, fn.getFixedArgsCount());
        }
        this.fixedArgFunctions = new VncFunction[maxFixedArgs + 1];
        for (VncFunction fn : functions) {
            if (fn.hasVariadicArgs()) {
                this.variadicArgFunctions.add(fn);
                continue;
            }
            this.fixedArgFunctions[fn.getFixedArgsCount()] = fn;
        }
    }

    @Override
    public VncMultiArityFunction withMeta(VncVal meta) {
        super.withMeta(meta);
        return this;
    }

    @Override
    public VncKeyword getType() {
        return this.isMacro() ? VncFunction.TYPE_MACRO : VncFunction.TYPE_FUNCTION;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncVal.TYPE);
    }

    @Override
    public VncVal apply(VncList params) {
        VncFunction fn = this.findFunction(params.size());
        if (fn == null) {
            throw new VncException("No matching multi-arity function");
        }
        return fn.apply(params);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MULTI_ARITY_FUNCTION;
    }

    public VncList getFunctions() {
        ArrayList<VncFunction> list = new ArrayList<VncFunction>();
        for (VncFunction f : this.fixedArgFunctions) {
            list.add(f);
        }
        list.addAll(this.variadicArgFunctions);
        return new VncList(list);
    }

    private VncFunction findFunction(int arity) {
        VncFunction fn = null;
        if (arity < this.fixedArgFunctions.length) {
            fn = this.fixedArgFunctions[arity];
        }
        if (fn == null) {
            int fixedArgs = -1;
            for (VncFunction candidateFn : this.variadicArgFunctions) {
                int candidateFnFixedArgs = candidateFn.getFixedArgsCount();
                if (arity < candidateFnFixedArgs || candidateFnFixedArgs <= fixedArgs) continue;
                fixedArgs = candidateFnFixedArgs;
                fn = candidateFn;
            }
        }
        return fn;
    }
}

