/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class VncMapEntry
extends VncVal {
    public static final VncKeyword TYPE = new VncKeyword(":core/map-entry");
    private static final long serialVersionUID = 7943559441888855596L;
    private final VncVal key;
    private final VncVal val;

    public VncMapEntry(VncVal key, VncVal val) {
        super(Constants.Nil);
        this.key = key;
        this.val = val;
    }

    public VncMapEntry(Map.Entry<VncVal, VncVal> entry) {
        super(Constants.Nil);
        this.key = entry.getKey();
        this.val = entry.getValue();
    }

    public VncVal getKey() {
        return this.key;
    }

    public VncVal getValue() {
        return this.val;
    }

    public VncVector toVector() {
        return VncVector.of(this.key, this.val);
    }

    @Override
    public VncMapEntry withMeta(VncVal meta) {
        return this;
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncVal.TYPE);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.MAPENTRY;
    }

    @Override
    public Object convertToJavaObject() {
        return Arrays.asList(this.key.convertToJavaObject(), this.val.convertToJavaObject());
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        return String.format("[%s %s]", this.key.toString(print_readably), this.val.toString(print_readably));
    }
}

