/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.DynamicInvocationHandler;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncThreadLocal;
import com.github.jlangch.venice.impl.types.VncTunnelAsJavaObject;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.VncVolatile;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.concurrent.Agent;
import com.github.jlangch.venice.impl.types.concurrent.Delay;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ThreadPoolUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class ConcurrencyFunctions {
    public static VncFunction deref = new VncFunction("deref", (VncVal)VncFunction.meta().arglists("(deref x)", "(deref x timeout-ms timeout-val)").doc("Dereferences an atom, a future or a promise object. When applied to an atom, returns its current state. When applied to a future, will block if computation not complete. The variant taking a timeout can be used for futures and will return timeout-val if the timeout (in milliseconds) is reached before a value is available. If a future is deref'd and the waiting thread is interrupted the futures are cancelled.").examples("(do                             \n   (def counter (atom 10))      \n   (deref counter))               ", "(do                             \n   (def counter (atom 10))      \n   @counter)                      ", "(do                             \n   (defn task [] 100)           \n   (let [f (future task)]       \n      (deref f)))                 ", "(do                             \n   (defn task [] 100)           \n   (let [f (future task)]       \n      @f))                        ", "(do                             \n   (defn task [] 100)           \n   (let [f (future task)]       \n      (deref f 300 :timeout)))    ", "(do                                              \n   (def x (delay (println \"working...\") 100))  \n   @x)                                             ", "(do                             \n   (def p (promise))            \n   (deliver p 10)               \n   @p)                            ", "(do                             \n   (def x (agent 100))          \n   @x)                            ", "(do                             \n   (def counter (volatile 10))  \n   @counter)                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("deref", args, 1, 3);
            VncVal first = args.first();
            if (Types.isIDeref(first)) {
                IDeref d = Coerce.toIDeref(args.first());
                return d.deref();
            }
            if (Types.isVncJavaObject(first)) {
                Object delegate = ((VncJavaObject)first).getDelegate();
                if (delegate instanceof Future) {
                    Future future = (Future)delegate;
                    try {
                        if (args.size() == 1) {
                            return (VncVal)future.get();
                        }
                        long timeout = Coerce.toVncLong(args.second()).getValue();
                        return (VncVal)future.get(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ex) {
                        return args.size() == 3 ? args.third() : Constants.Nil;
                    }
                    catch (ExecutionException ex) {
                        if (ex.getCause() != null) {
                            if (ex.getCause() instanceof SecurityException) {
                                throw (SecurityException)ex.getCause();
                            }
                            if (ex.getCause() instanceof VncException) {
                                throw (VncException)ex.getCause();
                            }
                        }
                        throw new VncException("Failed to deref future", ex);
                    }
                    catch (CancellationException ex) {
                        throw new VncException("Failed to deref future. Future has been cancelled", ex);
                    }
                    catch (java.lang.InterruptedException ex) {
                        ConcurrencyFunctions.safelyCancelFuture(future);
                        throw new InterruptedException("Interrupted while waiting for future to return result (deref future).");
                    }
                    catch (Exception ex) {
                        throw new VncException("Failed to deref future", ex);
                    }
                }
                if (Types.isIDeref(delegate)) {
                    return ((IDeref)delegate).deref();
                }
            }
            throw new VncException(String.format("Function 'deref' does not allow type %s as parameter.", Types.getType(first)));
        }
    };
    public static VncFunction deref_Q = new VncFunction("deref?", (VncVal)VncFunction.meta().arglists("(deref? x)").doc("Returns true if x is dereferencable.").examples("(deref? (atom 10))", "(deref? (delay 100))", "(deref? (promise))", "(deref? (future (fn [] 10)))", "(deref? (volatile 100))", "(deref? (agent 100))", "(deref? (just 100))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            Object delegate;
            FunctionsUtil.assertArity("deref?", args, 1);
            VncVal first = args.first();
            if (Types.isIDeref(first)) {
                return VncBoolean.True;
            }
            if (Types.isVncJavaObject(first) && ((delegate = ((VncJavaObject)first).getDelegate()) instanceof Future || Types.isIDeref(delegate))) {
                return VncBoolean.True;
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction realized_Q = new VncFunction("realized?", (VncVal)VncFunction.meta().arglists("(realized? x)").doc("Returns true if a value has been produced for a promise, delay, or future.").examples("(do                                \n   (def task (fn [] 100))          \n   (let [f (future task)]          \n        (println (realized? f))    \n        (println @f)               \n        (println (realized? f))))    ", "(do                                \n   (def p (promise))               \n   (println (realized? p))         \n   (deliver p 123)                 \n   (println @p)                    \n   (println (realized? p)))          ", "(do                                \n   (def x (delay 100))             \n   (println (realized? x))         \n   (println @x)                    \n   (println (realized? x)))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("realized?", args, 1);
            if (Types.isVncJavaObject(args.first())) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Future) {
                    return VncBoolean.of(((Future)delegate).isDone());
                }
                if (delegate instanceof CompletableFuture) {
                    return VncBoolean.of(((CompletableFuture)delegate).isDone());
                }
                if (delegate instanceof Delay) {
                    return VncBoolean.of(((Delay)delegate).isRealized());
                }
            }
            return VncBoolean.True;
        }
    };
    public static VncFunction add_watch = new VncFunction("add-watch", (VncVal)VncFunction.meta().arglists("(add-watch ref key fn)").doc("Adds a watch function to an agent/atom reference. The watch fn must be a fn of 4 args: a key, the reference, its old-state, its new-state.").examples("(do                                      \n   (def x (agent 10))                    \n   (defn watcher [key ref old new]       \n         (println \"watcher: \" key))    \n   (add-watch x :test watcher))            ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("add-watch", args, 3);
            VncVal ref = args.first();
            VncKeyword key = Coerce.toVncKeyword(args.second());
            VncFunction fn = Coerce.toVncFunction(args.nth(2));
            if (Types.isVncJavaObject(ref)) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Agent) {
                    ((Agent)delegate).addWatch(key, fn);
                    return Constants.Nil;
                }
            } else if (Types.isVncAtom(ref)) {
                ((VncAtom)ref).addWatch(key, fn);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'add-watch' does not allow type %s as ref.", Types.getType(ref)));
        }
    };
    public static VncFunction remove_watch = new VncFunction("remove-watch", (VncVal)VncFunction.meta().arglists("(remove-watch ref key)").doc("Removes a watch function from an agent/atom reference.").examples("(do                                      \n   (def x (agent 10))                    \n   (defn watcher [key ref old new]       \n         (println \"watcher: \" key))    \n   (add-watch x :test watcher)           \n   (remove-watch x :test))                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("remove-watch", args, 2);
            VncVal ref = args.first();
            VncKeyword key = Coerce.toVncKeyword(args.second());
            if (Types.isVncJavaObject(ref)) {
                Object delegate = ((VncJavaObject)args.first()).getDelegate();
                if (delegate instanceof Agent) {
                    ((Agent)delegate).removeWatch(key);
                    return Constants.Nil;
                }
            } else if (Types.isVncAtom(ref)) {
                ((VncAtom)ref).removeWatch(key);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'remove-watch' does not allow type %s as ref.", Types.getType(ref)));
        }
    };
    public static VncFunction new_atom = new VncFunction("atom", (VncVal)VncFunction.meta().arglists("(atom x)").doc("Creates an atom with the initial value x").examples("(do                       \n  (def counter (atom 0))  \n  (swap! counter inc)     \n  (deref counter))          ", "(do                       \n  (def counter (atom 0))  \n  (reset! counter 9)      \n  @counter)                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom", args, 1);
            return new VncAtom(args.first(), args.getMeta());
        }
    };
    public static VncFunction atom_Q = new VncFunction("atom?", (VncVal)VncFunction.meta().arglists("(atom? x)").doc("Returns true if x is an atom, otherwise false").examples("(do                        \n   (def counter (atom 0))  \n   (atom? counter))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("atom?", args, 1);
            return VncBoolean.of(Types.isVncAtom(args.first()));
        }
    };
    public static VncFunction reset_BANG = new VncFunction("reset!", (VncVal)VncFunction.meta().arglists("(reset! box newval)").doc("Sets the value of an atom or a volatile to newval without regard for the current value. Returns newval.").examples("(do                           \n  (def counter (atom 0))      \n  (reset! counter 99)         \n  @counter)                     ", "(do                           \n  (def counter (atom 0))      \n  (reset! counter 99))          ", "(do                           \n  (def counter (volatile 0))  \n  (reset! counter 99)         \n  @counter)                     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("reset!", args, 2);
            VncVal val = args.first();
            if (Types.isVncAtom(val)) {
                return ((VncAtom)val).reset(args.second());
            }
            if (Types.isVncVolatile(val)) {
                return ((VncVolatile)val).reset(args.second());
            }
            throw new VncException(String.format("Function 'reset!' does not allow type %s as argument.", Types.getType(val)));
        }
    };
    public static VncFunction swap_BANG = new VncFunction("swap!", (VncVal)VncFunction.meta().arglists("(swap! box f & args)").doc("Atomically swaps the value of an atom or a volatile to be: (apply f current-value-of-boxargs). Note that f may be called multiple times, and thus should be free of side effects.  Returns the value that was swapped in.").examples("(do                           \n   (def counter (atom 0))     \n   (swap! counter inc)        \n   @counter)                    ", "(do                           \n   (def counter (atom 0))     \n   (swap! counter inc))         ", "(do                               \n   (def counter (volatile 0))     \n   (swap! counter (partial + 6))  \n   @counter)                        ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("swap!", args, 2);
            VncVal val = args.first();
            if (Types.isVncAtom(val)) {
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList swapArgs = args.slice(2);
                return ((VncAtom)val).swap(fn, swapArgs);
            }
            if (Types.isVncVolatile(val)) {
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList swapArgs = args.slice(2);
                return ((VncVolatile)val).swap(fn, swapArgs);
            }
            throw new VncException(String.format("Function 'sawp!' does not allow type %s as argument.", Types.getType(val)));
        }
    };
    public static VncFunction compare_and_set_BANG = new VncFunction("compare-and-set!", (VncVal)VncFunction.meta().arglists("(compare-and-set! atom oldval newval)").doc("Atomically sets the value of atom to newval if and only if the current value of the atom is identical to oldval. Returns true if set happened, else false").examples("(do                               \n   (def counter (atom 2))         \n   (compare-and-set! counter 2 4) \n   (deref counter))                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("compare-and-set!", args, 3);
            VncAtom atm = Coerce.toVncAtom(args.first());
            return atm.compare_and_set(args.second(), args.nth(2));
        }
    };
    public static VncFunction new_volatile = new VncFunction("volatile", (VncVal)VncFunction.meta().arglists("(volatile x)").doc("Creates a volatile with the initial value x").examples("(do                           \n  (def counter (volatile 0))  \n  (swap! counter inc)         \n  (deref counter))              ", "(do                           \n  (def counter (volatile 0))  \n  (reset! counter 9)          \n  @counter)                     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("volatile", args, 1);
            return new VncVolatile(args.first(), args.getMeta());
        }
    };
    public static VncFunction volatile_Q = new VncFunction("volatile?", (VncVal)VncFunction.meta().arglists("(volatile? x)").doc("Returns true if x is a volatile, otherwise false").examples("(do                            \n   (def counter (volatile 0))  \n   (volatile? counter))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("volatile?", args, 1);
            return VncBoolean.of(Types.isVncVolatile(args.first()));
        }
    };
    public static VncFunction agent = new VncFunction("agent", (VncVal)VncFunction.meta().arglists("(agent state & options)").doc("Creates and returns an agent with an initial value of state and zero or more options. \n\nOptions: \n  :error-handler handler-fn \n  :error-mode mode-keyword \nThe handler-fn is called if an action throws an exception. It's afunction taking two args the agent and the exception. The mode-keyword may be either :continue (the default) or :fail").examples("(do                         \n   (def x (agent 100))      \n   (send x + 5)             \n   (sleep 100)              \n   (deref x))                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("agent", args, 1);
            return new VncJavaObject(new Agent(args.first(), args.rest()));
        }
    };
    public static VncFunction send = new VncFunction("send", (VncVal)VncFunction.meta().arglists("(send agent action-fn args)").doc("Dispatch an action to an agent. Returns the agent immediately.The state of the agent will be set to the value of:\n (apply action-fn state-of-agent args)").examples("(do                           \n   (def x (agent 100))        \n   (send x + 5)               \n   (send x (partial + 7))     \n   (sleep 100)                \n   (deref x))                   ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("send", args, 2);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList fnArgs = args.slice(2);
                agent.send(fn, fnArgs);
                return args.first();
            }
            throw new VncException(String.format("Function 'send' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction send_off = new VncFunction("send-off", (VncVal)VncFunction.meta().arglists("(send-off agent fn args)").doc("Dispatch a potentially blocking action to an agent. Returns the agent immediately. The state of the agent will be set to the value of:\n (apply action-fn state-of-agent args)").examples("(do                           \n   (def x (agent 100))        \n   (send-off x + 5)           \n   (send-off x (partial + 7)) \n   (sleep 100)                \n   (deref x))                   ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("send-off", args, 2);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncFunction fn = Coerce.toVncFunction(args.second());
                VncList fnArgs = args.slice(2);
                agent.send_off(fn, fnArgs);
                return args.first();
            }
            throw new VncException(String.format("Function 'send-off' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction restart_agent = new VncFunction("restart-agent", (VncVal)VncFunction.meta().arglists("(restart-agent agent state)").doc("When an agent is failed, changes the agent state to new-state and then un-fails the agent so that sends are allowed again.").examples("(do                          \n   (def x (agent 100))       \n   (restart-agent x 200)     \n   (deref x))                  ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("restart-agent", args, 2);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                VncVal state = args.second();
                agent.restart(state);
                return args.first();
            }
            throw new VncException(String.format("Function 'restart-agent' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction set_error_handler = new VncFunction("set-error-handler!", (VncVal)VncFunction.meta().arglists("(set-error-handler! agent handler-fn)").doc("Sets the error-handler of an agent to handler-fn. If an action being run by the agent throws an exception handler-fn will be called with two arguments: the agent and the exception.").examples("(do                                          \n   (def x (agent 100))                       \n   (defn err-handler-fn [ag ex]              \n      (println \"error occured: \"           \n               (:message ex)                 \n               \" and we still have value\"  \n               @ag))                         \n   (set-error-handler! x err-handler-fn)     \n   (send x (fn [n] (/ n 0))))                  ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("set-error-handler!", args, 2);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                agent.setErrorHandler(Coerce.toVncFunction(args.second()));
                return args.first();
            }
            throw new VncException(String.format("Function 'set-error-handler!' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction agent_error = new VncFunction("agent-error", (VncVal)VncFunction.meta().arglists("(agent-error agent)").doc("Returns the exception thrown during an asynchronous action of the agent if the agent is failed. Returns nil if the agent is not failed.").examples("(do                                              \n   (def x (agent 100 :error-mode :fail))         \n   (send x (fn [n] (/ n 0)))                     \n   (sleep 500)                                   \n   (agent-error x))                                ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("agent-error", args, 1);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                RuntimeException ex = agent.getError();
                return ex == null ? Constants.Nil : new VncJavaObject(ex);
            }
            throw new VncException(String.format("Function 'agent-error' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction agent_error_mode = new VncFunction("agent-error-mode", (VncVal)VncFunction.meta().arglists("(agent-error-mode agent)").doc("Returns the agent's error mode").examples("(do                                              \n   (def x (agent 100 :error-mode :fail))         \n   (agent-mode x))                                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("agent-error-mode", args, 1);
            if (Types.isVncJavaObject(args.first(), Agent.class)) {
                Agent agent = (Agent)Coerce.toVncJavaObject(args.first()).getDelegate();
                return agent.getErrorMode();
            }
            throw new VncException(String.format("Function 'agent-error-mode' does not allow type %s as agent parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction await = new VncFunction("await", (VncVal)VncFunction.meta().arglists("(await agents)").doc("Blocks the current thread (indefinitely) until all actions dispatched thus far (from this thread or agent) to the agents have occurred. ").examples("(do                                              \n   (def x1 (agent 100))                          \n   (def x2 (agent {}))                           \n   (send-off x1 + 5)                             \n   (send-off x2 (fn [state]                      \n                  (sleep 100)                    \n                  (assoc state :done true)))     \n   ;; blocks till the agent actions are finished \n   (await x1 x2))                                 ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("await", args, 1);
            List<Agent> agents = args.getList().stream().map(a -> (Agent)Coerce.toVncJavaObject(a).getDelegate()).collect(Collectors.toList());
            return agents.isEmpty() ? VncBoolean.True : VncBoolean.of(Agent.await(agents, -1L));
        }
    };
    public static VncFunction await_for = new VncFunction("await-for", (VncVal)VncFunction.meta().arglists("(await-for timeout-ms agents)").doc("Blocks the current thread until all actions dispatched thus far (from this thread or agent) to the agents have occurred, or the timeout (in milliseconds) has elapsed. Returns logical false if returning due to timeout, logical true otherwise.").examples("(do                                              \n   (def x1 (agent 100))                          \n   (def x2 (agent {}))                           \n   (send-off x1 + 5)                             \n   (send-off x2 (fn [state]                      \n                  (sleep 100)                    \n                  (assoc state :done true)))     \n   ;; blocks till the agent actions are finished \n   (await-for 500 x1 x2))                          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("await-for", args, 2);
            long timeoutMillis = Coerce.toVncLong(args.first()).getValue();
            List<Agent> agents = args.rest().getList().stream().map(a -> (Agent)Coerce.toVncJavaObject(a).getDelegate()).collect(Collectors.toList());
            return agents.isEmpty() ? VncBoolean.True : VncBoolean.of(Agent.await(agents, timeoutMillis));
        }
    };
    public static VncFunction shutdown_agents = new VncFunction("shutdown-agents", (VncVal)VncFunction.meta().arglists("(shutdown-agents )").doc("Initiates a shutdown of the thread pools that back the agent system. Running actions will complete, but no new actions will been accepted").examples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (shutdown-agents ))          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("shutdown-agents", args, 0);
            Agent.shutdown();
            return Constants.Nil;
        }
    };
    public static VncFunction shutdown_agents_Q = new VncFunction("shutdown-agents?", (VncVal)VncFunction.meta().arglists("(shutdown-agents?)").doc("Returns true if the thread-pool that backs the agents is shut down").examples("(do                           \n   (def x1 (agent 100))       \n   (def x2 (agent 100))       \n   (shutdown-agents )         \n   (sleep 300)                \n   (shutdown-agents? ))         ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("shutdown-agents?", args, 0);
            return VncBoolean.of(Agent.isShutdown());
        }
    };
    public static VncFunction await_termination_agents = new VncFunction("await-termination-agents", (VncVal)VncFunction.meta().arglists("(shutdown-agents )").doc("Blocks until all actions have completed execution after a shutdown request, or the timeout occurs, or the current thread is interrupted, whichever happens first.").examples("(do                                   \n   (def x1 (agent 100))               \n   (def x2 (agent 100))               \n   (shutdown-agents )                 \n   (await-termination-agents 1000))     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("await-termination-agents", args, 1);
            long timeoutMillis = Coerce.toVncLong(args.first()).getValue();
            Agent.awaitTermination(timeoutMillis);
            return Constants.Nil;
        }
    };
    public static VncFunction await_termination_agents_Q = new VncFunction("await-termination-agents?", (VncVal)VncFunction.meta().arglists("(await-termination-agents?)").doc("Returns true if all tasks have been completed following agent shut down").examples("(do                                  \n   (def x1 (agent 100))              \n   (def x2 (agent 100))              \n   (shutdown-agents )                \n   (await-termination-agents 1000))  \n   (sleep 300)                       \n   (await-termination-agents? ))      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("await-termination-agents?", args, 0);
            return VncBoolean.of(Agent.isShutdown());
        }
    };
    public static VncFunction deliver = new VncFunction("deliver", (VncVal)VncFunction.meta().arglists("(deliver ref value)").doc("Delivers the supplied value to the promise, releasing any pending derefs. A subsequent call to deliver on a promise will have no effect.").examples("(do                   \n   (def p (promise))  \n   (deliver p 10)     \n   (deliver p 20)     \n   @p)                  ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("deliver", args, 2);
            Object promise = Coerce.toVncJavaObject(args.first()).getDelegate();
            VncVal value = args.second();
            if (promise instanceof CompletableFuture) {
                ((CompletableFuture)promise).complete(value);
                return Constants.Nil;
            }
            throw new VncException(String.format("Function 'deliver' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction promise = new VncFunction("promise", (VncVal)VncFunction.meta().arglists("(promise)").doc("Returns a promise object that can be read with deref, and set, once only, with deliver. Calls to deref prior to delivery will block, unless the variant of deref with timeout is used. All subsequent derefs will return the same delivered value without blocking.").examples("(do                   \n   (def p (promise))  \n   (deliver p 10)     \n   (deliver p 20)     \n   @p)                  ", "(do                                            \n   (def p (promise))                           \n   (defn task1 [] (sleep 500) (deliver p 10))  \n   (defn task2 [] (sleep 800) (deliver p 20))  \n   (future task1)                              \n   (future task2)                              \n   @p)                                           ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("promise", args, 0);
            return new VncJavaObject(new CompletableFuture());
        }
    };
    public static VncFunction promise_Q = new VncFunction("promise?", (VncVal)VncFunction.meta().arglists("(promise? p)").doc("Returns true if f is a Promise otherwise false").examples("(promise? (promise)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("promise?", args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), CompletableFuture.class));
        }
    };
    public static VncFunction future = new VncFunction("future", (VncVal)VncFunction.meta().arglists("(future fn)").doc("Takes a function and yields a future object that will invoke the function in another thread, and will cache the result and return it on all subsequent calls to deref. If the computation has not yet finished, calls to deref will block, unless the variant of deref with timeout is used. \nThread local vars will be inherited by the future child thread. Changes of the child's thread local vars will not be seen on the parent.").examples("(do                                          \n   (def wait (fn [] (do (sleep 500) 100)))   \n   (let [f (future wait)]                    \n        (deref f)))                            ", ";; demonstrates the use of thread locals with futures              \n(do                                                                \n   ;; parent thread locals                                         \n   (binding [a 10 b 20]                                            \n      ;; future with child thread locals                           \n      (let [f (future (fn [] (binding [b 90] {:a a :b b})))]       \n         {:child @f :parent {:a a :b b}})))                          ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("future", args, 1);
            final VncFunction fn = Coerce.toVncFunction(args.first());
            VncFunction wrapped = new VncFunction(fn.getQualifiedName(), fn.getMeta()){
                private static final long serialVersionUID = -1L;

                @Override
                public VncVal apply(VncList args) {
                    return new VncTunnelAsJavaObject(fn.apply(args));
                }
            };
            Callable task = (Callable)DynamicInvocationHandler.proxify(ThreadLocalMap.getCallStack().peek(), Callable.class, VncHashMap.of(new VncKeyword("call"), wrapped));
            IInterceptor parentInterceptor = JavaInterop.getInterceptor();
            AtomicReference<Map<VncKeyword, VncVal>> parentThreadLocals = new AtomicReference<Map<VncKeyword, VncVal>>(ThreadLocalMap.getValues());
            Callable<VncVal> taskWrapper = () -> {
                try {
                    ThreadLocalMap.setValues((Map)parentThreadLocals.get());
                    ThreadLocalMap.clearCallStack();
                    JavaInterop.register(parentInterceptor);
                    VncVal vncVal = (VncVal)task.call();
                    return vncVal;
                }
                finally {
                    JavaInterop.unregister();
                    ThreadLocalMap.remove();
                }
            };
            Future<VncVal> future = ConcurrencyFunctions.getExecutor().submit(taskWrapper);
            return new VncJavaObject(future);
        }
    };
    public static VncFunction future_Q = new VncFunction("future?", (VncVal)VncFunction.meta().arglists("(future? f)").doc("Returns true if f is a Future otherwise false").examples("(future? (future (fn [] 100)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("future?", args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), Future.class));
        }
    };
    public static VncFunction future_done_Q = new VncFunction("future-done?", (VncVal)VncFunction.meta().arglists("(future-done? f)").doc("Returns true if f is a Future is done otherwise false").examples("(do                                                            \n   (def wait (fn [] (do (sleep 200) 100)))                     \n   (let [f (future wait)]                                      \n      (sleep 50)                                               \n      (printf \"After 50ms: done=%b\\n\" (future-done? f))     \n      (sleep 300)                                              \n      (printf \"After 300ms: done=%b\\n\" (future-done? f))))    ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("future-done?", args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = Coerce.toVncJavaObject(args.first(), Future.class);
                    return VncBoolean.of(future.isDone());
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is done", ex);
                }
            }
            throw new VncException(String.format("Function 'future-done?' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction future_cancel = new VncFunction("future-cancel", (VncVal)VncFunction.meta().arglists("(future-cancel f)").doc("Cancels the future").examples("(do                                                                     \n   (def wait (fn [] (do (sleep 400) 100)))                              \n   (let [f (future wait)]                                               \n      (sleep 50)                                                        \n      (printf \"After 50ms: cancelled=%b\\n\" (future-cancelled? f))    \n      (future-cancel f)                                                 \n      (sleep 100)                                                       \n      (printf \"After 150ms: cancelled=%b\\n\" (future-cancelled? f))))   ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("future-cancel", args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = Coerce.toVncJavaObject(args.first(), Future.class);
                    future.cancel(true);
                    return args.first();
                }
                catch (Exception ex) {
                    throw new VncException("Failed to cancel future", ex);
                }
            }
            throw new VncException(String.format("Function 'future-cancel' does not allow type %s as parameter.", Types.getType(args.first())));
        }
    };
    public static VncFunction future_cancelled_Q = new VncFunction("future-cancelled?", (VncVal)VncFunction.meta().arglists("(future-cancelled? f)").doc("Returns true if f is a Future is cancelled otherwise false").examples("(future-cancelled? (future (fn [] 100)))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("future-cancelled?", args, 1);
            if (Types.isVncJavaObject(args.first(), Future.class)) {
                try {
                    Future future = Coerce.toVncJavaObject(args.first(), Future.class);
                    return VncBoolean.of(future.isCancelled());
                }
                catch (Exception ex) {
                    throw new VncException("Failed to check if future is cancelled", ex);
                }
            }
            throw new VncException(String.format("Function 'future-cancelled?' does not allow type %s as parameter", Types.getType(args.first())));
        }
    };
    public static VncFunction futures_fork = new VncFunction("futures-fork", (VncVal)VncFunction.meta().arglists("(futures-fork count worker-factory-fn)").doc("Creates a list of count futures. The worker factory is single argument function that gets the worker index (0..count-1) as argument and returns a worker function. Returns a list with the created futures.").examples("(do                                                \n  (def mutex 0)                                    \n  (defn log [& xs]                                 \n    (locking mutex (println (apply str xs))))      \n  (defn factory [n]                                \n    (fn [] (log \"Worker\" n)))                    \n  (apply futures-wait (futures-fork 3 factory)))     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("futures-fork", args, 2);
            VncLong count = Coerce.toVncLong(args.first());
            VncFunction workerFactoryFn = Coerce.toVncFunction(args.second());
            ArrayList<VncVal> futures = new ArrayList<VncVal>();
            int ii = 0;
            while ((long)ii < count.getValue()) {
                VncFunction worker = (VncFunction)workerFactoryFn.apply(VncList.of(new VncLong(ii)));
                futures.add(future.apply(VncList.of(worker)));
                ++ii;
            }
            return new VncList(futures);
        }
    };
    public static VncFunction futures_wait = new VncFunction("futures-wait", (VncVal)VncFunction.meta().arglists("(futures-wait & futures)").doc("Waits for all futures to get terminated. If the waiting thread is interrupted the futures are cancelled. ").examples("(do                                                \n  (def mutex 0)                                    \n  (defn log [& xs]                                 \n    (locking mutex (println (apply str xs))))      \n  (defn factory [n]                                \n    (fn [] (log \"Worker\" n)))                    \n  (apply futures-wait (futures-fork 3 factory)))     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("futures-wait", args, 0);
            for (VncVal v : args.getList()) {
                Future future = Coerce.toVncJavaObject(v, Future.class);
                try {
                    future.get();
                }
                catch (CancellationException | ExecutionException exception) {
                }
                catch (java.lang.InterruptedException ex) {
                    args.forEach(f -> ConcurrencyFunctions.safelyCancelFuture(Coerce.toVncJavaObject(f, Future.class)));
                    throw new InterruptedException("Interrupted while waiting for futures to terminate (futures-wait & futures).");
                }
                catch (Exception ex) {
                    throw new VncException("Failed to wait for future", ex);
                }
            }
            return Constants.Nil;
        }
    };
    public static VncFunction delay_Q = new VncFunction("delay?", (VncVal)VncFunction.meta().arglists("(delay? x)").doc("Returns true if x is a Delay created with delay").examples("(do                                              \n   (def x (delay (println \"working...\") 100))  \n   (delay? x))                                     ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("delay?", args, 1);
            return VncBoolean.of(Types.isVncJavaObject(args.first(), Delay.class));
        }
    };
    public static VncFunction force = new VncFunction("force", (VncVal)VncFunction.meta().arglists("(force x)").doc("If x is a Delay, returns its value, else returns x").examples("(do                                              \n   (def x (delay (println \"working...\") 100))  \n   (force x))                                      ").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("force", args, 1);
            if (Types.isVncJavaObject(args.first(), Delay.class)) {
                Delay delay = Coerce.toVncJavaObject(args.first(), Delay.class);
                return delay.deref();
            }
            return args.first();
        }
    };
    public static VncFunction new_thread_local = new VncFunction("thread-local", (VncVal)VncFunction.meta().arglists("(thread-local)").doc("Creates a new thread-local accessor").examples("(thread-local :a 1 :b 2)", "(thread-local { :a 1 :b 2 })", "(do \n   (thread-local-clear) \n   (assoc (thread-local) :a 1 :b 2) \n   (dissoc (thread-local) :a) \n   (get (thread-local) :b 100) \n)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.size() == 1 && Types.isVncMap(args.first())) {
                return new VncThreadLocal(((VncMap)args.first()).getMap());
            }
            return new VncThreadLocal(args);
        }
    };
    public static VncFunction thread_local_Q = new VncFunction("thread-local?", (VncVal)VncFunction.meta().arglists("(thread-local? x)").doc("Returns true if x is a thread-local, otherwise false").examples("(do\n   (def x (thread-local))\n   (thread-local? x))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local?", args, 1);
            return VncBoolean.of(Types.isVncThreadLocal(args.first()));
        }
    };
    public static VncFunction thread_local_clear = new VncFunction("thread-local-clear", (VncVal)VncFunction.meta().arglists("(thread-local-clear)").doc("Removes all thread local vars").examples("(thread-local-clear)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local-clear", args, 0);
            new VncThreadLocal().clear();
            return this;
        }
    };
    public static VncFunction thread_local_map = new VncFunction("thread-local-map", (VncVal)VncFunction.meta().arglists("(thread-local-map)").doc("Returns the thread local vars as a map").examples("(do (thread-local :a 1 :b 2) (thread-local-map))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-local-map", args, 0);
            return VncThreadLocal.toMap();
        }
    };
    public static VncFunction thread_id = new VncFunction("thread-id", (VncVal)VncFunction.meta().arglists("(thread-id)").doc("Returns the identifier of this Thread. The thread ID is a positive number generated when this thread was created. The thread ID  is unique and remains unchanged during its lifetime. When a thread is terminated, this thread ID may be reused.").examples("(thread-id)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-id", args, 0);
            return new VncLong(Thread.currentThread().getId());
        }
    };
    public static VncFunction thread_name = new VncFunction("thread-name", (VncVal)VncFunction.meta().arglists("(thread-name)").doc("Returns this thread's name.").examples("(thread-name)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-name", args, 0);
            return new VncString(Thread.currentThread().getName());
        }
    };
    public static VncFunction thread_interrupted_Q = new VncFunction("thread-interrupted?", (VncVal)VncFunction.meta().arglists("(thread-interrupted?)").doc("Tests whether this thread has been interrupted. The interrupted status of the thread is unaffected by this method. \nReturns true if the current thread has been interrupted else false.").examples("(thread-interrupted?)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-interrupted?", args, 0);
            return VncBoolean.of(Thread.currentThread().isInterrupted());
        }
    };
    public static VncFunction thread_interrupted = new VncFunction("thread-interrupted", (VncVal)VncFunction.meta().arglists("(thread-interrupted)").doc("Tests whether the current thread has been interrupted. The interrupted status of the thread is cleared by this method. In other words, if this method were to be called twice in succession, the second call would return false (unless the current thread were interrupted again, after the first call had cleared its interrupted status and before the second call had examined it).\nReturns true if the current thread has been interrupted else false.").examples("(thread-interrupted)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("thread-interrupted", args, 0);
            return VncBoolean.of(Thread.interrupted());
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(deref).add(deref_Q).add(realized_Q).add(add_watch).add(remove_watch).add(new_atom).add(atom_Q).add(reset_BANG).add(swap_BANG).add(compare_and_set_BANG).add(new_volatile).add(volatile_Q).add(agent).add(send).add(send_off).add(restart_agent).add(set_error_handler).add(agent_error).add(agent_error_mode).add(await).add(await_for).add(shutdown_agents).add(shutdown_agents_Q).add(await_termination_agents).add(await_termination_agents_Q).add(promise).add(promise_Q).add(deliver).add(future).add(future_Q).add(future_done_Q).add(future_cancel).add(future_cancelled_Q).add(futures_fork).add(futures_wait).add(delay_Q).add(force).add(thread_id).add(thread_name).add(thread_interrupted_Q).add(thread_interrupted).add(new_thread_local).add(thread_local_Q).add(thread_local_clear).add(thread_local_map).toMap();
    private static final AtomicLong futureThreadPoolCounter = new AtomicLong(0L);
    private static ExecutorService executor;
    private static int maximumThreadPoolSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        AtomicLong atomicLong = futureThreadPoolCounter;
        synchronized (atomicLong) {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaximumThreadPoolSize(int maximumPoolSize) {
        AtomicLong atomicLong = futureThreadPoolCounter;
        synchronized (atomicLong) {
            if (executor != null) {
                maximumThreadPoolSize = maximumPoolSize;
                ((ThreadPoolExecutor)executor).setMaximumPoolSize(maximumPoolSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownNow() {
        AtomicLong atomicLong = futureThreadPoolCounter;
        synchronized (atomicLong) {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getExecutor() {
        AtomicLong atomicLong = futureThreadPoolCounter;
        synchronized (atomicLong) {
            if (executor == null) {
                executor = ConcurrencyFunctions.createExecutor();
                ((ThreadPoolExecutor)executor).setMaximumPoolSize(maximumThreadPoolSize);
            }
            return executor;
        }
    }

    private static ExecutorService createExecutor() {
        return Executors.newCachedThreadPool(ThreadPoolUtil.createThreadFactory("venice-future-pool-%d", futureThreadPoolCounter, true));
    }

    private static void safelyCancelFuture(Future<?> future) {
        try {
            if (!future.isCancelled()) {
                future.cancel(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        maximumThreadPoolSize = 1000;
    }
}

