/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.ArityException;
import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.functions.MathOp;
import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;

public class MathFunctions {
    public static VncFunction add = new VncFunction("+", (VncVal)VncFunction.meta().arglists("(+)", "(+ x)", "(+ x y)", "(+ x y & more)").doc("Returns the sum of the numbers. (+) returns 0.").examples("(+)", "(+ 1)", "(+ 1 2)", "(+ 1 2 3 4)", "(+ 1I 2I)", "(+ 1 2.5)", "(+ 1 2.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    return new VncLong(0);
                }
                case 1: {
                    return MathFunctions.validateNumber("+", args.first());
                }
                case 2: {
                    return Numeric.calc(MathOp.ADD, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.ADD, val, v);
            }
            return val;
        }
    };
    public static VncFunction subtract = new VncFunction("-", (VncVal)VncFunction.meta().arglists("(- x)", "(- x y)", "(- x y & more)").doc("If one number is supplied, returns the negation, else subtracts the numbers from x and returns the result.").examples("(- 4)", "(- 8 3 -2 -1)", "(- 5I 2I)", "(- 8 2.5)", "(- 8 1.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    throw new ArityException(0, "-");
                }
                case 1: {
                    VncVal first = args.first();
                    if (Types.isVncLong(first)) {
                        return ((VncLong)first).negate();
                    }
                    if (Types.isVncInteger(first)) {
                        return ((VncInteger)first).negate();
                    }
                    if (Types.isVncDouble(first)) {
                        return ((VncDouble)first).negate();
                    }
                    if (Types.isVncBigDecimal(first)) {
                        return ((VncBigDecimal)first).negate();
                    }
                    return MathFunctions.validateNumber("-", first);
                }
                case 2: {
                    return Numeric.calc(MathOp.SUB, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.SUB, val, v);
            }
            return val;
        }
    };
    public static VncFunction multiply = new VncFunction("*", (VncVal)VncFunction.meta().arglists("(*)", "(* x)", "(* x y)", "(* x y & more)").doc("Returns the product of numbers. (*) returns 1").examples("(*)", "(* 4)", "(* 4 3)", "(* 4 3 2)", "(* 4I 3I)", "(* 6.0 2)", "(* 6 1.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    return new VncLong(1);
                }
                case 1: {
                    return MathFunctions.validateNumber("*", args.first());
                }
                case 2: {
                    return Numeric.calc(MathOp.MUL, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.MUL, val, v);
            }
            return val;
        }
    };
    public static VncFunction divide = new VncFunction("/", (VncVal)VncFunction.meta().arglists("(/ x)", "(/ x y)", "(/ x y & more)").doc("If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators.").examples("(/ 2.0)", "(/ 12 2 3)", "(/ 12 3)", "(/ 12I 3I)", "(/ 6.0 2)", "(/ 6 1.5M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            switch (args.size()) {
                case 0: {
                    throw new ArityException(0, "/");
                }
                case 1: {
                    VncVal first = args.first();
                    if (Types.isVncLong(first)) {
                        return Numeric.calc(MathOp.DIV, new VncLong(1L), first);
                    }
                    if (Types.isVncInteger(first)) {
                        return Numeric.calc(MathOp.DIV, new VncInteger(1), first);
                    }
                    if (Types.isVncDouble(first)) {
                        return Numeric.calc(MathOp.DIV, new VncDouble(1.0), first);
                    }
                    if (Types.isVncBigDecimal(first)) {
                        return Numeric.calc(MathOp.DIV, new VncBigDecimal(BigDecimal.ONE), first);
                    }
                    return MathFunctions.validateNumber("/", first);
                }
                case 2: {
                    return Numeric.calc(MathOp.DIV, args.first(), args.second());
                }
            }
            VncVal val = args.first();
            for (VncVal v : args.rest().getList()) {
                val = Numeric.calc(MathOp.DIV, val, v);
            }
            return val;
        }
    };
    public static VncFunction modulo = new VncFunction("mod", (VncVal)VncFunction.meta().arglists("(mod n d)").doc("Modulus of n and d.").examples("(mod 10 4)", "(mod -1 5)", "(mod 10I 4I)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("mod", args, 2);
            VncVal n = args.first();
            VncVal d = args.second();
            if (Types.isVncLong(n)) {
                if (Types.isVncLong(d)) {
                    return new VncLong(Math.floorMod((long)((VncLong)n).getValue(), ((VncLong)d).getValue()));
                }
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator if nominator is a long", Types.getType(args.second())));
            }
            if (Types.isVncInteger(n)) {
                if (Types.isVncInteger(d)) {
                    return new VncInteger(Math.floorMod(((VncInteger)n).getValue(), (int)((VncInteger)d).getValue()));
                }
                throw new VncException(String.format("Function 'mod' does not allow %s as denominator if nominator is an int", Types.getType(args.second())));
            }
            throw new VncException(String.format("Function 'mod' does not allow %s as numerator", Types.getType(args.first())));
        }
    };
    public static VncFunction inc = new VncFunction("inc", (VncVal)VncFunction.meta().arglists("(inc x)").doc("Increments the number x").examples("(inc 10)", "(inc 10I)", "(inc 10.1)", "(inc 10.12M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("inc", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(((VncLong)arg).getValue() + 1L);
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(((VncInteger)arg).getValue() + 1);
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() + 1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().add(new BigDecimal(1)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'inc'", Types.getType(arg)));
        }
    };
    public static VncFunction dec = new VncFunction("dec", (VncVal)VncFunction.meta().arglists("(dec x)").doc("Decrements the number x").examples("(dec 10)", "(dec 10I)", "(dec 10.1)", "(dec 10.12M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(((VncLong)arg).getValue() - 1L);
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(((VncInteger)arg).getValue() - 1);
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() - 1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().subtract(new BigDecimal(1)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'dec'", Types.getType(arg)));
        }
    };
    public static VncFunction max = new VncFunction("max", (VncVal)VncFunction.meta().arglists("(max x)", "(max x y)", "(max x y & more)").doc("Returns the greatest of the values").examples("(max 1)", "(max 1 2)", "(max 4 3 2 1)", "(max 1I 2I)", "(max 1.0)", "(max 1.0 2.0)", "(max 4.0 3.0 2.0 1.0)", "(max 1.0M)", "(max 1.0M 2.0M)", "(max 4.0M 3.0M 2.0M 1.0M)", "(max 1.0M 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return Constants.Nil;
            }
            VncVal max = args.first();
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncNumber(op)) {
                    max = max == Constants.Nil ? op : (op.compareTo(max) > 0 ? op : max);
                    continue;
                }
                if (op == Constants.Nil) continue;
                throw new VncException(String.format("Function 'max' does not allow %s as operand", Types.getType(max)));
            }
            return max;
        }
    };
    public static VncFunction min = new VncFunction("min", (VncVal)VncFunction.meta().arglists("(min x)", "(min x y)", "(min x y & more)").doc("Returns the smallest of the values").examples("(min 1)", "(min 1 2)", "(min 4 3 2 1)", "(min 1I 2I)", "(min 1.0)", "(min 1.0 2.0)", "(min 4.0 3.0 2.0 1.0)", "(min 1.0M)", "(min 1.0M 2.0M)", "(min 4.0M 3.0M 2.0M 1.0M)", "(min 1.0M 2)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return Constants.Nil;
            }
            VncVal min = args.first();
            for (VncVal op : args.rest().getList()) {
                if (Types.isVncNumber(op)) {
                    min = min == Constants.Nil ? op : (op.compareTo(min) < 0 ? op : min);
                    continue;
                }
                if (op == Constants.Nil) continue;
                throw new VncException(String.format("Function 'min' does not allow %s as operand", Types.getType(min)));
            }
            return min;
        }
    };
    public static VncFunction abs = new VncFunction("abs", (VncVal)VncFunction.meta().arglists("(abs x)").doc("Returns the absolute value of the number").examples("(abs 10)", "(abs -10)", "(abs -10I)", "(abs -10.1)", "(abs -10.12M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("abs", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.abs(((VncLong)arg).getValue()));
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(Math.abs(((VncInteger)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.abs(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(((VncBigDecimal)arg).getValue().abs());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'abs'", Types.getType(arg)));
        }
    };
    public static VncFunction negate = new VncFunction("negate", (VncVal)VncFunction.meta().arglists("(negate x)").doc("Negates x").examples("(negate 10)", "(negate 10I)", "(negate 1.23)", "(negate 1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("negate", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return new VncLong(Math.negateExact(((VncLong)arg).getValue()));
            }
            if (Types.isVncInteger(arg)) {
                return new VncInteger(Math.negateExact(((VncInteger)arg).getValue()));
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(((VncDouble)arg).getValue() * -1.0);
            }
            if (Types.isVncBigDecimal(arg)) {
                return new VncBigDecimal(Coerce.toVncBigDecimal(args.first()).getValue().negate());
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'negate'", Types.getType(arg)));
        }
    };
    public static VncFunction floor = new VncFunction("floor", (VncVal)VncFunction.meta().arglists("(floor x)").doc("Returns the largest integer that is less than or equal to x").examples("(floor 1.4)", "(floor -1.4)", "(floor 1.23M)", "(floor -1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("floor", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return arg;
            }
            if (Types.isVncInteger(arg)) {
                return arg;
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.floor(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                int scale = val.scale();
                val = val.setScale(0, RoundingMode.FLOOR);
                val = val.setScale(scale, RoundingMode.FLOOR);
                return new VncBigDecimal(val);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'floor'", Types.getType(arg)));
        }
    };
    public static VncFunction ceil = new VncFunction("ceil", (VncVal)VncFunction.meta().arglists("(ceil x)").doc("Returns the largest integer that is greater than or equal to x").examples("(ceil 1.4)", "(ceil -1.4)", "(ceil 1.23M)", "(ceil -1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("ceil", args, 1);
            VncVal arg = args.first();
            if (Types.isVncLong(arg)) {
                return arg;
            }
            if (Types.isVncInteger(arg)) {
                return arg;
            }
            if (Types.isVncDouble(arg)) {
                return new VncDouble(Math.ceil(((VncDouble)arg).getValue()));
            }
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                int scale = val.scale();
                val = val.setScale(0, RoundingMode.CEILING);
                val = val.setScale(scale, RoundingMode.CEILING);
                return new VncBigDecimal(val);
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'ceil'", Types.getType(arg)));
        }
    };
    public static VncFunction square = new VncFunction("square", (VncVal)VncFunction.meta().arglists("(square x)").doc("Square of x").examples("(square 10)", "(square 10I)", "(square 10.23)", "(square 10.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("square", args, 1);
            return Numeric.square(args.first());
        }
    };
    public static VncFunction sqrt = new VncFunction("sqrt", (VncVal)VncFunction.meta().arglists("(sqrt x)").doc("Square root of x").examples("(sqrt 10)", "(sqrt 10I)", "(sqrt 10.23)", "(sqrt 10.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sqrt", args, 1);
            return Numeric.sqrt(args.first());
        }
    };
    public static VncFunction sin = new VncFunction("sin", (VncVal)VncFunction.meta().arglists("(sin x)").doc("sin x").examples("(sin 1)", "(sin 1.23)", "(sin 1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("sin", args, 1);
            return new VncDouble(Math.sin(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction cos = new VncFunction("cos", (VncVal)VncFunction.meta().arglists("(cos x)").doc("cos x").examples("(cos 1)", "(cos 1.23)", "(cos 1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cos", args, 1);
            return new VncDouble(Math.cos(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction tan = new VncFunction("tan", (VncVal)VncFunction.meta().arglists("(tan x)").doc("tan x").examples("(tan 1)", "(tan 1.23)", "(tan 1.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("tan", args, 1);
            return new VncDouble(Math.tan(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction to_radians = new VncFunction("to-radians", (VncVal)VncFunction.meta().arglists("(to-radians x)").doc("to-radians x").examples("(to-radians 90)", "(to-radians 90.0)", "(to-radians 90.0M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("to-radians", args, 1);
            return new VncDouble(Math.toRadians(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction to_degrees = new VncFunction("to-degrees", (VncVal)VncFunction.meta().arglists("(to-degrees x)").doc("to-degrees x").examples("(to-degrees 3)", "(to-degrees 3.1415926)", "(to-degrees 3.1415926M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("to-degrees", args, 1);
            return new VncDouble(Math.toDegrees(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction log = new VncFunction("log", (VncVal)VncFunction.meta().arglists("(log x)").doc("log x").examples("(log 10)", "(log 10.23)", "(log 10.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("log", args, 1);
            return new VncDouble(Math.log(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction log10 = new VncFunction("log10", (VncVal)VncFunction.meta().arglists("(log10 x)").doc("log10 x").examples("(log10 10)", "(log10 10.23)", "(log10 10.23M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("log10", args, 1);
            return new VncDouble(Math.log10(Numeric.toDouble(args.first()).getValue()));
        }
    };
    public static VncFunction pow = new VncFunction("pow", (VncVal)VncFunction.meta().arglists("(pow x y)").doc("Returns the value of x raised to the power of y").examples("(pow 10 2)", "(pow 10.23 2)", "(pow 10.23 2.5)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pow", args, 2);
            return new VncDouble(Math.pow(Numeric.toDouble(args.first()).getValue(), Numeric.toDouble(args.second()).getValue()));
        }
    };
    public static VncFunction mean = new VncFunction("mean", (VncVal)VncFunction.meta().arglists("(mean x)", "(mean x y)", "(mean x y & more)").doc("Returns the mean value of the values").examples("(mean 10 20 30)", "(mean 1.4 3.6)", "(mean 2.8M 6.4M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (args.isEmpty()) {
                return Constants.Nil;
            }
            VncVal sum = add.apply(args);
            VncVal divisor = Types.isVncBigDecimal(sum) ? new VncBigDecimal(args.size()) : new VncDouble(args.size());
            return Numeric.calc(MathOp.DIV, sum, divisor);
        }
    };
    public static VncFunction standard_deviation = new VncFunction("standard-deviation", (VncVal)VncFunction.meta().arglists("(standard-deviation type coll)").doc("Returns the standard deviation of the values for data sample type :population or :sample.").examples("(standard-deviation :sample '(10 8 30 22 15))", "(standard-deviation :population '(10 8 30 22 15))", "(standard-deviation :sample '(1.4 3.6 7.8 9.0 2.2))", "(standard-deviation :sample '(2.8M 6.4M 2.0M 4.4M))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("standard-deviation", args, 2);
            boolean sample = "sample".equals(Coerce.toVncKeyword(args.first()).getValue());
            VncList data = Coerce.toVncList(args.second());
            if (data.isEmpty() || data.size() == 1) {
                return new VncDouble(0.0);
            }
            VncVal average = mean.apply(data);
            VncVal deltaSum = new VncDouble(0.0);
            for (VncVal v : data.getList()) {
                deltaSum = Numeric.calc(MathOp.ADD, deltaSum, Numeric.square(Numeric.calc(MathOp.SUB, v, average)));
            }
            return Numeric.toDouble(Numeric.sqrt(Numeric.calc(MathOp.DIV, deltaSum, new VncDouble(sample ? data.size() - 1 : data.size()))));
        }
    };
    public static VncFunction median = new VncFunction("median", (VncVal)VncFunction.meta().arglists("(median coll)").doc("Returns the median of the values").examples("(median '(3 1 2))", "(median '(3 2 1 4))", "(median '(3.6 1.4 4.8))", "(median '(3.6M 1.4M 4.8M))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("median", args, 1);
            VncList data = Coerce.toVncList(args.first());
            if (data.isEmpty()) {
                return Constants.Nil;
            }
            return MathFunctions.median((VncList)CoreFunctions.sort.apply(VncList.of(data)));
        }
    };
    public static VncFunction quartiles = new VncFunction("quartiles", (VncVal)VncFunction.meta().arglists("(quartiles coll)").doc("Returns the quartiles (1st, 2nd, and 3rd) of the values").examples("(quartiles '(3, 7, 8, 5, 12, 14, 21, 13, 18))", "(quartiles '(3, 7, 8, 5, 12, 14, 21, 15, 18, 14))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("quartiles", args, 1);
            VncList list = Coerce.toVncList(args.first());
            if (list.size() < 2) {
                return Constants.Nil;
            }
            VncList sorted = (VncList)CoreFunctions.sort.apply(VncList.of(list));
            VncList data = MathFunctions.medianWithHalfs(sorted);
            return VncList.of(MathFunctions.median((VncList)data.second()), data.first(), MathFunctions.median((VncList)data.third()));
        }
    };
    public static VncFunction quantile = new VncFunction("quantile", (VncVal)VncFunction.meta().arglists("(quantile q coll)").doc("Returns the quantile [0.0 .. 1.0] of the values").examples("(quantile 0.5 '(3, 7, 8, 5, 12, 14, 21, 13, 18))", "(quantile 0.5 '(3, 7, 8, 5, 12, 14, 21, 15, 18, 14))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("quantile", args, 2);
            double q = Coerce.toVncDouble(args.first()).getValue();
            VncList list = Coerce.toVncList(args.second());
            if (list.size() < 2) {
                return Constants.Nil;
            }
            VncList data = (VncList)CoreFunctions.sort.apply(VncList.of(list));
            if (q < 0.0 || q > 1.0) {
                throw new VncException("A quantile q must be in the range 0.0 .. 1.0");
            }
            if (q == 0.0) {
                return data.first();
            }
            if (q == 1.0) {
                return data.last();
            }
            int n = data.size() - 1;
            double x = q * (double)n;
            double f = Math.floor(x);
            int idx = (int)f;
            double p = x - f;
            double res = p * MathFunctions.toDouble(data.nth(idx + 1)) + (1.0 - p) * MathFunctions.toDouble(data.nth(idx));
            return new VncDouble(res);
        }
    };
    public static VncFunction rand_long = new VncFunction("rand-long", (VncVal)VncFunction.meta().arglists("(rand-long)", "(rand-long max)").doc("Without argument returns a random long between 0 and MAX_LONG. With argument max returns a random long between 0 and max exclusive.\nThis function is based on a cryptographically strong random number generator (RNG).").examples("(rand-long)", "(rand-long 100)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-long", args, 0, 1);
            if (args.isEmpty()) {
                return new VncLong(Math.abs(random.nextLong()));
            }
            long max = Coerce.toVncLong(args.first()).getValue();
            if (max < 2L) {
                throw new VncException("Function 'rand-long' does not allow negative max values");
            }
            return new VncLong(Math.abs(random.nextLong()) % max);
        }
    };
    public static VncFunction rand_double = new VncFunction("rand-double", (VncVal)VncFunction.meta().arglists("(rand-double)", "(rand-double max)").doc("Without argument returns a double between 0.0 and 1.0. With argument max returns a random double between 0.0 and max.\nThis function is based on a cryptographically strong random number generator (RNG).").examples("(rand-double)", "(rand-double 100.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-double", args, 0, 1);
            if (args.isEmpty()) {
                return new VncDouble(random.nextDouble());
            }
            double max = Coerce.toVncDouble(args.first()).getValue();
            if (max < 0.0) {
                throw new VncException("Function 'rand-double' does not allow negative max values");
            }
            return new VncDouble(random.nextDouble() * max);
        }
    };
    public static VncFunction rand_gaussian = new VncFunction("rand-gaussian", (VncVal)VncFunction.meta().arglists("(rand-gaussian)", "(rand-gaussian mean stddev)").doc("Without argument returns a Gaussion distributed double value with mean 0.0 and standard deviation 1.0. With argument mean and stddev returns a Gaussion distributed double value with the given mean and standard deviation.\nThis function is based on a cryptographically strong random number generator (RNG)").examples("(rand-gaussian)", "(rand-gaussian 0.0 5.0)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("rand-gaussian", args, 0, 2);
            if (args.isEmpty()) {
                return new VncDouble(random.nextGaussian());
            }
            double mean = Coerce.toVncDouble(args.first()).getValue();
            double stddev = Coerce.toVncDouble(args.second()).getValue();
            return new VncDouble(mean + stddev * random.nextGaussian());
        }
    };
    public static VncFunction zero_Q = new VncFunction("zero?", (VncVal)VncFunction.meta().arglists("(zero? x)").doc("Returns true if x zero else false").examples("(zero? 0)", "(zero? 2)", "(zero? (int 0))", "(zero? 0.0)", "(zero? 0.0M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("zero?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return VncBoolean.of(((VncLong)op1).getValue() == 0L);
            }
            if (Types.isVncInteger(op1)) {
                return VncBoolean.of(((VncInteger)op1).getValue() == 0);
            }
            if (Types.isVncDouble(op1)) {
                return VncBoolean.of(((VncDouble)op1).getValue() == 0.0);
            }
            if (Types.isVncBigDecimal(op1)) {
                return VncBoolean.of(((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) == 0);
            }
            throw new VncException(String.format("Function 'zero?' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction pos_Q = new VncFunction("pos?", (VncVal)VncFunction.meta().arglists("(pos? x)").doc("Returns true if x greater than zero else false").examples("(pos? 3)", "(pos? -3)", "(pos? (int 3))", "(pos? 3.2)", "(pos? 3.2M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("pos?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return VncBoolean.of(((VncLong)op1).getValue() > 0L);
            }
            if (Types.isVncInteger(op1)) {
                return VncBoolean.of(((VncInteger)op1).getValue() > 0);
            }
            if (Types.isVncDouble(op1)) {
                return VncBoolean.of(((VncDouble)op1).getValue() > 0.0);
            }
            if (Types.isVncBigDecimal(op1)) {
                return VncBoolean.of(((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) > 0);
            }
            throw new VncException(String.format("Function 'pos?' does not allow %s as operand 1", Types.getType(op1)));
        }
    };
    public static VncFunction neg_Q = new VncFunction("neg?", (VncVal)VncFunction.meta().arglists("(neg? x)").doc("Returns true if x smaller than zero else false").examples("(neg? -3)", "(neg? 3)", "(neg? (int -3))", "(neg? -3.2)", "(neg? -3.2M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("neg?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return VncBoolean.of(((VncLong)op1).getValue() < 0L);
            }
            if (Types.isVncInteger(op1)) {
                return VncBoolean.of(((VncInteger)op1).getValue() < 0);
            }
            if (Types.isVncDouble(op1)) {
                return VncBoolean.of(((VncDouble)op1).getValue() < 0.0);
            }
            if (Types.isVncBigDecimal(op1)) {
                return VncBoolean.of(((VncBigDecimal)op1).getValue().compareTo(BigDecimal.ZERO) < 0);
            }
            throw new VncException(String.format("Function 'neg?' does not allow %s as operand 1s", Types.getType(op1)));
        }
    };
    public static VncFunction even_Q = new VncFunction("even?", (VncVal)VncFunction.meta().arglists("(even? n)").doc("Returns true if n is even, throws an exception if n is not an integer").examples("(even? 4)", "(even? 3)", "(even? (int 3))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("even?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return VncBoolean.of(((VncLong)op1).getValue() % 2L == 0L);
            }
            if (Types.isVncInteger(op1)) {
                return VncBoolean.of(((VncInteger)op1).getValue() % 2 == 0);
            }
            throw new VncException(String.format("Function 'even?' does not allow %s as operand.", Types.getType(op1)));
        }
    };
    public static VncFunction odd_Q = new VncFunction("odd?", (VncVal)VncFunction.meta().arglists("(odd? n)").doc("Returns true if n is odd, throws an exception if n is not an integer").examples("(odd? 3)", "(odd? 4)", "(odd? (int 4))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("odd?", args, 1);
            VncVal op1 = args.first();
            if (Types.isVncLong(op1)) {
                return VncBoolean.of(((VncLong)op1).getValue() % 2L == 1L);
            }
            if (Types.isVncInteger(op1)) {
                return VncBoolean.of(((VncInteger)op1).getValue() % 2 == 1);
            }
            throw new VncException(String.format("Function 'odd?' does not allow %s as operand", Types.getType(op1)));
        }
    };
    public static VncFunction dec_add = new VncFunction("dec/add", (VncVal)VncFunction.meta().arglists("(dec/add x y scale rounding-mode)").doc("Adds two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/add 2.44697M 1.79882M 3 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/add", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().add(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_sub = new VncFunction("dec/sub", (VncVal)VncFunction.meta().arglists("(dec/sub x y scale rounding-mode)").doc("Subtract y from x and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/sub 2.44697M 1.79882M 3 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/sub", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().subtract(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_mul = new VncFunction("dec/mul", (VncVal)VncFunction.meta().arglists("(dec/mul x y scale rounding-mode)").doc("Multiplies two decimals and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/mul 2.44697M 1.79882M 5 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/mul", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().multiply(op2.getValue()).setScale(scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_div = new VncFunction("dec/div", (VncVal)VncFunction.meta().arglists("(dec/div x y scale rounding-mode)").doc("Divides x by y and scales the result. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/div 2.44697M 1.79882M 5 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/div", args, 4);
            VncBigDecimal op1 = Coerce.toVncBigDecimal(args.first());
            VncBigDecimal op2 = Coerce.toVncBigDecimal(args.second());
            VncLong scale = Coerce.toVncLong(args.nth(2));
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode(Coerce.toVncString(args.nth(3)));
            return new VncBigDecimal(op1.getValue().divide(op2.getValue(), scale.getValue().intValue(), roundingMode));
        }
    };
    public static VncFunction dec_scale = new VncFunction("dec/scale", (VncVal)VncFunction.meta().arglists("(dec/scale x scale rounding-mode)").doc("Scales a decimal. rounding-mode is one of (:CEILING, :DOWN, :FLOOR, :HALF_DOWN, :HALF_EVEN, :HALF_UP, :UNNECESSARY, :UP)").examples("(dec/scale 2.44697M 0 :HALF_UP)", "(dec/scale 2.44697M 1 :HALF_UP)", "(dec/scale 2.44697M 2 :HALF_UP)", "(dec/scale 2.44697M 3 :HALF_UP)", "(dec/scale 2.44697M 10 :HALF_UP)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("dec/scale", args, 3);
            VncVal arg = args.first();
            VncLong scale = Coerce.toVncLong(args.second());
            RoundingMode roundingMode = VncBigDecimal.toRoundingMode((VncString)args.nth(2));
            if (Types.isVncBigDecimal(arg)) {
                BigDecimal val = ((VncBigDecimal)arg).getValue();
                return new VncBigDecimal(val.setScale(scale.getValue().intValue(), roundingMode));
            }
            throw new VncException(String.format("Function 'dec/scale' does not allow %s as operand 1s", Types.getType(arg)));
        }
    };
    public static VncFunction range = new VncFunction("range", (VncVal)VncFunction.meta().arglists("(range end)", "(range start end)", "(range start end step)").doc("Returns a collection of numbers from start (inclusive) to end (exclusive), by step, where start defaults to 0 and step defaults to 1. When start is equal to end, returns empty list.").examples("(range 10)", "(range 10 20)", "(range 10 20 3)", "(range (int 10) (int 20))", "(range (int 10) (int 20) (int 3))", "(range 10 15 0.5)", "(range 1.1M 2.2M 0.1M)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("range", args, 1, 2, 3);
            VncVal start = null;
            VncVal end = null;
            VncVal step = null;
            switch (args.size()) {
                case 1: {
                    start = new VncLong(0);
                    end = args.first();
                    step = new VncLong(1);
                    break;
                }
                case 2: {
                    start = args.first();
                    end = args.second();
                    step = Types.isVncInteger(start) ? new VncInteger(1) : new VncLong(1);
                    break;
                }
                case 3: {
                    start = args.first();
                    end = args.second();
                    step = args.nth(2);
                }
            }
            if (!Types.isVncNumber(start)) {
                throw new VncException("range: start value must be a number");
            }
            if (!Types.isVncNumber(end)) {
                throw new VncException("range: end value must be a number");
            }
            if (!Types.isVncNumber(step)) {
                throw new VncException("range: step value must be a number");
            }
            ArrayList<VncVal> values = new ArrayList<VncVal>();
            if (VncBoolean.isTrue(zero_Q.apply(VncList.of(step)))) {
                throw new VncException("range: a step value must not be 0");
            }
            if (VncBoolean.isTrue(pos_Q.apply(VncList.of(step)))) {
                if (VncBoolean.isTrue(CoreFunctions.lt.apply(VncList.of(end, start)))) {
                    throw new VncException("range positive step: end must not be lower than start");
                }
                VncVal val = start;
                while (VncBoolean.isTrue(CoreFunctions.lt.apply(VncList.of(val, end)))) {
                    values.add(val);
                    val = add.apply(VncList.of(val, step));
                }
            } else {
                if (VncBoolean.isTrue(CoreFunctions.gt.apply(VncList.of(end, start)))) {
                    throw new VncException("range negative step: end must not be greater than start");
                }
                VncVal val = start;
                while (VncBoolean.isTrue(CoreFunctions.gt.apply(VncList.of(val, end)))) {
                    values.add(val);
                    val = add.apply(VncList.of(val, step));
                }
            }
            return new VncList(values);
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(add).add(subtract).add(multiply).add(divide).add(modulo).add(inc).add(dec).add(abs).add(min).add(max).add(negate).add(floor).add(ceil).add(square).add(sqrt).add(pow).add(to_radians).add(to_degrees).add(sin).add(cos).add(tan).add(log).add(log10).add(mean).add(median).add(quartiles).add(quantile).add(standard_deviation).add(dec_add).add(dec_sub).add(dec_mul).add(dec_div).add(dec_scale).add(zero_Q).add(pos_Q).add(neg_Q).add(even_Q).add(odd_Q).add(rand_long).add(rand_double).add(rand_gaussian).add(range).toMap();
    private static final SecureRandom random = new SecureRandom();

    private static VncVal validateNumber(String fnName, VncVal val) {
        if (!Types.isVncNumber(val)) {
            throw new VncException(String.format("%s: Not a number. Got a %s", fnName, Types.getType(val)));
        }
        return val;
    }

    private static boolean isOdd(int val) {
        return val % 2 == 1;
    }

    private static VncList medianWithHalfs(VncList sortedData) {
        VncList upperHalf;
        VncList lowerHalf;
        VncVal median;
        if (MathFunctions.isOdd(sortedData.size())) {
            median = MathFunctions.median(sortedData);
            lowerHalf = sortedData.slice(0, sortedData.size() / 2);
            upperHalf = sortedData.slice(sortedData.size() / 2 + 1);
        } else {
            median = MathFunctions.median(sortedData);
            lowerHalf = sortedData.slice(0, sortedData.size() / 2);
            upperHalf = sortedData.slice(sortedData.size() / 2);
        }
        return VncList.of(median, lowerHalf, upperHalf);
    }

    private static VncVal median(VncList sortedData) {
        VncVal upperMedian;
        if (sortedData.isEmpty()) {
            return Constants.Nil;
        }
        if (MathFunctions.isOdd(sortedData.size())) {
            VncVal median = sortedData.nth(sortedData.size() / 2);
            return Types.isVncBigDecimal(median) ? median : Numeric.toDouble(median);
        }
        VncVal lowerMedian = sortedData.nth(sortedData.size() / 2 - 1);
        VncVal sum = Numeric.calc(MathOp.ADD, lowerMedian, upperMedian = sortedData.nth(sortedData.size() / 2));
        VncVal divisor = Types.isVncBigDecimal(sum) ? new VncBigDecimal(2L) : new VncDouble(2.0);
        return Numeric.calc(MathOp.DIV, sum, divisor);
    }

    private static double toDouble(VncVal val) {
        return Numeric.toDouble(val).getValue();
    }
}

