/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.InterruptedException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class VncQueue
extends VncCollection {
    public static final VncKeyword TYPE = new VncKeyword(":core/queue");
    private static final long serialVersionUID = -564531670922145260L;
    private final int capacity;
    private final LinkedBlockingDeque<VncVal> queue;

    public VncQueue() {
        this(Integer.MAX_VALUE);
    }

    public VncQueue(int capacity) {
        super(Constants.Nil);
        this.capacity = capacity;
        this.queue = new LinkedBlockingDeque(capacity);
    }

    private VncQueue(VncQueue queue, VncVal meta) {
        super(meta);
        this.capacity = queue.capacity;
        this.queue = queue.queue;
    }

    @Override
    public VncCollection emptyWithMeta() {
        return new VncQueue(this.capacity);
    }

    @Override
    public VncQueue withMeta(VncVal meta) {
        return new VncQueue(this, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncCollection.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncCollection.TYPE, VncVal.TYPE);
    }

    @Override
    public VncList toVncList() {
        return VncList.of(this.queue.toArray(new VncVal[0]));
    }

    @Override
    public VncVector toVncVector() {
        return VncVector.of(this.queue.toArray(new VncVal[0]));
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public VncQueue offer(VncVal val) {
        this.queue.offer(val);
        return this;
    }

    public VncQueue offer(VncVal val, long timeoutMillis) {
        try {
            this.queue.offer(val, timeoutMillis, TimeUnit.MILLISECONDS);
            return this;
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (offer queue timeout val)", ex);
        }
    }

    public VncVal poll() {
        return this.toNil(this.queue.poll());
    }

    public VncVal poll(long timeoutMillis) {
        try {
            return this.toNil(this.queue.poll(timeoutMillis, TimeUnit.MILLISECONDS));
        }
        catch (java.lang.InterruptedException ex) {
            throw new InterruptedException("interrupted while calling (poll queue timeout)", ex);
        }
    }

    public VncVal peek() {
        return this.toNil(this.queue.peek());
    }

    public void clear() {
        this.queue.clear();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.QUEUE;
    }

    @Override
    public Object convertToJavaObject() {
        return Arrays.stream(this.queue.toArray(new VncVal[0])).map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    public String toString() {
        return "(" + Printer.join(this.toVncList().getList(), " ", true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(" + Printer.join(this.toVncList().getList(), " ", print_readably) + ")";
    }

    private VncVal toNil(VncVal val) {
        return val == null ? Constants.Nil : val;
    }
}

