/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.repl;

import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.LinkedList;
import java.util.stream.IntStream;

public class ReplResultHistory {
    private final LinkedList<VncVal> results = new LinkedList();

    public ReplResultHistory(int max) {
        IntStream.range(0, max).forEach(ii -> this.results.add(Constants.Nil));
    }

    public void add(VncVal val) {
        this.results.addFirst(val == null ? Constants.Nil : val);
        this.results.removeLast();
    }

    public void mergeToEnv(Env env) {
        IntStream.rangeClosed(1, this.results.size()).forEach(ii -> this.addToEnv(env, "*" + ii, this.results.get(ii - 1)));
        this.addToEnv(env, "**", VncList.ofList(this.results));
    }

    public void addToEnv(Env env, String name, VncVal val) {
        env.setGlobal(new Var(new VncSymbol(name), val));
    }
}

