/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.javainterop.JavaInteropUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IVncJavaObject;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class VncJavaMap
extends VncMap
implements IVncJavaObject {
    private static final long serialVersionUID = -1848883965231344442L;
    private final Map<Object, Object> value;

    public VncJavaMap() {
        this((Map<Object, Object>)null, (VncVal)null);
    }

    public VncJavaMap(VncVal meta) {
        this((Map<Object, Object>)null, meta);
    }

    public VncJavaMap(Map<Object, Object> val) {
        this(val, null);
    }

    public VncJavaMap(Map<Object, Object> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val;
    }

    @Override
    public Object getDelegate() {
        return this.value;
    }

    @Override
    public VncJavaMap emptyWithMeta() {
        return new VncJavaMap(this.getMeta());
    }

    @Override
    public VncHashMap withValues(Map<VncVal, VncVal> replaceVals) {
        return new VncHashMap(replaceVals, this.getMeta());
    }

    @Override
    public VncHashMap withValues(Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncHashMap(replaceVals, meta);
    }

    @Override
    public VncJavaMap withMeta(VncVal meta) {
        return new VncJavaMap(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return new VncKeyword(this.value.getClass().getName());
    }

    @Override
    public VncKeyword getSupertype() {
        return new VncKeyword(this.value.getClass().getSuperclass().getName());
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(this.getSupertype());
    }

    @Override
    public Map<VncVal, VncVal> getMap() {
        return this.value.entrySet().stream().collect(Collectors.toMap(e -> JavaInteropUtil.convertToVncVal(e.getKey()), e -> JavaInteropUtil.convertToVncVal(e.getValue())));
    }

    @Override
    public VncVal get(VncVal key) {
        return JavaInteropUtil.convertToVncVal(this.value.get(key.convertToJavaObject()));
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return VncBoolean.of(this.value.containsKey(key.convertToJavaObject()));
    }

    @Override
    public VncList keys() {
        return VncList.ofList(this.value.keySet().stream().map(k -> JavaInteropUtil.convertToVncVal(k)).collect(Collectors.toList()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.getMap().entrySet().stream().map(e -> new VncMapEntry((VncVal)e.getKey(), (VncVal)e.getValue())).collect(Collectors.toList()));
    }

    @Override
    public VncJavaMap putAll(VncMap map) {
        this.getMap().entrySet().forEach(e -> this.value.put(((VncVal)e.getKey()).convertToJavaObject(), ((VncVal)e.getValue()).convertToJavaObject()));
        return this;
    }

    @Override
    public VncJavaMap assoc(VncVal ... mvs) {
        for (int i = 0; i < mvs.length; i += 2) {
            this.value.put(mvs[i].convertToJavaObject(), mvs[i + 1].convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncJavaMap assoc(VncSequence mvs) {
        for (int i = 0; i < mvs.getList().size(); i += 2) {
            this.value.put(mvs.nth(i).convertToJavaObject(), mvs.nth(i).convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncJavaMap dissoc(VncVal ... keys) {
        for (VncVal key : keys) {
            this.value.remove(key.convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncJavaMap dissoc(VncSequence keys) {
        for (int i = 0; i < keys.getList().size(); ++i) {
            this.value.remove(keys.nth(i).convertToJavaObject());
        }
        return this;
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value.entrySet().stream().map(e -> VncVector.of(JavaInteropUtil.convertToVncVal(e.getKey()), JavaInteropUtil.convertToVncVal(e.getValue()))).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value.entrySet().stream().map(e -> VncVector.of(JavaInteropUtil.convertToVncVal(e.getKey()), JavaInteropUtil.convertToVncVal(e.getValue()))).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.JAVAMAP;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncJavaMap(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncJavaMap)o).size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncJavaMap other = (VncJavaMap)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        ArrayList<VncVal> list = new ArrayList<VncVal>();
        this.value.entrySet().forEach(e -> {
            list.add(JavaInteropUtil.convertToVncVal(e.getKey()));
            list.add(JavaInteropUtil.convertToVncVal(e.getValue()));
        });
        return "{" + Printer.join(list, " ", print_readably) + "}";
    }
}

