/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class StringUtil {
    public static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        int end;
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null || max == 0) {
            return text;
        }
        String textLowerCase = ignoreCase ? text.toLowerCase() : null;
        String searchStringLowerCase = ignoreCase ? searchString.toLowerCase() : null;
        int start = 0;
        int n = end = ignoreCase ? textLowerCase.indexOf(searchStringLowerCase, start) : text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int count = max;
        int replLength = searchString.length();
        StringBuilder buf = new StringBuilder(text.length());
        while (end != -1) {
            buf.append(text, start, end).append(replacement);
            start = end + replLength;
            if (--count == 0) break;
            end = ignoreCase ? textLowerCase.indexOf(searchStringLowerCase, start) : text.indexOf(searchString, start);
        }
        if (start < text.length()) {
            buf.append(text, start, text.length());
        }
        return buf.toString();
    }

    public static String replaceLast(String text, String searchString, String replacement, boolean ignoreCase) {
        int end;
        if (StringUtil.isEmpty(text) || StringUtil.isEmpty(searchString) || replacement == null) {
            return text;
        }
        String textLowerCase = ignoreCase ? text.toLowerCase() : null;
        String searchStringLowerCase = ignoreCase ? searchString.toLowerCase() : null;
        int n = end = ignoreCase ? textLowerCase.lastIndexOf(searchStringLowerCase) : text.lastIndexOf(searchString);
        if (end == -1) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        buf.append(text, 0, end);
        buf.append(replacement);
        buf.append(text, end + searchString.length(), text.length());
        return buf.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> splitIntoLines(String text) {
        if (text == null) return new ArrayList<String>();
        if (text.isEmpty()) {
            return new ArrayList<String>();
        }
        try (BufferedReader br = new BufferedReader(new StringReader(text));){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException | RuntimeException ex) {
            throw new RuntimeException("Failed to split text into lines", ex);
        }
    }

    public static String escape(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        block7: for (char c : text.toCharArray()) {
            switch (c) {
                case '\n': {
                    sb.append('\\').append('n');
                    continue block7;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block7;
                }
                case '\t': {
                    sb.append('\\').append('t');
                    continue block7;
                }
                case '\"': {
                    sb.append('\\').append('\"');
                    continue block7;
                }
                case '\\': {
                    sb.append('\\').append('\\');
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static int indexOneCharOf(String text, String searchChars, int startPos) {
        if (text == null) {
            throw new IllegalArgumentException("A text must not be null");
        }
        if (StringUtil.isEmpty(searchChars)) {
            throw new IllegalArgumentException("A searchChars must not be empty");
        }
        if (startPos < 0) {
            throw new IllegalArgumentException("A startPos must not be negativ");
        }
        if (startPos >= text.length()) {
            return -1;
        }
        Set chars = searchChars.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet());
        for (int pos = startPos; pos < text.length(); ++pos) {
            if (!chars.contains(Character.valueOf(text.charAt(pos)))) continue;
            return pos;
        }
        return -1;
    }

    public static int indexNotOf(String text, String searchChars, int startPos) {
        if (text == null) {
            throw new IllegalArgumentException("A text must not be null");
        }
        if (StringUtil.isEmpty(searchChars)) {
            throw new IllegalArgumentException("A searchChars must not be empty");
        }
        if (startPos < 0) {
            throw new IllegalArgumentException("A startPos must not be negativ");
        }
        if (startPos >= text.length()) {
            return -1;
        }
        Set chars = searchChars.chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet());
        for (int pos = startPos; pos < text.length(); ++pos) {
            if (chars.contains(Character.valueOf(text.charAt(pos)))) {
                continue;
            }
            return pos;
        }
        return -1;
    }

    public static String stripIndent(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        List<String> lines = StringUtil.splitIntoLines(text);
        String indent = StringUtil.indentStr(lines.get(0));
        if (indent != null) {
            lines = StringUtil.stripIndent(indent, lines);
        }
        return String.join((CharSequence)"\n", lines);
    }

    public static String stripIndentIfFirstLineEmpty(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        List<String> lines = StringUtil.splitIntoLines(text);
        if (lines.size() == 1 || !lines.get(0).isEmpty()) {
            return String.join((CharSequence)"\n", lines);
        }
        String indent = StringUtil.indentStr((lines = lines.subList(1, lines.size())).get(0));
        if (indent != null && (lines = StringUtil.stripIndent(indent, lines)).get(lines.size() - 1).isEmpty()) {
            lines = lines.subList(0, lines.size() - 1);
        }
        lines = StringUtil.joinLinesEndingWithBackslash(lines);
        return String.join((CharSequence)"\n", lines);
    }

    public static String stripMargin(String text, char margin) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringUtil.splitIntoLines(text).stream().map(s -> {
            int pos = s.indexOf(margin);
            return pos < 0 ? s : s.substring(pos + 1);
        }).collect(Collectors.joining("\n"));
    }

    public static String truncate(String text, int maxLen, String truncationMarker) {
        if (truncationMarker == null) {
            throw new IllegalArgumentException("A truncationMarker must not be null");
        }
        int lenTruncationMarker = truncationMarker.length();
        if (maxLen <= lenTruncationMarker) {
            throw new IllegalArgumentException("A maxLen must greater than the length of the truncation marker");
        }
        if (text == null || text.length() <= maxLen) {
            return text;
        }
        return text.substring(0, maxLen - lenTruncationMarker) + truncationMarker;
    }

    public static String repeat(String s, int times) {
        if (s == null) {
            throw new IllegalArgumentException("s must not be null");
        }
        if (times < 0) {
            throw new IllegalArgumentException("A times must not be negative");
        }
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < times; ++ii) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String repeat(char c, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("A times must not be negative");
        }
        return new String(new char[times]).replace('\u0000', c);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtil.isEmpty(s);
    }

    public static boolean isBlank(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !StringUtil.isBlank(s);
    }

    public static boolean isAsciiAlphaUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static String removeStart(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String emptyToNull(String s) {
        return StringUtil.isEmpty(s) ? null : s;
    }

    public static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trimToNull(String str) {
        String s = str == null ? null : str.trim();
        return StringUtil.isEmpty(s) ? null : s;
    }

    public static String decodeUnicode(String s) {
        int length;
        String working = s;
        int index = working.indexOf("\\u");
        while (index > -1 && index <= (length = working.length()) - 6) {
            int numStart = index + 2;
            int numFinish = numStart + 4;
            String substring = working.substring(numStart, numFinish);
            int number = Integer.parseInt(substring, 16);
            String stringStart = working.substring(0, index);
            String stringEnd = working.substring(numFinish);
            working = stringStart + (char)number + stringEnd;
            index = working.indexOf("\\u");
        }
        return working;
    }

    public static String quote(String str, char quote) {
        return quote + str + quote;
    }

    public static String replaceLeadingSpaces(String text, char replaceChar) {
        if (text == null) {
            return null;
        }
        int count = StringUtil.indexNotOf(text, " ", 0);
        if (count > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(StringUtil.repeat(replaceChar, count));
            sb.append(text.substring(count));
            return sb.toString();
        }
        return text;
    }

    private static List<String> stripIndent(String indent, List<String> lines) {
        int skipChars = indent.length();
        return lines.stream().map(s -> s.startsWith(indent) ? s.substring(skipChars) : s).collect(Collectors.toList());
    }

    private static String indentStr(String line) {
        int firstBlankPos = StringUtil.indexOneCharOf(line, " \t", 0);
        if (firstBlankPos < 0) {
            return null;
        }
        int firstNonBlankPos = StringUtil.indexNotOf(line, " \t", 0);
        return firstNonBlankPos < 0 ? line : line.substring(0, firstNonBlankPos);
    }

    private static List<String> joinLinesEndingWithBackslash(List<String> lines) {
        ArrayList<String> joined = new ArrayList<String>();
        String joinLine = null;
        for (int ii = 0; ii < lines.size(); ++ii) {
            String line = lines.get(ii);
            if (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1);
                joinLine = joinLine == null ? line : joinLine + line;
                continue;
            }
            joined.add(joinLine == null ? line : joinLine + line);
            joinLine = null;
        }
        if (joinLine != null) {
            joined.add(joinLine);
        }
        return joined;
    }
}

