/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Binding;
import com.github.jlangch.venice.impl.DynamicVar;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.ReservedSymbols;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CallFrame;
import com.github.jlangch.venice.impl.util.CallStack;
import com.github.jlangch.venice.impl.util.WithCallStack;
import com.github.jlangch.venice.util.NullInputStream;
import com.github.jlangch.venice.util.NullOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Env
implements Serializable {
    private static final long serialVersionUID = 9002640180394221858L;
    private final boolean failOnShadowingGlobalVars = false;
    private final boolean failOnPrivateSymbolAccess = true;
    private final Env outer;
    private final int level;
    private final Map<VncSymbol, Var> precompiledGlobalSymbols;
    private final Map<VncSymbol, Var> globalSymbols;
    private final Map<VncSymbol, Var> localSymbols;

    public Env() {
        this((Env)null);
    }

    public Env(Env outer) {
        this.outer = outer;
        this.level = outer == null ? 0 : outer.level() + 1;
        this.precompiledGlobalSymbols = outer == null ? null : outer.precompiledGlobalSymbols;
        this.globalSymbols = outer == null ? new ConcurrentHashMap() : outer.globalSymbols;
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>();
    }

    private Env(Map<VncSymbol, Var> precompiledGlobalSymbols) {
        this.outer = null;
        this.level = 0;
        this.precompiledGlobalSymbols = precompiledGlobalSymbols;
        this.globalSymbols = new ConcurrentHashMap<VncSymbol, Var>();
        this.localSymbols = new ConcurrentHashMap<VncSymbol, Var>();
    }

    public Env copyGlobalToPrecompiledSymbols() {
        return new Env(this.globalSymbols);
    }

    public VncVal get(VncSymbol sym) {
        VncVal val = this.getOrElse(sym, null);
        if (val != null) {
            return val;
        }
        WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
        Throwable throwable = null;
        try {
            try {
                throw new VncException(String.format("Symbol '%s' not found.", sym.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (cs != null) {
                if (throwable != null) {
                    try {
                        cs.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    cs.close();
                }
            }
            throw throwable3;
        }
    }

    public boolean isBound(VncSymbol sym) {
        if (sym.hasNamespace()) {
            return this.getGlobalVar(sym) != null;
        }
        VncVal v = this.findLocalVar(sym);
        return v != null ? true : this.getGlobalVar(sym) != null;
    }

    public VncVal getOrNil(VncSymbol sym) {
        return this.getOrElse(sym, Constants.Nil);
    }

    public VncVal getGlobalOrNil(VncSymbol sym) {
        Var v = this.getGlobalVar(sym);
        return v != null ? v.getVal() : Constants.Nil;
    }

    public VncVal getGlobalOrNull(VncSymbol sym) {
        Var v = this.getGlobalVar(sym);
        return v != null ? v.getVal() : null;
    }

    public Var getGlobalVarOrNull(VncSymbol sym) {
        return this.getGlobalVar(sym);
    }

    public int level() {
        return this.level;
    }

    public Env setLocal(VncSymbol sym, VncVal val) {
        if (sym.getName().equals("*ns*")) {
            throw new VncException(String.format("Internal error setting var %s", sym.getName()));
        }
        this.setLocalVar(sym, new Var(sym, val));
        return this;
    }

    public Env setGlobal(Var val) {
        if (val.getName().equals(Namespaces.NS_CURRENT_SYMBOL)) {
            throw new VncException(String.format("Internal error setting var %s", val.getName().getName()));
        }
        Var v = this.getGlobalVar(val.getName());
        if (v != null && !v.isOverwritable()) {
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(val.getName()));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The existing global var '%s' must not be overwritten!", val.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        this.setGlobalVar(val.getName(), val);
        return this;
    }

    public Env addGlobalVars(List<Var> vars) {
        if (vars != null) {
            vars.forEach(v -> this.setGlobal((Var)v));
        }
        return this;
    }

    public void addLocalBindings(List<Binding> bindings) {
        for (Binding b : bindings) {
            this.setLocal(b.sym, b.val);
        }
    }

    public void pushGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        if (dv != null) {
            dv.pushVal(val);
        } else {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        }
    }

    public VncVal popGlobalDynamic(VncSymbol sym) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        return dv != null ? dv.popVal() : Constants.Nil;
    }

    public VncVal peekGlobalDynamic(VncSymbol sym) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        return dv != null ? dv.peekVal() : Constants.Nil;
    }

    public void setGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar dv = this.findGlobalDynamicVar(sym);
        if (dv != null) {
            dv.setVal(val);
        } else {
            DynamicVar nv = new DynamicVar(sym, Constants.Nil);
            this.setGlobalVar(sym, nv);
            nv.pushVal(val);
        }
    }

    public void replaceGlobalDynamic(VncSymbol sym, VncVal val) {
        DynamicVar nv = new DynamicVar(sym, Constants.Nil);
        this.setGlobalVar(sym, nv);
        nv.pushVal(val);
    }

    public void removeGlobalSymbol(VncSymbol sym) {
        if (this.precompiledGlobalSymbols != null) {
            this.precompiledGlobalSymbols.remove(sym);
        }
        this.globalSymbols.remove(sym);
    }

    public void removeGlobalSymbolsByNS(VncSymbol ns) {
        String nsName = ns.getName();
        if (Namespaces.isCoreNS(nsName)) {
            return;
        }
        if (this.precompiledGlobalSymbols != null) {
            this.precompiledGlobalSymbols.keySet().stream().filter(s -> nsName.equals(s.getNamespace())).forEach(s -> this.precompiledGlobalSymbols.remove(s));
        }
        this.globalSymbols.keySet().stream().filter(s -> nsName.equals(s.getNamespace())).forEach(s -> this.globalSymbols.remove(s));
    }

    public Env getLevelEnv(int level) {
        Env env = this;
        if (env.level == level) {
            return env;
        }
        while (env.outer != null) {
            env = env.outer;
            if (env.level != level) continue;
            return env;
        }
        throw new VncException(String.format("No env level %d", level));
    }

    public int globalsCount() {
        if (this.precompiledGlobalSymbols != null) {
            return this.precompiledGlobalSymbols.size();
        }
        return this.globalSymbols.size();
    }

    public String toString() {
        return "level " + this.level + ":" + "\n   [local]\n" + this.toString(this.localSymbols, "      ") + "\n   [global]\n" + this.toString(this.getAllGlobalSymbols(), "      ");
    }

    public Env setStdoutPrintStream(PrintStream ps) {
        this.replaceGlobalDynamic(new VncSymbol("*out*"), VncJavaObject.from(ps != null ? ps : this.nullPrintStream(), PrintStream.class));
        return this;
    }

    public Env setStderrPrintStream(PrintStream ps) {
        this.replaceGlobalDynamic(new VncSymbol("*err*"), VncJavaObject.from(ps != null ? ps : this.nullPrintStream(), PrintStream.class));
        return this;
    }

    public Env setMacroexpandOnLoad(VncBoolean macroexpandOnLoad) {
        this.setGlobal(new Var(new VncSymbol("*macroexpand-on-load*"), macroexpandOnLoad, true));
        return this;
    }

    public Env setStdinReader(Reader rd) {
        if (rd == null) {
            this.replaceGlobalDynamic(new VncSymbol("*in*"), VncJavaObject.from(this.nullBufferedReader(), Reader.class));
        } else if (rd instanceof BufferedReader) {
            this.replaceGlobalDynamic(new VncSymbol("*in*"), VncJavaObject.from(rd, Reader.class));
        } else {
            this.replaceGlobalDynamic(new VncSymbol("*in*"), VncJavaObject.from(new BufferedReader(rd), Reader.class));
        }
        return this;
    }

    private String toString(Map<VncSymbol, Var> vars, String indent) {
        return vars.values().stream().sorted((a, b) -> a.getName().getName().compareTo(b.getName().getName())).map(v -> String.format("%s%s (:%s)", indent, v.getName().getName(), Types.getType(v.getVal()).getValue())).collect(Collectors.joining("\n"));
    }

    private DynamicVar findGlobalDynamicVar(VncSymbol sym) {
        if (sym.equals(Namespaces.NS_CURRENT_SYMBOL)) {
            throw new VncException(String.format("%s can not be used as a dynamic var", sym.getName()));
        }
        Var dv = this.getGlobalVar(sym);
        if (dv != null) {
            if (dv instanceof DynamicVar) {
                return (DynamicVar)dv;
            }
            WithCallStack cs = new WithCallStack(CallFrame.fromVal(sym));
            Throwable throwable = null;
            try {
                try {
                    throw new VncException(String.format("The var '%s' is not defined as dynamic", sym.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (cs != null) {
                    if (throwable != null) {
                        try {
                            cs.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        cs.close();
                    }
                }
                throw throwable3;
            }
        }
        return null;
    }

    private VncVal getOrElse(VncSymbol sym, VncVal defaultVal) {
        if (sym.hasNamespace()) {
            Var glob = this.getGlobalVar(sym);
            return glob == null ? defaultVal : glob.getVal();
        }
        VncVal local = this.findLocalVar(sym);
        if (local != null) {
            return local;
        }
        Var glob = this.getGlobalVar(sym);
        return glob == null ? defaultVal : glob.getVal();
    }

    private VncVal findLocalVar(VncSymbol sym) {
        Env env = this;
        do {
            Var v;
            if ((v = env.localSymbols.get(sym)) == null) continue;
            return v.getVal();
        } while ((env = env.outer) != null);
        return null;
    }

    private Var getGlobalVar(VncSymbol sym) {
        String name = sym.getName();
        if (name.equals("*ns*")) {
            return new Var(Namespaces.NS_CURRENT_SYMBOL, Namespaces.getCurrentNS());
        }
        if (ReservedSymbols.isSpecialForm(name)) {
            return null;
        }
        Var v = null;
        boolean qualified = sym.hasNamespace();
        if (qualified && name.startsWith("core/")) {
            v = this.getGlobalVarRaw(new VncSymbol(name.substring(5)));
        } else {
            VncSymbol ns;
            if (!qualified && !Namespaces.isCoreNS(ns = Namespaces.getCurrentNS())) {
                VncSymbol qualifiedKey = new VncSymbol(ns.getName(), name, Constants.Nil);
                v = this.getGlobalVarRaw(qualifiedKey);
            }
            if (v == null) {
                v = this.getGlobalVarRaw(sym);
            }
        }
        if (v == null) {
            return null;
        }
        this.rejectPrivateSymbolAccess(sym, v);
        return v;
    }

    private Var getGlobalVarRaw(VncSymbol sym) {
        Var v;
        if (this.precompiledGlobalSymbols != null && (v = this.precompiledGlobalSymbols.get(sym)) != null) {
            return v;
        }
        return this.globalSymbols.get(sym);
    }

    private void setGlobalVar(VncSymbol sym, Var value) {
        this.globalSymbols.put(sym, value);
    }

    private void setLocalVar(VncSymbol sym, Var value) {
        this.localSymbols.put(sym, value);
    }

    public Map<VncSymbol, Var> getAllGlobalSymbols() {
        HashMap<VncSymbol, Var> all = new HashMap<VncSymbol, Var>();
        if (this.precompiledGlobalSymbols != null) {
            all.putAll(this.precompiledGlobalSymbols);
        }
        all.putAll(this.globalSymbols);
        all.put(Namespaces.NS_CURRENT_SYMBOL, new Var(Namespaces.NS_CURRENT_SYMBOL, Namespaces.getCurrentNS()));
        return all;
    }

    public List<VncSymbol> getAllGlobalFunctionSymbols() {
        return this.getAllGlobalSymbols().entrySet().stream().filter(e -> ((Var)e.getValue()).getVal() instanceof VncFunction).map(e -> {
            VncFunction fn = (VncFunction)((Var)e.getValue()).getVal();
            return ((VncSymbol)e.getKey()).withMeta(VncHashMap.of(new VncKeyword("group"), new VncString(fn.getNamespace()), new VncKeyword("arglists"), fn.getArgLists(), new VncKeyword("doc"), fn.getDoc()));
        }).collect(Collectors.toList());
    }

    private PrintStream nullPrintStream() {
        return new PrintStream(new NullOutputStream(), true);
    }

    private BufferedReader nullBufferedReader() {
        return new BufferedReader(new InputStreamReader(new NullInputStream()));
    }

    private void rejectPrivateSymbolAccess(VncSymbol sym, Var envVar) {
        VncSymbol envSym = envVar.getName();
        if (envSym.isPrivate()) {
            String symNS;
            String currNS = Namespaces.getCurrentNS().getName();
            String string = symNS = envSym.hasNamespace() ? envSym.getNamespace() : "core";
            if (!currNS.equals(symNS)) {
                CallStack callStack = ThreadLocalMap.getCallStack();
                WithCallStack cs = new WithCallStack(CallFrame.fromVal("symbol", sym));
                Throwable throwable = null;
                try {
                    try {
                        throw new VncException(String.format("Illegal access of private symbol '%s/%s' accessed from namespace '%s'.\n%s", symNS, envSym.getSimpleName(), currNS, callStack.toString()));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (cs != null) {
                        if (throwable != null) {
                            try {
                                cs.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            cs.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }
}

