/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Namespace;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.concurrent.ThreadLocalMap;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Namespaces {
    public static final String NS_CURRENT_NAME = "*ns*";
    public static final VncSymbol NS_CURRENT_SYMBOL = new VncSymbol("*ns*");
    public static final VncSymbol NS_USER = new VncSymbol("user");
    public static final VncSymbol NS_CORE = new VncSymbol("core");
    public static final Set<String> SYSTEM_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("core", "cidr", "csv", "io", "str", "regex", "time")));
    public static final Set<String> RESERVED_NAMESPACES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("local", "core", "cidr", "csv", "io", "str", "regex", "time", "crypt", "json", "pdf", "xml", "bench", "test", "xchart", "kira", "parsatron", "tc", "ring", "http", "jackson", "math", "webdav", "maven")));

    public static VncSymbol lookupNS(VncVal ns, Env env) {
        if (ns == null || ns == Constants.Nil) {
            return NS_CORE;
        }
        if (Types.isVncSymbol(ns)) {
            VncSymbol ns_ = (VncSymbol)ns;
            if (Namespaces.isCurrentNSSymbol(ns_)) {
                VncVal val = env.getGlobalOrNil(ns_);
                return val == Constants.Nil ? NS_CORE : (VncSymbol)val;
            }
            return ns_;
        }
        throw new VncException(String.format("Cannot map type '%s' to VncSymbol to lookup namespace", Types.getType(ns)));
    }

    public static boolean isCoreNS(VncSymbol nsSym) {
        return NS_CORE.equals(nsSym);
    }

    public static boolean isCoreNS(String nsName) {
        return "core".equals(nsName);
    }

    public static boolean isCurrentNSSymbol(VncSymbol nsSym) {
        return NS_CURRENT_NAME.equals(nsSym.getName());
    }

    public static boolean isSystemNS(String nsName) {
        return SYSTEM_NAMESPACES.contains(nsName);
    }

    public static boolean isCurrentNSSymbol(String nsName) {
        return NS_CURRENT_NAME.equals(nsName);
    }

    public static VncSymbol getCurrentNS() {
        return ThreadLocalMap.getCurrNS().getNS();
    }

    public static Namespace getCurrentNamespace() {
        return ThreadLocalMap.getCurrNS();
    }

    public static void setCurrentNamespace(Namespace ns) {
        ThreadLocalMap.setCurrNS(ns);
    }
}

