/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.CIDR;
import java.net.InetAddress;
import java.util.Map;

public class CidrFunctions {
    public static VncFunction parse = new VncFunction("cidr/parse", (VncVal)VncFunction.meta().arglists("(cidr/parse cidr)").doc("Parses CIDR IP blocks to an IP address range. Supports both IPv4 and IPv6.").examples("(cidr/parse \"222.192.0.0/11\")", "(cidr/parse \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347/64\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cidr/parse", args, 1);
            VncVal cidr = args.first();
            if (Types.isVncJavaObject(cidr, CIDR.class)) {
                return cidr;
            }
            return new VncJavaObject(CIDR.parse(Coerce.toVncString(cidr).getValue()));
        }
    };
    public static VncFunction in_range_Q = new VncFunction("cidr/in-range?", (VncVal)VncFunction.meta().arglists("(cidr/in-range? ip cidr)").doc("Returns true if the ip adress is within the ip range of the cidr else false. ip may be a string or a :java.net.InetAddress, cidr may be a string or a CIDR Java object obtained from 'cidr/parse'.").examples("(cidr/in-range? \"222.220.0.0\" \"222.220.0.0/11\")", "(cidr/in-range? (cidr/inet-addr \"222.220.0.0\") \"222.220.0.0/11\")", "(cidr/in-range? \"222.220.0.0\" (cidr/parse \"222.220.0.0/11\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cidr/in-range?", args, 2);
            VncVal ip = args.first();
            VncVal cidr_ = args.second();
            if (Types.isVncString(ip)) {
                if (Types.isVncString(cidr_)) {
                    CIDR cidr = CIDR.parse(((VncString)cidr_).getValue());
                    return VncBoolean.of(cidr.isInRange(((VncString)ip).getValue()));
                }
                if (Types.isVncJavaObject(cidr_, CIDR.class)) {
                    CIDR cidr = (CIDR)((VncJavaObject)cidr_).getDelegate();
                    return VncBoolean.of(cidr.isInRange(((VncString)ip).getValue()));
                }
                throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(cidr_)));
            }
            if (Types.isVncJavaObject(ip, InetAddress.class)) {
                if (Types.isVncString(cidr_)) {
                    InetAddress inet = (InetAddress)((VncJavaObject)ip).getDelegate();
                    CIDR cidr = CIDR.parse(((VncString)cidr_).getValue());
                    return VncBoolean.of(cidr.isInRange(inet));
                }
                if (Types.isVncJavaObject(cidr_, CIDR.class)) {
                    InetAddress inet = (InetAddress)((VncJavaObject)ip).getDelegate();
                    CIDR cidr = (CIDR)((VncJavaObject)cidr_).getDelegate();
                    return VncBoolean.of(cidr.isInRange(inet));
                }
                throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(cidr_)));
            }
            throw new VncException(String.format("Invalid argument type %s while calling function 'cidr/in-range?'", Types.getType(ip)));
        }
    };
    public static VncFunction inet_addr = new VncFunction("cidr/inet-addr", (VncVal)VncFunction.meta().arglists("(cidr/inet-addr addr)").doc("Converts an stringified IPv4 or IPv6 to a Java InetAddress.").examples("(cidr/inet-addr \"222.192.0.0\")", "(cidr/inet-addr \"2001:0db8:85a3:08d3:1319:8a2e:0370:7347\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("cidr/inet-addr", args, 1);
            String ip = Coerce.toVncString(args.first()).getValue();
            try {
                return new VncJavaObject(InetAddress.getByName(ip));
            }
            catch (Exception ex) {
                throw new VncException("Not an IP address: '" + ip + "'");
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(parse).add(in_range_Q).add(inet_addr).toMap();
}

