/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.javainterop;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ValueException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JavaImports
implements Serializable {
    private static final long serialVersionUID = 1784667662341909868L;
    private final Map<String, String> imports = new ConcurrentHashMap<String, String>();

    public JavaImports() {
        this.add(Throwable.class.getName());
        this.add(Exception.class.getName());
        this.add(RuntimeException.class.getName());
        this.add(NullPointerException.class.getName());
        this.add(IllegalArgumentException.class.getName());
        this.add(VncException.class.getName());
        this.add(ValueException.class.getName());
    }

    public String lookupClassName(String simpleClassName) {
        return this.imports.get(simpleClassName);
    }

    public String resolveClassName(String className) {
        String cn = this.imports.get(className);
        return cn == null ? className : cn;
    }

    public void add(String clazz) {
        this.validateNoDuplicate(clazz);
        this.imports.put(this.getSimpleClassname(clazz), clazz);
    }

    public void clear() {
        this.imports.clear();
    }

    public List<String> list() {
        ArrayList<String> items = new ArrayList<String>(this.imports.values());
        Collections.sort(items);
        return items;
    }

    private String getSimpleClassname(String clazz) {
        int pos = clazz.lastIndexOf(46);
        return pos < 0 ? clazz : clazz.substring(pos + 1);
    }

    private void validateNoDuplicate(String clazz) {
        String cn = this.getSimpleClassname(clazz);
        String c = this.imports.get(cn);
        if (c != null && !c.equals(clazz)) {
            throw new VncException(String.format("Failed to import class '%s' as '%s'. There is a '%s' already imported as '%s'.", clazz, cn, c, cn));
        }
    }
}

