/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.IDeref;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.util.Watchable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class VncAtom
extends VncVal
implements IDeref {
    public static final VncKeyword TYPE = new VncKeyword(":core/atom");
    private static final long serialVersionUID = -1848883965231344442L;
    private final AtomicReference<VncVal> state = new AtomicReference();
    private final Watchable watchable = new Watchable();

    public VncAtom(VncVal value) {
        super(Constants.Nil);
        this.state.set(value);
    }

    public VncAtom(VncVal value, VncVal meta) {
        super(meta);
        this.state.set(value);
    }

    @Override
    public VncAtom withMeta(VncVal meta) {
        return new VncAtom(this.state.get(), meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(this.getSupertype());
    }

    public VncVal reset(VncVal newVal) {
        this.state.set(newVal);
        return newVal;
    }

    @Override
    public VncVal deref() {
        return this.state.get();
    }

    public VncVal swap(VncFunction fn, VncList args) {
        VncList new_args;
        VncVal newVal;
        VncVal oldVal;
        do {
            oldVal = this.deref();
        } while (!this.state.compareAndSet(oldVal, newVal = fn.apply(new_args = VncList.of(oldVal).addAllAtEnd(args))));
        this.watchable.notifyWatches(this, oldVal, newVal);
        return this.state.get();
    }

    public VncVal compare_and_set(VncVal expectValue, VncVal newVal) {
        VncVal oldVal = this.deref();
        if (oldVal.equals(expectValue)) {
            boolean successful = this.state.compareAndSet(oldVal, newVal);
            if (successful) {
                this.watchable.notifyWatches(this, oldVal, newVal);
            }
            return VncBoolean.of(successful);
        }
        return VncBoolean.False;
    }

    public void addWatch(VncKeyword name, VncFunction fn) {
        this.watchable.addWatch(name, fn);
    }

    public void removeWatch(VncKeyword name) {
        this.watchable.removeWatch(name);
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.ATOM;
    }

    @Override
    public Object convertToJavaObject() {
        return null;
    }

    public String toString() {
        return "(atom " + Printer.pr_str(this.state.get(), true) + ")";
    }

    @Override
    public String toString(boolean print_readably) {
        return "(atom " + Printer.pr_str(this.state.get(), print_readably) + ")";
    }
}

