/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncMapEntry;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.repackage.io.vavr.collection.HashMap;
import org.repackage.io.vavr.collection.Map;
import org.repackage.io.vavr.collection.TreeMap;

public class VncHashMap
extends VncMap {
    public static final VncKeyword TYPE = new VncKeyword(":core/hash-map");
    private static final long serialVersionUID = -1848883965231344442L;
    private final HashMap<VncVal, VncVal> value;

    public VncHashMap() {
        this((Map<VncVal, VncVal>)null, null);
    }

    public VncHashMap(VncVal meta) {
        this((Map<VncVal, VncVal>)null, meta);
    }

    public VncHashMap(Map<VncVal, VncVal> val) {
        this(val, null);
    }

    public VncHashMap(java.util.Map<? extends VncVal, ? extends VncVal> vals) {
        this(vals, null);
    }

    public VncHashMap(java.util.Map<? extends VncVal, ? extends VncVal> vals, VncVal meta) {
        this(vals == null ? null : HashMap.ofAll(vals), meta);
    }

    public VncHashMap(Map<VncVal, VncVal> val, VncVal meta) {
        super(meta == null ? Constants.Nil : meta);
        this.value = val == null ? HashMap.empty() : (val instanceof TreeMap ? (HashMap)val : HashMap.ofEntries(val));
    }

    public static VncHashMap ofAll(VncSequence lst) {
        if (lst != null && lst.size() % 2 != 0) {
            throw new VncException(String.format("hash-map: create requires an even number of list items. Got %d items. %s", lst.size(), ErrorMessage.buildErrLocation(lst)));
        }
        return new VncHashMap().assoc(lst);
    }

    public static VncHashMap ofAll(VncVector vec) {
        if (vec != null && vec.size() % 2 != 0) {
            throw new VncException(String.format("hash-map: create requires an even number of vector items. Got %d items. %s", vec.size(), ErrorMessage.buildErrLocation(vec)));
        }
        return new VncHashMap().assoc(vec);
    }

    public static VncHashMap of(VncVal ... mvs) {
        if (mvs != null && mvs.length % 2 != 0) {
            throw new VncException(String.format("hash-map: create requires an even number of items. Got %d items. %s", mvs.length, ErrorMessage.buildErrLocation(mvs[0])));
        }
        return new VncHashMap().assoc(mvs);
    }

    @Override
    public VncHashMap emptyWithMeta() {
        return new VncHashMap(this.getMeta());
    }

    @Override
    public VncHashMap withValues(java.util.Map<VncVal, VncVal> replaceVals) {
        return new VncHashMap(replaceVals, this.getMeta());
    }

    @Override
    public VncHashMap withValues(java.util.Map<VncVal, VncVal> replaceVals, VncVal meta) {
        return new VncHashMap(replaceVals, meta);
    }

    @Override
    public VncHashMap withMeta(VncVal meta) {
        return new VncHashMap(this.value, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncMap.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncMap.TYPE, VncCollection.TYPE, VncVal.TYPE);
    }

    @Override
    public java.util.Map<VncVal, VncVal> getMap() {
        return Collections.unmodifiableMap(this.value.toJavaMap());
    }

    @Override
    public VncVal get(VncVal key) {
        return this.value.get(key).getOrElse(Constants.Nil);
    }

    @Override
    public VncVal containsKey(VncVal key) {
        return VncBoolean.of(this.value.containsKey(key));
    }

    @Override
    public VncList keys() {
        return VncList.ofList(new ArrayList(this.value.keySet().toJavaList()));
    }

    @Override
    public List<VncMapEntry> entries() {
        return Collections.unmodifiableList(this.value.map(e -> new VncMapEntry((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()));
    }

    @Override
    public VncHashMap putAll(VncMap map) {
        return new VncHashMap(this.value.merge(HashMap.ofAll(map.getMap())), this.getMeta());
    }

    @Override
    public VncHashMap assoc(VncVal ... mvs) {
        if (mvs.length % 2 != 0) {
            throw new VncException(String.format("hash-map: assoc requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs[0])));
        }
        Map<VncVal, VncVal> tmp = this.value;
        for (int i = 0; i < mvs.length; i += 2) {
            tmp = tmp.put((Object)mvs[i], (Object)mvs[i + 1]);
        }
        return new VncHashMap(tmp, this.getMeta());
    }

    @Override
    public VncHashMap assoc(VncSequence mvs) {
        if (mvs.size() % 2 != 0) {
            throw new VncException(String.format("hash-map: assoc requires an even number of items. %s", ErrorMessage.buildErrLocation(mvs)));
        }
        Map<VncVal, VncVal> tmp = this.value;
        for (int i = 0; i < mvs.getList().size(); i += 2) {
            tmp = tmp.put((Object)mvs.nth(i), (Object)mvs.nth(i + 1));
        }
        return new VncHashMap(tmp, this.getMeta());
    }

    @Override
    public VncHashMap dissoc(VncVal ... keys) {
        return new VncHashMap(this.value.removeAll(Arrays.asList(keys)), this.getMeta());
    }

    @Override
    public VncHashMap dissoc(VncSequence keys) {
        return new VncHashMap(this.value.removeAll(keys.getList()), this.getMeta());
    }

    @Override
    public VncList toVncList() {
        return new VncList(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return new VncVector(this.value.map(e -> VncVector.of((VncVal)e._1, (VncVal)e._2)).collect(Collectors.toList()), this.getMeta());
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.HASHMAP;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncHashMap(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(this.size()));
            if (c != 0) {
                return c;
            }
            return this.equals(o) ? 0 : -1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncHashMap other = (VncHashMap)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean print_readably) {
        List<VncVal> list = this.value.map(e -> VncList.of((VncVal)e._1, (VncVal)e._2).getList()).collect(Collectors.toList()).stream().flatMap(l -> l.stream()).collect(Collectors.toList());
        return "{" + Printer.join(list, " ", print_readably) + "}";
    }

    public static class Builder {
        private java.util.HashMap<VncVal, VncVal> map = new java.util.HashMap();

        public Builder add(VncFunction fn) {
            this.map.put(new VncSymbol(fn.getQualifiedName()), fn);
            return this;
        }

        public Builder put(String key, VncVal val) {
            this.map.put(new VncSymbol(key), val);
            return this;
        }

        public Builder put(VncVal key, VncVal val) {
            this.map.put(key, val);
            return this;
        }

        public VncHashMap build() {
            return new VncHashMap(this.map);
        }

        public java.util.Map<VncVal, VncVal> toMap() {
            return this.map;
        }
    }
}

