/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.Printer;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.collections.VncTinyList;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class VncTinyVector
extends VncVector {
    public static final VncKeyword TYPE = new VncKeyword(":core/vector");
    public static final VncTinyVector EMPTY = new VncTinyVector();
    public static final int MAX_ELEMENTS = 4;
    private static final long serialVersionUID = -1848883965231344442L;
    private final int len;
    private final VncVal first;
    private final VncVal second;
    private final VncVal third;
    private final VncVal fourth;

    public VncTinyVector() {
        this(null);
    }

    public VncTinyVector(VncVal meta) {
        super(meta);
        this.len = 0;
        this.first = Constants.Nil;
        this.second = Constants.Nil;
        this.third = Constants.Nil;
        this.fourth = Constants.Nil;
    }

    public VncTinyVector(VncVal first, VncVal meta) {
        super(meta);
        this.len = 1;
        this.first = first;
        this.second = Constants.Nil;
        this.third = Constants.Nil;
        this.fourth = Constants.Nil;
    }

    public VncTinyVector(VncVal first, VncVal second, VncVal meta) {
        super(meta);
        this.len = 2;
        this.first = first;
        this.second = second;
        this.third = Constants.Nil;
        this.fourth = Constants.Nil;
    }

    public VncTinyVector(VncVal first, VncVal second, VncVal third, VncVal meta) {
        super(meta);
        this.len = 3;
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = Constants.Nil;
    }

    public VncTinyVector(VncVal first, VncVal second, VncVal third, VncVal fourth, VncVal meta) {
        super(meta);
        this.len = 4;
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public VncTinyVector(int len, VncVal first, VncVal second, VncVal third, VncVal fourth, VncVal meta) {
        super(meta);
        this.len = len;
        this.first = first;
        this.second = second;
        this.third = third;
        this.fourth = fourth;
    }

    public static VncVector range(int from, int toExclusive) {
        ArrayList<VncLong> list = new ArrayList<VncLong>();
        for (int ii = from; ii < toExclusive; ++ii) {
            list.add(new VncLong(ii));
        }
        return VncVector.ofList(list, null);
    }

    @Override
    public VncVal apply(VncList args) {
        FunctionsUtil.assertArity("nth", args, 1);
        return this.nth(Coerce.toVncLong(args.first()).getValue().intValue());
    }

    @Override
    public VncVector emptyWithMeta() {
        return new VncTinyVector(this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals) {
        return VncVector.ofList(replaceVals, this.getMeta());
    }

    @Override
    public VncVector withValues(List<? extends VncVal> replaceVals, VncVal meta) {
        return VncVector.ofList(replaceVals, meta);
    }

    @Override
    public VncVector withMeta(VncVal meta) {
        return new VncTinyVector(this.len, this.first, this.second, this.third, this.fourth, meta);
    }

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncSequence.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncSequence.TYPE, VncVal.TYPE);
    }

    @Override
    public void forEach(Consumer<? super VncVal> action) {
        if (this.len > 0) {
            action.accept(this.first);
            if (this.len > 1) {
                action.accept(this.second);
                if (this.len > 2) {
                    action.accept(this.third);
                    if (this.len > 3) {
                        action.accept(this.fourth);
                    }
                }
            }
        }
    }

    @Override
    public List<VncVal> getList() {
        ArrayList<VncVal> list = new ArrayList<VncVal>(this.len);
        if (this.len > 0) {
            list.add(this.first);
            if (this.len > 1) {
                list.add(this.second);
                if (this.len > 2) {
                    list.add(this.third);
                    if (this.len > 3) {
                        list.add(this.fourth);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    @Override
    public VncVal nth(int idx) {
        if (idx < 0 || idx >= this.len) {
            throw new VncException(String.format("nth: index %d out of range for a vector of size %d. %s", idx, this.len, this.isEmpty() ? "" : ErrorMessage.buildErrLocation(this.first)));
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVal nthOrDefault(int idx, VncVal defaultVal) {
        if (idx < 0 || idx >= this.len) {
            return defaultVal;
        }
        switch (idx) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
            case 3: {
                return this.fourth;
            }
        }
        return defaultVal;
    }

    @Override
    public VncVal first() {
        return this.first;
    }

    @Override
    public VncVal second() {
        return this.second;
    }

    @Override
    public VncVal third() {
        return this.third;
    }

    @Override
    public VncVal fourth() {
        return this.fourth;
    }

    @Override
    public VncVal last() {
        switch (this.len) {
            case 0: {
                return Constants.Nil;
            }
            case 1: {
                return this.first;
            }
            case 2: {
                return this.second;
            }
            case 3: {
                return this.third;
            }
            case 4: {
                return this.fourth;
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector rest() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyVector(this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.second, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.second, this.third, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(this.second, this.third, this.fourth, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector butlast() {
        switch (this.len) {
            case 0: {
                return this;
            }
            case 1: {
                return new VncTinyVector(this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.first, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.first, this.second, this.getMeta());
            }
            case 4: {
                return new VncTinyVector(this.first, this.second, this.third, this.getMeta());
            }
        }
        throw new IllegalStateException("Length out of range");
    }

    @Override
    public VncVector slice(int start, int end) {
        return start == 0 && end >= this.len ? this : VncVector.ofList(this.getList().subList(start, end), this.getMeta());
    }

    @Override
    public VncVector slice(int start) {
        if (start == 0) {
            return this;
        }
        if (start == 1) {
            return this.rest();
        }
        return VncVector.ofList(this.getList().subList(start, this.len), this.getMeta());
    }

    @Override
    public VncVector toVncVector() {
        return this;
    }

    @Override
    public VncList toVncList() {
        switch (this.len) {
            case 0: {
                return new VncTinyList(this.getMeta());
            }
            case 1: {
                return VncTinyList.of(this.first).withMeta(this.getMeta());
            }
            case 2: {
                return VncTinyList.of(this.first, this.second).withMeta(this.getMeta());
            }
            case 3: {
                return VncTinyList.of(this.first, this.second, this.third).withMeta(this.getMeta());
            }
            case 4: {
                return VncTinyList.of(this.first, this.second, this.third, this.fourth).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector addAtStart(VncVal val) {
        switch (this.len) {
            case 0: {
                return new VncTinyVector(val, this.getMeta());
            }
            case 1: {
                return new VncTinyVector(val, this.first, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(val, this.first, this.second, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(val, this.first, this.second, this.third, this.getMeta());
            }
            case 4: {
                return VncVector.of(val, this.first, this.second, this.third, this.fourth).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector addAllAtStart(VncSequence list) {
        ArrayList<VncVal> vals = new ArrayList<VncVal>(list.getList());
        Collections.reverse(vals);
        vals.addAll(this.getList());
        return VncVector.ofList(vals, this.getMeta());
    }

    @Override
    public VncVector addAtEnd(VncVal val) {
        switch (this.len) {
            case 0: {
                return new VncTinyVector(val, this.getMeta());
            }
            case 1: {
                return new VncTinyVector(this.first, val, this.getMeta());
            }
            case 2: {
                return new VncTinyVector(this.first, this.second, val, this.getMeta());
            }
            case 3: {
                return new VncTinyVector(this.first, this.second, this.third, val, this.getMeta()).withMeta(this.getMeta());
            }
            case 4: {
                return VncVector.of(this.first, this.second, this.third, this.fourth, val).withMeta(this.getMeta());
            }
        }
        throw new IllegalStateException("Vector length out of range");
    }

    @Override
    public VncVector addAllAtEnd(VncSequence list) {
        List<VncVal> vals = this.getList();
        vals.addAll(list.getList());
        return VncVector.ofList(vals, this.getMeta());
    }

    @Override
    public VncVector setAt(int idx, VncVal val) {
        List<VncVal> vals = this.getList();
        vals.set(idx, val);
        return VncVector.ofList(vals, this.getMeta());
    }

    @Override
    public VncVector removeAt(int idx) {
        if (idx == 0) {
            return this.rest();
        }
        if (idx == this.len - 1) {
            return this.butlast();
        }
        List<VncVal> vals = this.getList();
        vals.remove(idx);
        return VncVector.ofList(vals, this.getMeta());
    }

    @Override
    public Object convertToJavaObject() {
        ArrayList<Object> list = new ArrayList<Object>(this.len);
        switch (this.len) {
            case 0: {
                break;
            }
            case 1: {
                list.add(this.first.convertToJavaObject());
                break;
            }
            case 2: {
                list.add(this.first.convertToJavaObject());
                list.add(this.second.convertToJavaObject());
                break;
            }
            case 3: {
                list.add(this.first.convertToJavaObject());
                list.add(this.second.convertToJavaObject());
                list.add(this.third.convertToJavaObject());
                break;
            }
            case 4: {
                list.add(this.first.convertToJavaObject());
                list.add(this.second.convertToJavaObject());
                list.add(this.third.convertToJavaObject());
                list.add(this.fourth.convertToJavaObject());
                break;
            }
            default: {
                throw new IllegalStateException("Vector length out of range");
            }
        }
        return list;
    }

    @Override
    public int compareTo(VncVal o) {
        if (o == Constants.Nil) {
            return 1;
        }
        if (Types.isVncVector(o)) {
            Integer sizeOther;
            Integer sizeThis = this.size();
            int c = sizeThis.compareTo(sizeOther = Integer.valueOf(((VncVector)o).size()));
            if (c != 0) {
                return c;
            }
            for (int ii = 0; ii < sizeThis; ++ii) {
                c = this.nth(ii).compareTo(((VncVector)o).nth(ii));
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.len;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        result = 31 * result + (this.third == null ? 0 : this.third.hashCode());
        result = 31 * result + (this.fourth == null ? 0 : this.fourth.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VncTinyVector other = (VncTinyVector)obj;
        if (this.len != other.len) {
            return false;
        }
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        if (this.second == null ? other.second != null : !this.second.equals(other.second)) {
            return false;
        }
        if (this.third == null ? other.third != null : !this.third.equals(other.third)) {
            return false;
        }
        return !(this.fourth == null ? other.fourth != null : !this.fourth.equals(other.fourth));
    }

    @Override
    public String toString() {
        return "[" + Printer.join(this.getList(), " ", true) + "]";
    }

    @Override
    public String toString(boolean print_readably) {
        return "[" + Printer.join(this.getList(), " ", print_readably) + "]";
    }
}

