/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.util.CallFrame;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CallStack {
    private final ArrayDeque<CallFrame> queue;

    public CallStack() {
        this.queue = new ArrayDeque(32);
    }

    private CallStack(ArrayDeque<CallFrame> queue) {
        this.queue = queue;
    }

    public void push(CallFrame frame) {
        this.queue.push(frame);
    }

    public CallFrame pop() {
        return this.isEmpty() ? null : this.queue.pop();
    }

    public CallFrame peek() {
        return this.queue.peek();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public void clear() {
        this.queue.clear();
    }

    public CallStack copy() {
        return new CallStack((ArrayDeque<CallFrame>)this.queue.clone());
    }

    public List<String> toList() {
        String[] stack = new String[this.queue.size()];
        int ii = 0;
        for (CallFrame f : this.queue.toArray(new CallFrame[this.queue.size()])) {
            stack[ii++] = f.toString();
        }
        return Arrays.asList(stack);
    }

    public List<CallFrame> callstack() {
        return Arrays.asList(this.queue.toArray(new CallFrame[this.queue.size()]));
    }

    public String toString() {
        return this.toList().stream().collect(Collectors.joining("\n"));
    }
}

