/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;

public class LineNumberingPushbackReader
extends PushbackReader {
    private static final int LF = 10;
    private int columnNumber = 1;
    private int pos = 0;

    public LineNumberingPushbackReader(Reader r) {
        super(new LineNumberReader(r));
    }

    public LineNumberingPushbackReader(Reader r, int bufSize) {
        super(new LineNumberReader(r), bufSize);
    }

    public int getLineNumber() {
        return ((LineNumberReader)this.in).getLineNumber() + 1;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getPos() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch == -1) {
            this.columnNumber = 1;
        } else if (ch == 10) {
            this.columnNumber = 1;
            ++this.pos;
        } else {
            ++this.columnNumber;
            ++this.pos;
        }
        return ch;
    }

    @Override
    public void unread(int ch) throws IOException {
        if (ch == 10) {
            throw new IOException("unreading a linefeed is not supported");
        }
        if (ch != -1) {
            super.unread(ch);
            --this.pos;
            --this.columnNumber;
        }
    }
}

