/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.crypt;

import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.crypt.EncryptionException;
import java.util.Base64;
import javax.crypto.Cipher;

public class CipherSuite {
    private final Cipher cipherEncrypt;
    private final Cipher cipherDecrypt;
    private final String cipherPrefix;
    private final boolean urlSafe;

    public CipherSuite(Cipher encrypt, Cipher decrypt, String cipherPrefix, boolean urlSafe) {
        if (encrypt == null) {
            throw new IllegalArgumentException("An encrypt cipher must not be null");
        }
        if (decrypt == null) {
            throw new IllegalArgumentException("A decrypt cipher must not be null");
        }
        if (cipherPrefix == null || cipherPrefix.length() == 0) {
            throw new IllegalArgumentException("A cipherPrefix must not be null or empty");
        }
        this.cipherEncrypt = encrypt;
        this.cipherDecrypt = decrypt;
        this.cipherPrefix = cipherPrefix;
        this.urlSafe = urlSafe;
    }

    public synchronized String encrypt(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() == 0) {
            return "";
        }
        try {
            byte[] utf8 = message.getBytes("UTF-8");
            byte[] enc = this.cipherEncrypt.doFinal(utf8);
            if (this.urlSafe) {
                return Base64.getEncoder().withoutPadding().encodeToString(enc).replace('+', '-').replace('/', '_');
            }
            return Base64.getEncoder().encodeToString(enc);
        }
        catch (Exception ex) {
            throw new EncryptionException("Failed to encrypt message.", ex);
        }
    }

    public synchronized byte[] encrypt(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return data;
        }
        try {
            return this.cipherEncrypt.doFinal(data);
        }
        catch (Exception ex) {
            throw new EncryptionException("Failed to encrypt data.", ex);
        }
    }

    public synchronized String decrypt(String message) {
        if (message == null) {
            return null;
        }
        if (message.length() == 0) {
            return "";
        }
        try {
            String m = this.urlSafe ? message.replace('-', '+').replace('_', '/') : message;
            byte[] dec = Base64.getDecoder().decode(m.getBytes("UTF-8"));
            return new String(this.cipherDecrypt.doFinal(dec), "UTF-8");
        }
        catch (Exception ex) {
            throw new EncryptionException("Failed to decrypt message.", ex);
        }
    }

    public synchronized byte[] decrypt(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return data;
        }
        try {
            return this.cipherDecrypt.doFinal(data);
        }
        catch (Exception ex) {
            throw new EncryptionException("Failed to decrypt data.", ex);
        }
    }

    public String getCipherAlgorithm() {
        return this.cipherEncrypt.getAlgorithm();
    }

    public String getCipherPrefix() {
        return this.cipherPrefix;
    }

    public boolean isEncrypted(String text) {
        return StringUtil.trimToEmpty(text).startsWith(this.getCipherPrefix());
    }

    public String prefix(String text) {
        return text == null ? null : this.getCipherPrefix() + text;
    }

    public String deprefix(String text) {
        return this.isEncrypted(text) ? text.substring(this.getCipherPrefix().length()) : text;
    }
}

