/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.json;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncAtom;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncConstant;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncJavaList;
import com.github.jlangch.venice.impl.types.collections.VncJavaMap;
import com.github.jlangch.venice.impl.types.collections.VncJavaSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncSet;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.nanojson.JsonAppendableWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VncJsonWriter {
    private static final DateTimeFormatter FMT_LOCAL_DATE = DateTimeFormatter.ISO_LOCAL_DATE;
    private static final DateTimeFormatter FMT_LOCAL_DATE_TIME = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private static final DateTimeFormatter FMT_DATE_TIME = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private final JsonAppendableWriter writer;
    private final boolean decimalAsDouble;

    public VncJsonWriter(JsonAppendableWriter writer, boolean decimalAsDouble) {
        this.writer = writer;
        this.decimalAsDouble = decimalAsDouble;
    }

    public VncJsonWriter write(VncVal val) {
        this.write(null, val);
        return this;
    }

    public void done() {
        this.writer.done();
    }

    private void write(String key, VncVal val) {
        if (val == null) {
            this.write_null(key);
        } else if (Types.isVncConstant(val)) {
            this.write_VncConstant(key, (VncConstant)val);
        } else if (Types.isVncBoolean(val)) {
            this.write_VncBoolean(key, (VncBoolean)val);
        } else if (Types.isVncString(val)) {
            this.write_VncString(key, (VncString)val);
        } else if (Types.isVncChar(val)) {
            this.write_VncChar(key, (VncChar)val);
        } else if (Types.isVncInteger(val)) {
            this.write_VncInteger(key, (VncInteger)val);
        } else if (Types.isVncLong(val)) {
            this.write_VncLong(key, (VncLong)val);
        } else if (Types.isVncDouble(val)) {
            this.write_VncDouble(key, (VncDouble)val);
        } else if (Types.isVncBigDecimal(val)) {
            this.write_VncBigDecimal(key, (VncBigDecimal)val);
        } else if (Types.isVncKeyword(val)) {
            this.write_VncKeyword(key, (VncKeyword)val);
        } else if (Types.isVncSymbol(val)) {
            this.write_VncSymbol(key, (VncSymbol)val);
        } else if (Types.isVncList(val)) {
            this.write_VncList(key, (VncList)val);
        } else if (Types.isVncVector(val)) {
            this.write_VncVector(key, (VncVector)val);
        } else if (Types.isVncJavaList(val)) {
            this.write_VncJavaList(key, (VncJavaList)val);
        } else if (Types.isVncJavaObject(val)) {
            this.write_VncJavaObject(key, (VncJavaObject)val);
        } else if (Types.isVncJavaMap(val)) {
            this.write_VncJavaMap(key, (VncJavaMap)val);
        } else if (Types.isVncMap(val)) {
            this.write_VncMap(key, (VncMap)val);
        } else if (Types.isVncSet(val)) {
            this.write_VncSet(key, (VncSet)val);
        } else if (Types.isVncJavaSet(val)) {
            this.write_VncJavaSet(key, (VncJavaSet)val);
        } else if (Types.isVncByteBuffer(val)) {
            this.write_VncByteBuffer(key, (VncByteBuffer)val);
        } else if (Types.isVncAtom(val)) {
            this.write(key, ((VncAtom)val).deref());
        } else {
            throw new VncException(String.format("Json serialization error: the type %s can not be serialized", Types.getType(val)));
        }
    }

    private void write_null(String key) {
        if (key == null) {
            this.writer.nul();
        } else {
            this.writer.nul(key);
        }
    }

    private void write_VncConstant(String key, VncConstant val) {
        if (key == null) {
            if (val == Constants.Nil) {
                this.writer.nul();
            }
        } else if (val == Constants.Nil) {
            this.writer.nul(key);
        }
    }

    private void write_VncBoolean(String key, VncBoolean val) {
        if (key == null) {
            if (VncBoolean.isTrue(val)) {
                this.writer.value(true);
            } else if (VncBoolean.isFalse(val)) {
                this.writer.value(false);
            }
        } else if (VncBoolean.isTrue(val)) {
            this.writer.value(key, true);
        } else if (VncBoolean.isFalse(val)) {
            this.writer.value(key, false);
        }
    }

    private void write_VncString(String key, VncString val) {
        String v = val.getValue();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncChar(String key, VncChar val) {
        String v = val.getValue().toString();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncInteger(String key, VncInteger val) {
        int v = val.getValue();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncLong(String key, VncLong val) {
        long v = val.getValue();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncDouble(String key, VncDouble val) {
        double v = val.getValue();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncBigDecimal(String key, VncBigDecimal val) {
        if (this.decimalAsDouble) {
            double v = val.getValue().doubleValue();
            if (key == null) {
                this.writer.value(v);
            } else {
                this.writer.value(key, v);
            }
        } else {
            String v = val.getValue().toString();
            if (key == null) {
                this.writer.value(v);
            } else {
                this.writer.value(key, v);
            }
        }
    }

    private void write_VncKeyword(String key, VncKeyword val) {
        String v = val.getValue();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncSymbol(String key, VncSymbol val) {
        String v = val.getName();
        if (key == null) {
            this.writer.value(v);
        } else {
            this.writer.value(key, v);
        }
    }

    private void write_VncList(String key, VncList val) {
        this.array(key);
        val.forEach(v -> this.write(null, (VncVal)v));
        this.end();
    }

    private void write_VncVector(String key, VncVector val) {
        this.array(key);
        val.forEach(v -> this.write(null, (VncVal)v));
        this.end();
    }

    private void write_VncJavaList(String key, VncJavaList val) {
        this.writer.array(key, (Collection)((List)val.getDelegate()));
    }

    private void write_VncSet(String key, VncSet val) {
        this.array(key);
        val.getSet().forEach(v -> this.write(null, (VncVal)v));
        this.end();
    }

    private void write_VncJavaSet(String key, VncJavaSet val) {
        this.writer.array(key, (Collection)((Set)val.getDelegate()));
    }

    private void write_VncJavaMap(String key, VncJavaMap val) {
        if (key == null) {
            this.writer.object((Map)val.getDelegate());
        } else {
            this.writer.object(key, (Map)val.getDelegate());
        }
    }

    private void write_VncMap(String key, VncMap val) {
        this.object(key);
        Map<VncVal, VncVal> map = val.getMap();
        for (Map.Entry<VncVal, VncVal> e : map.entrySet()) {
            VncVal k = e.getKey();
            VncVal v = e.getValue();
            if (Types.isVncString(k)) {
                this.write(((VncString)k).getValue(), v);
                continue;
            }
            if (Types.isVncKeyword(k)) {
                this.write(((VncKeyword)k).getValue(), v);
                continue;
            }
            if (Types.isVncLong(k)) {
                this.write(((VncLong)k).getValue().toString(), v);
                continue;
            }
            throw new VncException(String.format("Json serialization error: the map key type %s can not be serialized", Types.getType(val)));
        }
        this.end();
    }

    private void write_VncJavaObject(String key, VncJavaObject val) {
        Object delegate = val.getDelegate();
        if (delegate instanceof LocalDate) {
            String formatted = ((LocalDate)delegate).format(FMT_LOCAL_DATE);
            if (key == null) {
                this.writer.value(formatted);
            } else {
                this.writer.value(key, formatted);
            }
        } else if (delegate instanceof LocalDateTime) {
            String formatted = ((LocalDateTime)delegate).format(FMT_LOCAL_DATE_TIME);
            if (key == null) {
                this.writer.value(formatted);
            } else {
                this.writer.value(key, formatted);
            }
        } else if (delegate instanceof ZonedDateTime) {
            String formatted = ((ZonedDateTime)delegate).format(FMT_DATE_TIME);
            if (key == null) {
                this.writer.value(formatted);
            } else {
                this.writer.value(key, formatted);
            }
        } else {
            throw new VncException(String.format("Json serialization error: the type %s can not be serialized", Types.getType(val)));
        }
    }

    private void write_VncByteBuffer(String key, VncByteBuffer val) {
        String encoded = Base64.getEncoder().encodeToString(val.getBytes());
        if (key == null) {
            this.writer.value(encoded);
        } else {
            this.writer.value(key, encoded);
        }
    }

    private void array(String key) {
        if (key == null) {
            this.writer.array();
        } else {
            this.writer.array(key);
        }
    }

    private void object(String key) {
        if (key == null) {
            this.writer.object();
        } else {
            this.writer.object(key);
        }
    }

    private void end() {
        this.writer.end();
    }
}

