/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.javainterop;

import com.github.jlangch.venice.Venice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SandboxRules {
    private static String BASE = Venice.class.getPackage().getName();
    private static final List<String> SYSTEM_CLASS_RULES = Arrays.asList("class:" + BASE + ".*Exception:*", "class:" + BASE + ".*Error:*", "class:" + BASE + ".util.CapturingPrintStream:*", "class:" + BASE + ".util.CallbackPrintStream:*", "class:" + BASE + ".util.*XMLHandler*:*", "class:" + BASE + ".servlet.*:*", "class:" + BASE + ".impl.util.crypt.*:*", "class:" + BASE + ".impl.javainterop.DynamicInvocationHandler*:*", "class:" + BASE + ".impl.VeniceInterpreter$1", "class:" + BASE + ".impl.ValueException:*", "class:" + BASE + ".impl.types.collections.VncVector", "class:" + BASE + ".impl.types.concurrent.Delay:*", "class:" + BASE + ".impl.types.concurrent.Agent:*", "class:com.sun.proxy.$Proxy*:*");
    private static final List<String> DEFAULT_CLASS_RULES = Arrays.asList("class:java.lang.IllegalArgumentException:*", "class:java.lang.RuntimeException:*", "class:java.lang.Exception:*", "class:java.lang.SecurityException:*", "class:java.io.IOException:*", "class:java.io.PrintStream:append", "class:java.io.InputStream", "class:java.io.OutputStream", "class:java.lang.Object", "class:java.lang.Object:class", "class:java.lang.Character", "class:java.lang.String", "class:java.lang.Boolean", "class:java.lang.Integer", "class:java.lang.Long", "class:java.lang.Float", "class:java.lang.Double", "class:java.lang.Byte", "class:java.lang.StringBuffer", "class:java.lang.StringBuilder", "class:java.time.ZonedDateTime:*", "class:java.time.LocalDateTime:*", "class:java.time.LocalDate:*", "class:java.math.BigInteger", "class:java.math.BigDecimal", "class:java.nio.ByteBuffer", "class:java.nio.HeapByteBuffer:*", "class:java.util.ArrayList:*", "class:java.util.Collection:*", "class:java.util.Date:*", "class:java.util.HashMap:*", "class:java.util.HashSet:*", "class:java.util.LinkedHashMap:*", "class:java.util.List:*", "class:java.util.Locale:*", "class:java.util.Map:*", "class:java.util.Set:*", "class:java.util.concurrent.Semaphore:*", "class:java.util.concurrent.CountDownLatch:*", "class:java.util.concurrent.CyclicBarrier:*", "class:java.util.concurrent.locks.*:*");
    public static final Set<String> DEFAULT_SYSTEM_PROPERTIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("file.separator", "java.home", "java.vendor", "java.vendor.url", "java.version", "line.separator", "os.arch", "os.name", "os.version", "path.separator", "user.dir", "user.home", "user.name")));
    public static Set<String> DEFAULT_WHITELISTED_MODULES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("crypt", "kira", "math", "walk", "xml")));
    public static final Set<String> DEFAULT_SYSTEM_ENVS = Collections.unmodifiableSet(new HashSet());
    private final List<String> rules = new ArrayList<String>();
    private Integer maxExecTimeSeconds = null;
    private Integer maxFutureThreadPoolSize = null;

    public SandboxRules() {
        this(true);
    }

    private SandboxRules(boolean withDefaults) {
        if (withDefaults) {
            this.withDefaultClasses();
        }
    }

    public static SandboxRules noDefaults() {
        return new SandboxRules(false);
    }

    public SandboxRules withClasses(String ... rules) {
        if (rules != null) {
            this.withClasses(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withClasses(List<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("class:") ? r : "class:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withClasses(Class<?> ... classes) {
        if (classes != null) {
            this.withClasses((Collection<Class<?>>)Arrays.asList(classes));
        }
        return this;
    }

    public SandboxRules withClasses(Collection<Class<?>> classes) {
        if (classes != null) {
            this.withClasses(classes.stream().map(c -> c.getName() + ":*").collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withDefaultClasses() {
        this.withClasses(SYSTEM_CLASS_RULES);
        this.withClasses(DEFAULT_CLASS_RULES);
        return this;
    }

    public SandboxRules withClasspathResources(String ... rules) {
        if (rules != null) {
            this.withClasspathResources(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withClasspathResources(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("classpath:") ? r : "classpath:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withSystemProperties(String ... rules) {
        if (rules != null) {
            this.withSystemProperties(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withSystemProperties(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("system.property:") ? r : "system.property:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withSystemEnvs(String ... rules) {
        if (rules != null) {
            this.withSystemEnvs(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withSystemEnvs(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("system.env:") ? r : "system.env:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules rejectVeniceFunctions(String ... rules) {
        if (rules != null) {
            this.rejectVeniceFunctions(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules rejectVeniceFunctions(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("blacklist:venice:func:") ? r : "blacklist:venice:func:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules whitelistVeniceFunctions(String ... rules) {
        if (rules != null) {
            this.whitelistVeniceFunctions(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules whitelistVeniceFunctions(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("whitelist:venice:func:") ? r : "whitelist:venice:func:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withVeniceModules(String ... rules) {
        if (rules != null) {
            this.withVeniceModules(Arrays.asList(rules));
        }
        return this;
    }

    public SandboxRules withVeniceModules(Collection<String> rules) {
        if (rules != null) {
            this.rules.addAll(rules.stream().map(r -> r.startsWith("venice:module:") ? r : "venice:module:" + r).collect(Collectors.toList()));
        }
        return this;
    }

    public SandboxRules withDefaultVeniceModules() {
        this.withVeniceModules(DEFAULT_WHITELISTED_MODULES);
        return this;
    }

    public SandboxRules withMaxExecTimeSeconds(int maxExecTimeSeconds) {
        this.maxExecTimeSeconds = maxExecTimeSeconds <= 0 ? null : Integer.valueOf(maxExecTimeSeconds);
        return this;
    }

    public SandboxRules withMaxFutureThreadPoolSize(int maximumPoolSize) {
        this.maxFutureThreadPoolSize = maximumPoolSize <= 0 ? null : Integer.valueOf(maximumPoolSize);
        return this;
    }

    public SandboxRules rejectAllVeniceIoFunctions() {
        if (this.rules != null) {
            this.rejectVeniceFunctions("*io*");
        }
        return this;
    }

    public SandboxRules rejectAllJavaCalls() {
        if (this.rules != null) {
            this.rejectVeniceFunctions(".");
        }
        return this;
    }

    public SandboxRules withStandardSystemProperties() {
        this.withSystemProperties(DEFAULT_SYSTEM_PROPERTIES);
        return this;
    }

    public SandboxRules withAllSystemProperties() {
        this.withSystemProperties("*");
        return this;
    }

    public SandboxRules withStandardSystemEnvs() {
        this.withSystemEnvs(DEFAULT_SYSTEM_ENVS);
        return this;
    }

    public SandboxRules withAllSystemEnvs() {
        this.withSystemEnvs("*");
        return this;
    }

    public SandboxRules merge(SandboxRules other) {
        SandboxRules merged = new SandboxRules();
        merged.rules.addAll(this.rules);
        merged.rules.addAll(other.rules);
        return merged;
    }

    public List<String> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public Integer getMaxExecTimeSeconds() {
        return this.maxExecTimeSeconds;
    }

    public Integer getMaxFutureThreadPoolSize() {
        return this.maxFutureThreadPoolSize;
    }

    public static List<String> getDefaultRules() {
        return new SandboxRules().getRules().stream().sorted().collect(Collectors.toList());
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        HashSet<String> items = new HashSet<String>(this.rules);
        items.removeAll(SYSTEM_CLASS_RULES);
        items.add("maxExecTimeSeconds:" + (this.maxExecTimeSeconds == null ? "no-limit" : this.maxExecTimeSeconds.toString()));
        return new ArrayList<String>(items).stream().sorted().map(s -> "   " + s).collect(Collectors.joining("\n"));
    }
}

