/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.pdf;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class PdfWatermark {
    public ByteBuffer addWatermarkImage(ByteBuffer pdf, String imgResourceName, int skipTopPages, int skipBottomPages) {
        if (pdf == null) {
            throw new IllegalArgumentException("A pdf must not be null");
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PdfReader reader = new PdfReader(pdf.array());
            int numPages = reader.getNumberOfPages();
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)os);
            Image watermark_image = Image.getInstance((String)imgResourceName);
            watermark_image.setAbsolutePosition(200.0f, 400.0f);
            int startPage = skipTopPages;
            int endPage = numPages - skipBottomPages;
            for (int page = startPage; page < endPage; ++page) {
                PdfContentByte under = stamper.getUnderContent(page);
                under.addImage(watermark_image);
            }
            stamper.close();
            return ByteBuffer.wrap(os.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to add image watermark to the PDF", ex);
        }
    }

    public ByteBuffer addWatermarkText(ByteBuffer pdf, String text, float fontSize, float fontCharacterSpacing, Color color, float opacity, Color colorOutline, float colorOutlineOpacity, float outlineWidth, float angle, boolean overContent, int skipTopPages, int skipBottomPages) {
        if (pdf == null) {
            throw new IllegalArgumentException("A pdf must not be null");
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PdfReader reader = new PdfReader(pdf.array());
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)os);
            int numPages = reader.getNumberOfPages();
            int startPage = 1 + skipTopPages;
            int endPage = numPages - skipBottomPages;
            BaseFont baseFont = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            Color textColor = this.withOpacity(this.nullToBlack(color), opacity);
            Color strokeColor = this.withOpacity(this.nullToBlack(colorOutline), colorOutlineOpacity);
            for (int page = startPage; page <= endPage; ++page) {
                PdfContentByte cb = overContent ? stamper.getOverContent(page) : stamper.getUnderContent(page);
                cb.saveState();
                cb.setColorFill(textColor);
                cb.setColorStroke(strokeColor);
                cb.beginText();
                cb.setFontAndSize(baseFont, fontSize);
                cb.setCharacterSpacing(fontCharacterSpacing);
                cb.setLineWidth(Math.max(0.0f, outlineWidth));
                cb.setTextRenderingMode(2);
                cb.showTextAligned(1, text, cb.getPdfDocument().getPageSize().getWidth() / 2.0f, cb.getPdfDocument().getPageSize().getHeight() / 2.0f, angle);
                cb.endText();
                cb.restoreState();
            }
            stamper.close();
            return ByteBuffer.wrap(os.toByteArray());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to add text watermark to the PDF", ex);
        }
    }

    private Color nullToBlack(Color color) {
        return color == null ? Color.BLACK : color;
    }

    private Color withOpacity(Color color, float opacity) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), this.toIntOpacity(opacity));
    }

    private int toIntOpacity(float opacity) {
        return Math.max(0, Math.min(255, (int)(opacity * 255.0f)));
    }
}

