/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.ModuleLoader;
import com.github.jlangch.venice.impl.functions.CoreFunctions;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.javainterop.JavaInterop;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncSymbol;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.ZipFileSystemUtil;
import com.github.jlangch.venice.javainterop.IInterceptor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;

public class ModuleFunctions {
    public static VncFunction loadModule = new VncFunction("*load-module", (VncVal)VncFunction.meta().arglists("(*load-module name)").doc("Loads a Venice extension module.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("*load-module", args, 1);
            try {
                String name = Coerce.toVncString(CoreFunctions.name.apply(args)).getValue();
                IInterceptor interceptor = JavaInterop.getInterceptor();
                interceptor.validateLoadModule(name);
                return new VncString(ModuleLoader.loadModule(name));
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice module", ex);
            }
        }
    };
    public static VncFunction loadClasspathFile = new VncFunction("*load-classpath-file", (VncVal)VncFunction.meta().arglists("(*load-classpath-file name)").doc("Loads a Venice file from the classpath.").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("*load-classpath-file", args, 1);
            JavaInterop.getInterceptor().validateVeniceFunction("*load-classpath-file");
            try {
                String file = ModuleFunctions.suffixWithVeniceFileExt(ModuleFunctions.name(args.first()));
                if (file != null) {
                    String res = ModuleLoader.loadClasspathFile(file);
                    return res == null ? Constants.Nil : new VncString(res);
                }
                return Constants.Nil;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice classpath file", ex);
            }
        }
    };
    public static VncFunction loadResource = new VncFunction("*load-resource", (VncVal)VncFunction.meta().arglists("(*load-resource file load-paths & options)").doc("Loads a resource from the given load-paths. Returns a string, a bytebuffer or nil if the file does not exist. \n\nOptions: \n  :binary true/false - e.g :binary true, defaults to true \n  :encoding enc - e.g :encoding :utf-8, defaults to :utf-8").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("*load-resource", args, 2);
            try {
                VncHashMap options = VncHashMap.ofAll(args.rest().rest());
                boolean binary = VncBoolean.isTrue(options.get(new VncKeyword("binary")));
                String encoding = ModuleFunctions.encoding(options.get(new VncKeyword("encoding")));
                File file = new File(ModuleFunctions.name(args.first()));
                VncList loadPaths = Coerce.toVncList(args.second());
                if (loadPaths.isEmpty()) {
                    VncVal data = ModuleFunctions.load(file.toPath());
                    return data == Constants.Nil || binary ? data : ModuleFunctions.convertToString(data, encoding);
                }
                VncVal data = loadPaths.getList().stream().map(p -> ModuleFunctions.name(p)).map(p -> ModuleFunctions.loadFile(p, file)).filter(d -> d != Constants.Nil).findFirst().orElse(Constants.Nil);
                if (data == Constants.Nil) {
                    throw new VncException("Failed to load Venice file: " + file);
                }
                return binary ? data : ModuleFunctions.convertToString(data, encoding);
            }
            catch (VncException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new VncException("Failed to load Venice file", ex);
            }
        }
    };
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(loadModule).add(loadResource).add(loadClasspathFile).toMap();

    private static String name(VncVal val) {
        if (Types.isVncString(val)) {
            return ((VncString)val).getValue();
        }
        if (Types.isVncKeyword(val)) {
            return ((VncKeyword)val).getValue();
        }
        if (Types.isVncSymbol(val)) {
            return ((VncSymbol)val).getName();
        }
        return null;
    }

    private static String suffixWithVeniceFileExt(String s) {
        return s.endsWith(".venice") ? s : s + ".venice";
    }

    private static VncVal loadFile(String loadPath, File file) {
        return loadPath.endsWith(".zip") ? ModuleFunctions.loadFileFromZip(new File(loadPath), file) : ModuleFunctions.loadFileFromDir(new File(loadPath), file);
    }

    private static VncVal loadFileFromZip(File zip, File file) {
        if (zip.exists()) {
            try {
                return ZipFileSystemUtil.loadBinaryFileFromZip(zip, file);
            }
            catch (Exception ex) {
                return Constants.Nil;
            }
        }
        return Constants.Nil;
    }

    private static VncVal loadFileFromDir(File path, File file) {
        try {
            if (ModuleFunctions.isFileWithinDirectory(path, file)) {
                File dir = path.getAbsoluteFile();
                return ModuleFunctions.load(new File(dir, file.getPath()).toPath());
            }
            return Constants.Nil;
        }
        catch (Exception ex) {
            throw new VncException(String.format("Failed to load file '%s'", file.getPath()), ex);
        }
    }

    private static boolean isFileWithinDirectory(File path, File file) throws IOException {
        File fl;
        File dir = path.getAbsoluteFile();
        return dir.isDirectory() && (fl = new File(dir, file.getPath())).isFile() && fl.getCanonicalPath().startsWith(dir.getCanonicalPath());
    }

    private static VncVal load(Path path) {
        try {
            return new VncByteBuffer(Files.readAllBytes(path));
        }
        catch (Exception ex) {
            return Constants.Nil;
        }
    }

    private static VncVal convertToString(VncVal binary, String encoding) {
        try {
            return binary == Constants.Nil ? Constants.Nil : new VncString(new String(((VncByteBuffer)binary).getBytes(), encoding));
        }
        catch (Exception ex) {
            return Constants.Nil;
        }
    }

    private static String encoding(VncVal enc) {
        return enc == Constants.Nil ? "utf-8" : (Types.isVncKeyword(enc) ? Coerce.toVncKeyword(enc).getValue() : Coerce.toVncString(enc).getValue());
    }
}

