/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.functions;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.functions.FunctionsUtil;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncBoolean;
import com.github.jlangch.venice.impl.types.VncByteBuffer;
import com.github.jlangch.venice.impl.types.VncChar;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncJavaObject;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashMap;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncSequence;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.HexFormatter;
import com.github.jlangch.venice.impl.util.HexUtil;
import com.github.jlangch.venice.impl.util.LoremIpsum;
import com.github.jlangch.venice.impl.util.StringUtil;
import com.github.jlangch.venice.impl.util.Tuple2;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StringFunctions {
    public static VncFunction str_blank_Q = new VncFunction("str/blank?", (VncVal)VncFunction.meta().arglists("(str/blank? s)").doc("True if s is nil, empty, or contains only whitespace.").examples("(str/blank? nil)", "(str/blank? \"\")", "(str/blank? \"  \")", "(str/blank? \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/blank?", args, 1);
            if (args.first() == Constants.Nil) {
                return VncBoolean.True;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncBoolean.of(StringUtil.isBlank(s));
        }
    };
    public static VncFunction str_char_Q = new VncFunction("str/char?", (VncVal)VncFunction.meta().arglists("(str/char s)").doc("Returns true if s is a single char string.").examples("(str/char? \"x\")", "(str/char? (char \"x\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/char?", args, 1);
            VncVal s = args.first();
            if (s == Constants.Nil) {
                return Constants.Nil;
            }
            if (Types.isVncChar(s)) {
                return VncBoolean.True;
            }
            return VncBoolean.of(Types.isVncString(s) && ((VncString)s).size() == 1);
        }
    };
    public static VncFunction str_starts_with_Q = new VncFunction("str/starts-with?", (VncVal)VncFunction.meta().arglists("(str/starts-with? s substr)").doc("True if s starts with substr.").examples("(str/starts-with? \"abc\"  \"ab\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/starts-with?", args, 2);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            VncString string = Coerce.toVncString(args.first());
            VncString prefix = Coerce.toVncString(args.second());
            return VncBoolean.of(string.getValue().startsWith(prefix.getValue()));
        }
    };
    public static VncFunction str_ends_with_Q = new VncFunction("str/ends-with?", (VncVal)VncFunction.meta().arglists("(str/ends-with? s substr)").doc("True if s ends with substr.").examples("(str/ends-with? \"abc\"  \"bc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/ends-with?", args, 2);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            VncString string = Coerce.toVncString(args.first());
            VncString suffix = Coerce.toVncString(args.second());
            return VncBoolean.of(string.getValue().endsWith(suffix.getValue()));
        }
    };
    public static VncFunction str_contains_Q = new VncFunction("str/contains?", (VncVal)VncFunction.meta().arglists("(str/contains? s substr)").doc("True if s contains with substr.").examples("(str/contains? \"abc\" \"ab\")", "(str/contains? \"abc\" (char \"b\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/contains?", args, 2);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil) {
                return VncBoolean.False;
            }
            VncString string = Coerce.toVncString(args.first());
            VncVal vSubstr = args.second();
            if (Types.isVncString(vSubstr)) {
                String text = Coerce.toVncString(args.second()).getValue();
                if (text.isEmpty()) {
                    return VncBoolean.False;
                }
                return VncBoolean.of(string.getValue().contains(text));
            }
            if (Types.isVncChar(vSubstr)) {
                Character ch = Coerce.toVncChar(args.second()).getValue();
                String text = String.valueOf(ch);
                return VncBoolean.of(string.getValue().contains(text));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_equals_ignore_case_Q = new VncFunction("str/equals-ignore-case?", (VncVal)VncFunction.meta().arglists("(str/equals-ignore-case? s1 s2)").doc("Compares two strings ignoring case.  True if both are equal.").examples("(str/equals-ignore-case? \"abc\"  \"abC\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/equals-ignore-case?", args, 2);
            VncVal v1 = args.first();
            VncVal v2 = args.second();
            if (v1 == Constants.Nil || v2 == Constants.Nil) {
                return VncBoolean.True;
            }
            if (v1 != Constants.Nil || v2 != Constants.Nil) {
                String s1 = Coerce.toVncString(args.first()).getValue();
                String s2 = Coerce.toVncString(args.second()).getValue();
                return VncBoolean.of(s1.equalsIgnoreCase(s2));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_trim = new VncFunction("str/trim", (VncVal)VncFunction.meta().arglists("(str/trim s)").doc("Trims leading and trailing spaces from s.").examples("(str/trim \" abc  \")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/trim", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.first()).getValue().trim());
        }
    };
    public static VncFunction str_trim_to_nil = new VncFunction("str/trim-to-nil", (VncVal)VncFunction.meta().arglists("(str/trim-to-nil s)").doc("Trims leading and trailing spaces from s. Returns nil if the resulting string is empty").examples("(str/trim-to-nil \"\")", "(str/trim-to-nil \"    \")", "(str/trim-to-nil nil)", "(str/trim-to-nil \" abc   \")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/trim-to-nil", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String str = Coerce.toVncString(args.first()).getValue().trim();
            return str.isEmpty() ? Constants.Nil : new VncString(str);
        }
    };
    public static VncFunction str_index_of = new VncFunction("str/index-of", (VncVal)VncFunction.meta().arglists("(str/index-of s value)", "(str/index-of s value from-index)").doc("Return index of value (string or char) in s, optionally searching forward from from-index. Return nil if value not found.").examples("(str/index-of \"abcdefabc\" \"ab\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/index-of", args, 2, 3);
            String text = Coerce.toVncString(args.first()).getValue();
            String searchString = Coerce.toVncString(args.second()).getValue();
            if (args.size() == 3) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.indexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.indexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_last_index_of = new VncFunction("str/last-index-of", (VncVal)VncFunction.meta().arglists("(str/last-index-of s value)", "(str/last-index-of s value from-index)").doc("Return last index of value (string or char) in s, optionally searching backward from from-index. Return nil if value not found.").examples("(str/last-index-of \"abcdefabc\" \"ab\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/last-index-of", args, 2, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String searchString = Coerce.toVncString(args.second()).getValue();
            if (args.size() > 2) {
                int startPos = Coerce.toVncLong(args.nth(2)).getValue().intValue();
                int pos = text.lastIndexOf(searchString, startPos);
                return pos < 0 ? Constants.Nil : new VncLong(pos);
            }
            int pos = text.lastIndexOf(searchString);
            return pos < 0 ? Constants.Nil : new VncLong(pos);
        }
    };
    public static VncFunction str_replace_all = new VncFunction("str/replace-all", (VncVal)VncFunction.meta().arglists("(str/replace-all s search replacement)").doc("Replaces the all occurrances of search in s. The search arg may be a string or a regex pattern").examples("(str/replace-all \"abcdefabc\" \"ab\" \"__\")", "(str/replace-all \"a0b01c012d\" (regex/pattern \"[0-9]+\") \"_\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("str/replace-all", args, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            VncVal search = args.second();
            String replacement = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(3));
            boolean ignoreCase = VncBoolean.isTrue(options.get(new VncKeyword("ignore-case"), VncBoolean.False));
            if (Types.isVncString(search)) {
                String searchString = Coerce.toVncString(args.second()).getValue();
                return new VncString(StringUtil.replace(text, searchString, replacement, 1000000, ignoreCase));
            }
            if (Types.isVncJavaObject(search, Pattern.class)) {
                Pattern p = (Pattern)((VncJavaObject)search).getDelegate();
                Matcher m = p.matcher(text);
                return new VncString(m.replaceAll(replacement));
            }
            throw new VncException(String.format("Function 'str/replace-all' does not allow %s as search argument.", Types.getType(search)));
        }
    };
    public static VncFunction str_replace_first = new VncFunction("str/replace-first", (VncVal)VncFunction.meta().arglists("(str/replace-first s search replacement & options)").doc("Replaces the first occurrance of search in s. The search arg may be astring or a regex pattern. If the search arg is of type string the options :ignore-case and :nfirst are supported.\n\nOptions: \n  :ignore-case true/false - e.g :ignore-case true, defaults to false \n  :nfirst n - e.g :nfirst 2, defaults to 1").examples("(str/replace-first \"ab-cd-ef-ab-cd\" \"ab\" \"XYZ\")", "(str/replace-first \"AB-CD-EF-AB-CD\" \"ab\" \"XYZ\" :ignore-case true)", "(str/replace-first \"ab-ab-cd-ab-ef-ab-cd\" \"ab\" \"XYZ\" :nfirst 3)", "(str/replace-first \"a0b01c012d\" (regex/pattern \"[0-9]+\") \"_\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("str/replace-first", args, 3);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil || args.third() == Constants.Nil) {
                return args.first();
            }
            String text = Coerce.toVncString(args.first()).getValue();
            VncVal search = args.second();
            String replacement = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(3));
            boolean ignoreCase = VncBoolean.isTrue(options.get(new VncKeyword("ignore-case"), VncBoolean.False));
            long nFirst = Coerce.toVncLong(options.get(new VncKeyword("nfirst"), new VncLong(1))).getValue();
            if (Types.isVncString(search)) {
                String searchString = Coerce.toVncString(args.second()).getValue();
                return new VncString(StringUtil.replace(text, searchString, replacement, (int)nFirst, ignoreCase));
            }
            if (Types.isVncJavaObject(search, Pattern.class)) {
                Pattern p = (Pattern)((VncJavaObject)search).getDelegate();
                Matcher m = p.matcher(text);
                return new VncString(m.replaceFirst(replacement));
            }
            throw new VncException(String.format("Function 'str/replace-first' does not allow %s as search argument.", Types.getType(search)));
        }
    };
    public static VncFunction str_replace_last = new VncFunction("str/replace-last", (VncVal)VncFunction.meta().arglists("(str/replace-last s search replacement & options)").doc("Replaces the last occurrance of search in s\n\nOptions: \n  :ignore-case true/false - e.g :ignore-case true, defaults to false").doc("Replaces the last occurrance of search in s").examples("(str/replace-last \"abcdefabc\" \"ab\" \"XYZ\")", "(str/replace-last \"foo.JPG\" \".jpg\" \".png\" :ignore-case true)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("str/replace-last", args, 3);
            if (args.first() == Constants.Nil || args.second() == Constants.Nil || args.third() == Constants.Nil) {
                return args.first();
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String searchString = Coerce.toVncString(args.second()).getValue();
            String replacement = Coerce.toVncString(args.third()).getValue();
            VncHashMap options = VncHashMap.ofAll(args.slice(3));
            boolean ignoreCase = VncBoolean.isTrue(options.get(new VncKeyword("ignore-case"), VncBoolean.False));
            return new VncString(StringUtil.replaceLast(text, searchString, replacement, ignoreCase));
        }
    };
    public static VncFunction str_reverse = new VncFunction("str/reverse", (VncVal)VncFunction.meta().arglists("(str/reverse s)").doc("Reverses a string").examples("(str/reverse \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/reverse", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(new StringBuilder(Coerce.toVncString(args.first()).getValue()).reverse().toString());
        }
    };
    public static VncFunction str_lower_case = new VncFunction("str/lower-case", (VncVal)VncFunction.meta().arglists("(str/lower-case s)", "(str/lower-case locale s)").doc("Converts s to lowercase").examples("(str/lower-case \"aBcDeF\")", "(str/lower-case (. :java.util.Locale :new \"de\" \"DE\") \"aBcDeF\")", "(str/lower-case (. :java.util.Locale :GERMANY) \"aBcDeF\")", "(str/lower-case (. :java.util.Locale :new \"de\" \"CH\") \"aBcDeF\")", "(str/lower-case [ \"de\"] \"aBcDeF\")", "(str/lower-case [ \"de\" \"DE\"] \"aBcDeF\")", "(str/lower-case [ \"de\" \"DE\"] \"aBcDeF\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/lower-case", args, 1, 2);
            if (args.size() == 1) {
                if (args.first() == Constants.Nil) {
                    return Constants.Nil;
                }
                return new VncString(Coerce.toVncString(args.first()).getValue().toLowerCase());
            }
            Locale locale = StringFunctions.toLocale(args.first());
            if (locale == null) {
                throw new VncException(String.format("str/lower-case: the first arg is not a locale", Types.getType(args.first())));
            }
            if (args.second() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.second()).getValue().toLowerCase(locale));
        }
    };
    public static VncFunction str_upper_case = new VncFunction("str/upper-case", (VncVal)VncFunction.meta().arglists("(str/upper-case s)", "(str/upper-case locale s)").doc("Converts s to uppercase").examples("(str/upper-case \"aBcDeF\")", "(str/upper-case (. :java.util.Locale :new \"de\" \"DE\") \"aBcDeF\")", "(str/upper-case (. :java.util.Locale :GERMANY) \"aBcDeF\")", "(str/upper-case (. :java.util.Locale :new \"de\" \"CH\") \"aBcDeF\")", "(str/upper-case [ \"de\"] \"aBcDeF\")", "(str/upper-case [ \"de\" \"DE\"] \"aBcDeF\")", "(str/upper-case [ \"de\" \"DE\"] \"aBcDeF\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/upper-case", args, 1, 2);
            if (args.size() == 1) {
                if (args.first() == Constants.Nil) {
                    return Constants.Nil;
                }
                return new VncString(Coerce.toVncString(args.first()).getValue().toUpperCase());
            }
            Locale locale = StringFunctions.toLocale(args.first());
            if (locale == null) {
                throw new VncException(String.format("str/upper-case: the first arg is not a locale", Types.getType(args.first())));
            }
            if (args.second() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(Coerce.toVncString(args.second()).getValue().toUpperCase(locale));
        }
    };
    public static VncFunction str_join = new VncFunction("str/join", (VncVal)VncFunction.meta().arglists("(str/join coll)", "(str/join separator coll)").doc("Joins all elements in coll separated by an optional separator.").examples("(str/join [1 2 3])", "(str/join \"-\" [1 2 3])", "(str/join \"-\" [(char \"a\") 1 \"xyz\" 2.56M])").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/join", args, 1, 2);
            VncSequence coll = Coerce.toVncSequence(args.last());
            VncString delim = args.size() == 2 ? Coerce.toVncString(args.first()) : VncString.empty();
            return new VncString(coll.size() > 0 ? coll.getList().stream().map(v -> Types.isVncString(v) ? ((VncString)v).getValue() : v.toString()).collect(Collectors.joining(delim.getValue())) : "");
        }
    };
    public static VncFunction str_subs = new VncFunction("str/subs", (VncVal)VncFunction.meta().arglists("(str/subs s start)", "(str/subs s start end)").doc("Returns the substring of s beginning at start inclusive, and ending at end (defaults to length of string), exclusive.").examples("(str/subs \"abcdef\" 2)", "(str/subs \"abcdef\" 2 5)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/subs", args, 2, 3);
            VncString string = Coerce.toVncString(args.first());
            VncLong from = Coerce.toVncLong(args.second());
            VncLong to = args.size() > 2 ? (VncLong)args.nth(2) : null;
            return new VncString(to == null ? string.getValue().substring(from.getValue().intValue()) : string.getValue().substring(from.getValue().intValue(), to.getValue().intValue()));
        }
    };
    public static VncFunction str_chars = new VncFunction("str/chars", (VncVal)VncFunction.meta().arglists("(str/chars s)").doc("Converts a string to a char list.").examples("(str/chars \"abcdef\")", "(str/join (str/chars \"abcdef\"))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/chars", args, 1);
            if (args.first() == Constants.Nil) {
                return VncList.empty();
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncList.ofList(s.chars().mapToObj(c -> new VncChar((char)c)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split = new VncFunction("str/split", (VncVal)VncFunction.meta().arglists("(str/split s regex)").doc("Splits string on a regular expression.").examples("(str/split \"abc,def,ghi\" \",\")", "(str/split \"abc , def , ghi\" \"[ *],[ *]\")", "(str/split \"abc,def,ghi\" \"((?<=,)|(?=,))\")", "(str/split nil \",\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/split", args, 2);
            if (args.first() == Constants.Nil) {
                return VncList.empty();
            }
            VncString string = Coerce.toVncString(args.first());
            VncString regex = Coerce.toVncString(args.second());
            return VncList.ofList(Arrays.asList(string.getValue().split(regex.getValue())).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_split_lines = new VncFunction("str/split-lines", (VncVal)VncFunction.meta().arglists("(str/split-lines s)").doc("Splits s into lines.").examples("(str/split-lines \"line1\nline2\nline3\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/split-lines", args, 1);
            return args.first() == Constants.Nil ? VncList.empty() : VncList.ofList(StringUtil.splitIntoLines(Coerce.toVncString(args.first()).getValue()).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
        }
    };
    public static VncFunction str_cr_lf = new VncFunction("str/cr-lf", (VncVal)VncFunction.meta().arglists("(str/cr-lf s mode)").doc("Convert a text to use LF or CR-LF.").examples("(str/cr-lf \"line1\nline2\nline3\" :cr-lf)", "(str/cr-lf \"line1\nline2\nline3\" :lf)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/cr-lf", args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            String mode = Coerce.toVncKeyword(args.second()).getValue();
            String ending = "cr-lf".equals(mode) ? "\r\n" : "\n";
            return new VncString(StringUtil.splitIntoLines(text).stream().collect(Collectors.joining(ending)));
        }
    };
    public static VncFunction str_rest = new VncFunction("str/rest", (VncVal)VncFunction.meta().arglists("(str/rest s)").doc("Returns a possibly empty string of the characters after the first.").examples("(str/rest \"abcdef\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/rest", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.length() < 2 ? "" : s.substring(1));
        }
    };
    public static VncFunction str_format = new VncFunction("str/format", (VncVal)VncFunction.meta().arglists("(str/format format args*)", "(str/format locale format args*)").doc("Returns a formatted string using the specified format string and arguments.").examples("(str/format \"value: %.4f\" 1.45)", "(str/format (. :java.util.Locale :new \"de\" \"DE\") \"value: %.4f\" 1.45)", "(str/format (. :java.util.Locale :GERMANY) \"value: %.4f\" 1.45)", "(str/format (. :java.util.Locale :new \"de\" \"CH\") \"value: %,d\" 2345000)", "(str/format [ \"de\"] \"value: %.4f\" 1.45)", "(str/format [ \"de\" \"DE\"] \"value: %.4f\" 1.45)", "(str/format [ \"de\" \"DE\"] \"value: %,d\" 2345000)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            if (Types.isVncString(args.first())) {
                VncString fmt = (VncString)args.first();
                VncList fmtArgs = args.rest();
                return new VncString(String.format(fmt.getValue(), StringFunctions.toJavaObjects(fmtArgs).toArray()));
            }
            Locale locale = StringFunctions.toLocale(args.first());
            VncString fmt = (VncString)args.second();
            VncList fmtArgs = args.slice(2);
            return new VncString(String.format(locale, fmt.getValue(), StringFunctions.toJavaObjects(fmtArgs).toArray()));
        }
    };
    public static VncFunction str_quote = new VncFunction("str/quote", (VncVal)VncFunction.meta().arglists("(str/quote str q)", "(str/quote str start end)").doc("Quotes a string.").examples("(str/quote \"abc\" \"-\")", "(str/quote \"abc\" \"<\" \">\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/quote", args, 2, 3);
            String s = Coerce.toVncString(args.first()).getValue();
            String start = Coerce.toVncString(args.second()).getValue();
            String end = args.size() == 2 ? start : Coerce.toVncString(args.nth(2)).getValue();
            return new VncString(start + s + end);
        }
    };
    public static VncFunction str_quoted_Q = new VncFunction("str/quoted?", (VncVal)VncFunction.meta().arglists("(str/quoted? str q)", "(str/quoted? str start end)").doc("Returns true if the string is quoted.").examples("(str/quoted? \"-abc-\" \"-\")", "(str/quoted? \"<abc>\" \"<\" \">\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/quoted?", args, 2, 3);
            String s = Coerce.toVncString(args.first()).getValue();
            String start = Coerce.toVncString(args.second()).getValue();
            String end = args.size() == 2 ? start : Coerce.toVncString(args.nth(2)).getValue();
            return VncBoolean.of(s.startsWith(start) && s.endsWith(end));
        }
    };
    public static VncFunction str_double_quote = new VncFunction("str/double-quote", (VncVal)VncFunction.meta().arglists("(str/double-quote str)").doc("Double quotes a string.").examples("(str/double-quote \"abc\")", "(str/double-quote \"\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/double-quote", args, 1);
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString("\"" + s + "\"");
        }
    };
    public static VncFunction str_double_unquote = new VncFunction("str/double-unquote", (VncVal)VncFunction.meta().arglists("(str/double-unquote str)").doc("Unquotes a double quoted string.").examples("(str/double-unquote \"\\\"abc\\\"\")", "(str/double-unquote \"\\\"\\\"\")", "(str/double-unquote nil)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/double-unquote", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                return new VncString(s.length() == 2 ? "" : s.substring(1, s.length() - 1));
            }
            return args.first();
        }
    };
    public static VncFunction str_double_quoted_Q = new VncFunction("str/double-quoted?", (VncVal)VncFunction.meta().arglists("(str/double-quoteed? str)").doc("Returns true if the string is double quoted.").examples("(str/double-quoted? \"\\\"abc\\\"\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/double-quoted?", args, 1);
            if (args.first() == Constants.Nil) {
                return VncBoolean.False;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return VncBoolean.of(s.startsWith("\"") && s.endsWith("\""));
        }
    };
    public static VncFunction str_truncate = new VncFunction("str/truncate", (VncVal)VncFunction.meta().arglists("(str/truncate s maxlen marker mode*)").doc("Truncates a string to the max lenght maxlen and adds the marker if the string needs to be truncated. The marker is added to the start, middle, or end of the string depending on the mode :start, :middle, :end. The mode defaults to :end").examples("(str/truncate \"abcdefghij\" 20 \"...\")", "(str/truncate \"abcdefghij\" 9 \"...\")", "(str/truncate \"abcdefghij\" 4 \"...\")", "(str/truncate \"abcdefghij\" 7 \"...\" :start)", "(str/truncate \"abcdefghij\" 7 \"...\" :middle)", "(str/truncate \"abcdefghij\" 7 \"...\" :end)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/truncate", args, 3, 4);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String text = Coerce.toVncString(args.first()).getValue();
            int maxLen = Coerce.toVncLong(args.second()).getValue().intValue();
            String marker = Coerce.toVncString(args.nth(2)).getValue();
            String mode = Coerce.toVncKeyword(args.nthOrDefault(3, new VncKeyword(":end"))).getValue();
            int lenMarker = marker.length();
            if (maxLen <= lenMarker) {
                throw new VncException("A maxLen must greater than the length of the truncation marker");
            }
            if (text == null || text.length() <= maxLen) {
                return args.first();
            }
            switch (mode) {
                case "start": {
                    int lenTail = maxLen - lenMarker;
                    return new VncString(marker + text.substring(text.length() - lenTail));
                }
                case "middle": {
                    int lenStart = maxLen / 2 - lenMarker / 2;
                    int lenTail = maxLen - lenStart - lenMarker;
                    return new VncString(text.substring(0, lenStart) + marker + text.substring(text.length() - lenTail));
                }
                case "end": {
                    int lenStart = maxLen - lenMarker;
                    return new VncString(text.substring(0, lenStart) + marker);
                }
            }
            throw new VncException("Invalid truncation mode ':" + mode + "'");
        }
    };
    public static VncFunction str_expand = new VncFunction("str/expand", (VncVal)VncFunction.meta().arglists("(str/expand s len fill mode*)").doc("Expands a string to the max lenght len. Fills up with the fillstring if the string needs to be expanded. The fill string is added to the start or end of the string depending on the mode:start, :end. The mode defaults to :end").examples("(str/expand \"abcdefghij\" 8 \".\")", "(str/expand \"abcdefghij\" 20 \".\")", "(str/expand \"abcdefghij\" 20 \".\" :start)", "(str/expand \"abcdefghij\" 20 \".\" :end)", "(str/expand \"abcdefghij\" 30 \"1234\" :start)", "(str/expand \"abcdefghij\" 30 \"1234\" :end)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/expand", args, 3, 4);
            String text = args.first() == Constants.Nil ? "" : Coerce.toVncString(args.first()).getValue();
            int len = Coerce.toVncLong(args.second()).getValue().intValue();
            String fill = Coerce.toVncString(args.nth(2)).getValue();
            String mode = Coerce.toVncKeyword(args.nthOrDefault(3, new VncKeyword(":end"))).getValue();
            if (fill.isEmpty()) {
                throw new VncException("A fill string must not be empty");
            }
            if (text.length() >= len) {
                return args.first();
            }
            int gap = len - text.length();
            StringBuilder filling = new StringBuilder();
            while (filling.length() < gap) {
                int delta = gap - filling.length();
                filling.append(delta >= fill.length() ? fill : fill.substring(0, delta));
            }
            switch (mode) {
                case "start": {
                    return new VncString(filling + text);
                }
                case "end": {
                    return new VncString(text + filling);
                }
            }
            throw new VncException("Invalid truncation mode ':" + mode + "'");
        }
    };
    public static VncFunction str_strip_start = new VncFunction("str/strip-start", (VncVal)VncFunction.meta().arglists("(str/strip-start s substr)").doc("Removes a substr only if it is at the beginning of a s, otherwise returns s.").examples("(str/strip-start \"abcdef\" \"abc\")", "(str/strip-start \"abcdef\" \"def\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String substr;
            FunctionsUtil.assertArity("str/strip-start", args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.startsWith(substr = Coerce.toVncString(args.second()).getValue()) ? s.substring(substr.length()) : s);
        }
    };
    public static VncFunction str_strip_end = new VncFunction("str/strip-end", (VncVal)VncFunction.meta().arglists("(str/strip-end s substr)").doc("Removes a substr only if it is at the end of a s, otherwise returns s.").examples("(str/strip-end \"abcdef\" \"def\")", "(str/strip-end \"abcdef\" \"abc\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String substr;
            FunctionsUtil.assertArity("str/strip-end", args, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            return new VncString(s.endsWith(substr = Coerce.toVncString(args.second()).getValue()) ? s.substring(0, s.length() - substr.length()) : s);
        }
    };
    public static VncFunction str_strip_indent = new VncFunction("str/strip-indent", (VncVal)VncFunction.meta().arglists("(str/strip-indent s)").doc("Strip the indent of a multi-line string. The first line's leading whitespaces define the indent.").examples("(str/strip-indent \"  line1\n    line2\n    line3\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/strip-indent", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripIndent(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_strip_margin = new VncFunction("str/strip-margin", (VncVal)VncFunction.meta().arglists("(str/strip-margin s)").doc("Strips leading whitespaces upto and including the margin '|' from each line in a multi-line string.").examples("(str/strip-margin \"line1\n  |  line2\n  |  line3\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/strip-margin", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncString(StringUtil.stripMargin(Coerce.toVncString(args.first()).getValue(), '|'));
        }
    };
    public static VncFunction str_repeat = new VncFunction("str/repeat", (VncVal)VncFunction.meta().arglists("(str/repeat s n)", "(str/repeat s n sep)").doc("Repeats s n times with an optional separator.").examples("(str/repeat \"abc\" 0)", "(str/repeat \"abc\" 3)", "(str/repeat \"abc\" 3 \"-\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/repeat", args, 2, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(args.first()).getValue();
            int times = Coerce.toVncLong(args.second()).getValue().intValue();
            String sep = args.size() == 3 ? Coerce.toVncString(args.nth(2)).getValue() : "";
            StringBuilder sb = new StringBuilder();
            for (int ii = 0; ii < times; ++ii) {
                if (ii > 0) {
                    sb.append(sep);
                }
                sb.append(s);
            }
            return new VncString(sb.toString());
        }
    };
    public static VncFunction str_digit_Q = new VncFunction("str/digit?", (VncVal)VncFunction.meta().arglists("(str/digit? s)").doc("True if s is a single char string and the char is a digit. Defined by Java Character.isDigit(ch).").examples("(str/digit? (char \"8\"))", "(str/digit? \"8\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/digit?", args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isDigit(((VncChar)v).getValue().charValue()));
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/digit?' expects a single char string", Types.getType(v)));
                }
                return VncBoolean.of(Character.isDigit(str.charAt(0)));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_letter_Q = new VncFunction("str/letter?", (VncVal)VncFunction.meta().arglists("(str/letter? s)").doc("True if s is a single char string and the char is a letter. Defined by Java Character.isLetter(ch).").examples("(str/letter? (char \"x\"))", "(str/letter? \"x\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/letter?", args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isLetter(((VncChar)v).getValue().charValue()));
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/letter?' expects a single char string", Types.getType(v)));
                }
                return VncBoolean.of(Character.isLetter(str.charAt(0)));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_lower_case_Q = new VncFunction("str/lower-case?", (VncVal)VncFunction.meta().arglists("(str/lower-case? s)").doc("True if s is a single char string and the char is a lower case char. Defined by Java Character.isLowerCase(ch).").examples("(str/lower-case? (char \"x\"))", "(str/lower-case? \"x\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/lower-case?", args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isLowerCase(((VncChar)v).getValue().charValue()));
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/lower-case?' expects a single char string", Types.getType(v)));
                }
                return VncBoolean.of(Character.isLowerCase(str.charAt(0)));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_upper_case_Q = new VncFunction("str/upper-case?", (VncVal)VncFunction.meta().arglists("(str/upper-case? s)").doc("True if s is a single char string and the char is an upper case char. Defined by Java Character.isUpperCase(ch).").examples("(str/upper-case? (char \"X\"))", "(str/upper-case? \"X\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/upper-case?", args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isUpperCase(((VncChar)v).getValue().charValue()));
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/upper-case?' expects a single char string", Types.getType(v)));
                }
                return VncBoolean.of(Character.isUpperCase(str.charAt(0)));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_linefeed_Q = new VncFunction("str/linefeed?", (VncVal)VncFunction.meta().arglists("(str/linefeed? s)").doc("True if s is a single char string and the char is a linefeed.").examples("(str/linefeed? (char \"\n\"))", "(str/linefeed? \"\n\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/linefeed?", args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(((VncChar)v).getValue().charValue() == '\n');
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/linefeed?' expects a single char string", Types.getType(args.first())));
                }
                return VncBoolean.of(str.charAt(0) == '\n');
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_whitespace_Q = new VncFunction("str/whitespace?", (VncVal)VncFunction.meta().arglists("(str/whitespace? s)").doc("True if s is a single char string and the char is a whitespace. Defined by Java Character.isWhitespace(ch).").examples("(str/whitespace? (char \" \"))", "(str/whitespace? \" \")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/whitespace?", args, 1);
            VncVal v = args.first();
            if (Types.isVncChar(v)) {
                return VncBoolean.of(Character.isWhitespace(((VncChar)v).getValue().charValue()));
            }
            if (Types.isVncString(v)) {
                String str = Coerce.toVncString(v).getValue();
                if (str.length() != 1) {
                    throw new VncException(String.format("Function 'str/whitespace?' expects a single char string", Types.getType(v)));
                }
                return VncBoolean.of(Character.isWhitespace(str.charAt(0)));
            }
            return VncBoolean.False;
        }
    };
    public static VncFunction str_lorem_ipsum = new VncFunction("str/lorem-ipsum", (VncVal)VncFunction.meta().arglists("(str/lorem-ipsum & options)").doc("Creates an arbitrary length Lorem Ipsum text. \n\nOptions: \n  :chars n - returns n characters (limited to " + LoremIpsum.getMaxChars() + ") \n  :paragraphs n - returns n paragraphs (limited to " + LoremIpsum.getMaxParagraphs()).examples("(str/lorem-ipsum :chars 250)", "(str/lorem-ipsum :paragraphs 1)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertMinArity("str/lorem-ipsum", args, 0);
            VncHashMap options = VncHashMap.ofAll(args);
            VncVal chars = options.get(new VncKeyword("chars"));
            if (Types.isVncLong(chars)) {
                return new VncString(LoremIpsum.loremIpsum_Chars(Coerce.toVncLong(chars).getValue().intValue()));
            }
            VncVal paragraphs = options.get(new VncKeyword("paragraphs"));
            if (Types.isVncLong(paragraphs)) {
                return new VncString(LoremIpsum.loremIpsum_Paragraphs(Coerce.toVncLong(paragraphs).getValue().intValue()));
            }
            throw new VncException("Function 'str/lorem-ipsum' invalid options");
        }
    };
    public static VncFunction str_bytebuf_to_hex = new VncFunction("str/bytebuf-to-hex", (VncVal)VncFunction.meta().arglists("(str/bytebuf-to-hex data)", "(str/bytebuf-to-hex data :upper)").doc("Converts byte data to a hex string using the hexadecimal digits: 0123456789abcdef. \nIf the :upper options is passed the hex digits 0123456789ABCDEF are used.").examples("(str/bytebuf-to-hex (bytebuf [0 1 2 3 4 5 6]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/bytebuf-to-hex", args, 1, 2);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            VncByteBuffer data = Coerce.toVncByteBuffer(args.first());
            if (args.size() == 1) {
                return new VncString(HexUtil.toString(data.getBytes()));
            }
            VncKeyword opt = Coerce.toVncKeyword(args.second());
            if (opt.getValue().equalsIgnoreCase("upper")) {
                return new VncString(HexUtil.toStringUpperCase(data.getBytes()));
            }
            throw new VncException("Function 'str/bytebuf-to-hex' expects the option :upper");
        }
    };
    public static VncFunction str_hex_to_bytebuf = new VncFunction("str/hex-to-bytebuf", (VncVal)VncFunction.meta().arglists("(str/hex-to-bytebuf hex)").doc("Converts a hex string to a bytebuf").examples("(str/hex-to-bytebuf \"005E4AFF\")", "(str/hex-to-bytebuf \"005e4aff\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/hex-to-bytebuf", args, 1);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            return new VncByteBuffer(HexUtil.toBytes(Coerce.toVncString(args.first()).getValue()));
        }
    };
    public static VncFunction str_format_bytebuf = new VncFunction("str/format-bytebuf", (VncVal)VncFunction.meta().arglists("(str/format-bytebuf data delimiter & options)").doc("Formats a bytebuffer. \n\nOptions \n  :prefix0x - prefix with 0x").examples("(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) nil)", "(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) \"\")", "(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) \", \")", "(str/format-bytebuf (bytebuf [0 34 67 -30 -1]) \", \" :prefix0x)").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            String delimiter;
            FunctionsUtil.assertArity("str/format-bytebuf", args, 2, 3);
            if (args.first() == Constants.Nil) {
                return Constants.Nil;
            }
            VncByteBuffer data = Coerce.toVncByteBuffer(args.first());
            String string = delimiter = args.second() == Constants.Nil ? "" : Coerce.toVncString(args.second()).getValue();
            if (args.size() == 2) {
                return new VncString(HexFormatter.toHex(data.getBytes(), delimiter, false));
            }
            VncKeyword opt = Coerce.toVncKeyword(args.third());
            if (opt.getValue().equalsIgnoreCase("prefix0x")) {
                return new VncString(HexFormatter.toHex(data.getBytes(), delimiter, true));
            }
            throw new VncException("Function 'str/format-bytebuf' expects the option :prefix0x");
        }
    };
    public static VncFunction str_encode_base64 = new VncFunction("str/encode-base64", (VncVal)VncFunction.meta().arglists("(str/encode-base64 data)").doc("Base64 encode.").examples("(str/encode-base64 (bytebuf [0 1 2 3 4 5 6]))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/encode-base64", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            byte[] buf = Coerce.toVncByteBuffer(arg).getBytes();
            return new VncString(Base64.getEncoder().encodeToString(buf));
        }
    };
    public static VncFunction str_decode_base64 = new VncFunction("str/decode-base64", (VncVal)VncFunction.meta().arglists("(str/decode-base64 s)").doc("Base64 decode.").examples("(str/decode-base64 (str/encode-base64 (bytebuf [0 1 2 3 4 5 6])))").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/decode-base64", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            String base64 = Coerce.toVncString(arg).getValue();
            return new VncByteBuffer(Base64.getDecoder().decode(base64));
        }
    };
    public static VncFunction str_encode_url = new VncFunction("str/encode-url", (VncVal)VncFunction.meta().arglists("(str/encode-url s)").doc("URL encode.").examples("(str/encode-url \"The string \u00fc@foo-bar\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/encode-url", args, 1);
            try {
                VncVal arg = args.first();
                if (arg == Constants.Nil) {
                    return Constants.Nil;
                }
                String s = Coerce.toVncString(arg).getValue();
                return new VncString(URLEncoder.encode(s, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unsupported encoding", ex);
            }
        }
    };
    public static VncFunction str_decode_url = new VncFunction("str/decode-url", (VncVal)VncFunction.meta().arglists("(str/decode-url s)").doc("URL decode.").examples("(str/decode-url \"The+string+%C3%BC%40foo-bar\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/decode-url", args, 1);
            try {
                VncVal arg = args.first();
                if (arg == Constants.Nil) {
                    return Constants.Nil;
                }
                String s = Coerce.toVncString(arg).getValue();
                return new VncString(URLDecoder.decode(s, "UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("Unsupported encoding", ex);
            }
        }
    };
    public static VncFunction str_escape_html = new VncFunction("str/escape-html", (VncVal)VncFunction.meta().arglists("(str/escape-html s)").doc("HTML escape. Escapes &, <, >, \", ', and the non blocking space U+00A0").examples("(str/escape-html \"1 2 3 & < > \\\" ' \\u00A0\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/escape-html", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(arg).getValue();
            return new VncString(StringFunctions.replace(s, HTML_ESCAPES));
        }
    };
    public static VncFunction str_escape_xml = new VncFunction("str/escape-xml", (VncVal)VncFunction.meta().arglists("(str/escape-xml s)").doc("XML escape. Escapes &, <, >, \", '").examples("(str/escape-xml \"1 2 3 & < > \\\" '\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/escape-xml", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return Constants.Nil;
            }
            String s = Coerce.toVncString(arg).getValue();
            return new VncString(StringFunctions.replace(s, XML_ESCAPES));
        }
    };
    public static VncFunction str_valid_email_addr_Q = new VncFunction("str/valid-email-addr?", (VncVal)VncFunction.meta().arglists("(str/valid-email-addr? e)").doc("Returns true if e is a valid email address according to RFC5322, else returns false").examples("(str/valid-email-addr? \"user@domain.com\")", "(str/valid-email-addr? \"user@domain.co.in\")", "(str/valid-email-addr? \"user.name@domain.com\")", "(str/valid-email-addr? \"user_name@domain.com\")", "(str/valid-email-addr? \"username@yahoo.corporate.in\")").build()){
        private static final long serialVersionUID = -1848883965231344442L;

        @Override
        public VncVal apply(VncList args) {
            FunctionsUtil.assertArity("str/valid-email-addr?", args, 1);
            VncVal arg = args.first();
            if (arg == Constants.Nil) {
                return VncBoolean.False;
            }
            String s = Coerce.toVncString(arg).getValue();
            return VncBoolean.of(s.matches(StringFunctions.EMAIL_REGEX));
        }
    };
    private static final List<Tuple2<String, String>> XML_ESCAPES = Arrays.asList(Tuple2.of("&", "&amp;"), Tuple2.of("<", "&lt;"), Tuple2.of(">", "&gt;"), Tuple2.of("\"", "&quot;"), Tuple2.of("'", "&apos;"));
    private static final List<Tuple2<String, String>> HTML_ESCAPES = Arrays.asList(Tuple2.of("&", "&amp;"), Tuple2.of("<", "&lt;"), Tuple2.of(">", "&gt;"), Tuple2.of("\"", "&quot;"), Tuple2.of("'", "&apos;"), Tuple2.of("\u00a0", "&nbsp;"));
    private static final String EMAIL_REGEX = "^[\\w!#$%&\u2019*+/=?`{|}~^-]+(?:\\.[\\w!#$%&\u2019*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    public static Map<VncVal, VncVal> ns = new VncHashMap.Builder().add(str_blank_Q).add(str_starts_with_Q).add(str_ends_with_Q).add(str_contains_Q).add(str_equals_ignore_case_Q).add(str_char_Q).add(str_digit_Q).add(str_letter_Q).add(str_linefeed_Q).add(str_whitespace_Q).add(str_upper_case_Q).add(str_lower_case_Q).add(str_trim).add(str_trim_to_nil).add(str_index_of).add(str_last_index_of).add(str_replace_first).add(str_replace_last).add(str_replace_all).add(str_reverse).add(str_lower_case).add(str_upper_case).add(str_join).add(str_subs).add(str_chars).add(str_split).add(str_split_lines).add(str_cr_lf).add(str_format).add(str_rest).add(str_quote).add(str_double_quote).add(str_double_unquote).add(str_quoted_Q).add(str_double_quoted_Q).add(str_truncate).add(str_expand).add(str_strip_start).add(str_strip_end).add(str_strip_indent).add(str_strip_margin).add(str_repeat).add(str_lorem_ipsum).add(str_hex_to_bytebuf).add(str_bytebuf_to_hex).add(str_format_bytebuf).add(str_encode_base64).add(str_decode_base64).add(str_encode_url).add(str_decode_url).add(str_escape_html).add(str_escape_xml).add(str_valid_email_addr_Q).toMap();

    private static List<Object> toJavaObjects(VncList list) {
        return list.getList().stream().map(v -> v.convertToJavaObject()).collect(Collectors.toList());
    }

    private static String replace(String str, List<Tuple2<String, String>> replacements) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String s = str;
        for (Tuple2<String, String> r : replacements) {
            s = s.replace((CharSequence)r._1, (CharSequence)r._2);
        }
        return s;
    }

    private static Locale toLocale(VncVal locale) {
        if (Types.isVncJavaObject(locale, Locale.class)) {
            return (Locale)((VncJavaObject)locale).getDelegate();
        }
        if (Types.isVncSequence(locale)) {
            VncSequence localeSeq = (VncSequence)locale;
            switch (localeSeq.size()) {
                case 0: {
                    return Locale.getDefault();
                }
                case 1: {
                    return new Locale(Coerce.toVncString(localeSeq.first()).getValue());
                }
                case 2: {
                    return new Locale(Coerce.toVncString(localeSeq.first()).getValue(), Coerce.toVncString(localeSeq.second()).getValue());
                }
            }
            return new Locale(Coerce.toVncString(localeSeq.first()).getValue(), Coerce.toVncString(localeSeq.second()).getValue(), Coerce.toVncString(localeSeq.third()).getValue());
        }
        return null;
    }
}

