/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.reader;

import com.github.jlangch.venice.EofException;
import com.github.jlangch.venice.ParseError;
import com.github.jlangch.venice.impl.reader.CharacterReader;
import com.github.jlangch.venice.impl.reader.Token;
import com.github.jlangch.venice.impl.reader.TokenType;
import com.github.jlangch.venice.impl.util.ErrorMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    private static final int LF = 10;
    private static final int CR = 13;
    private static final int EOF = -1;
    private final CharacterReader reader;
    private final String fileName;
    private final boolean skipWhitespaces;
    private final boolean errorOnUnbalancedStringQuotes;
    private final boolean errorOnIncompleteEscapeChars;
    private final List<Token> tokens = new ArrayList<Token>();

    private Tokenizer(String text, String fileName) {
        this(text, fileName, true, true, true);
    }

    private Tokenizer(String text, String fileName, boolean skipWhitespaces, boolean errorOnUnbalancedStringQuotes, boolean errorOnIncompleteEscapeChars) {
        this.reader = new CharacterReader(text);
        this.fileName = fileName;
        this.skipWhitespaces = skipWhitespaces;
        this.errorOnUnbalancedStringQuotes = errorOnUnbalancedStringQuotes;
        this.errorOnIncompleteEscapeChars = errorOnIncompleteEscapeChars;
    }

    public static List<Token> tokenize(String text, String fileName) {
        return new Tokenizer(text, fileName, true, true, true).tokenize();
    }

    public static List<Token> tokenize(String text, String fileName, boolean skipWhitespaces, boolean errorOnUnbalancedStringQuotes, boolean errorOnIncompleteEscapeChars) {
        return new Tokenizer(text, fileName, skipWhitespaces, errorOnUnbalancedStringQuotes, errorOnIncompleteEscapeChars).tokenize();
    }

    private List<Token> tokenize() {
        this.tokens.clear();
        try {
            while (true) {
                int filePos = this.reader.getPos();
                int line = this.reader.getLineNumber();
                int col = this.reader.getColumnNumber();
                int ch = this.reader.peek();
                if (ch != -1) {
                    StringBuilder sb;
                    if (ch == 10) {
                        this.addToken(TokenType.WHITESPACES, "\n", filePos, line, col);
                        this.reader.consume();
                        continue;
                    }
                    if (this.isWhitespace((char)ch)) {
                        sb = new StringBuilder();
                        sb.append((char)ch);
                        this.reader.consume();
                        while (this.isWhitespace((char)this.reader.peek())) {
                            sb.append((char)this.reader.peek());
                            this.reader.consume();
                        }
                        this.addToken(TokenType.WHITESPACES, sb.toString(), filePos, line, col);
                        continue;
                    }
                    if (ch == 126) {
                        this.reader.consume();
                        int chNext = this.reader.peek();
                        if (chNext == 64) {
                            this.addToken(TokenType.UNQUOTE_SPLICE, "~@", filePos, line, col);
                            this.reader.consume();
                            continue;
                        }
                        this.addToken(TokenType.SPECIAL_CHAR, "~", filePos, line, col);
                        continue;
                    }
                    if (this.isSpecialChar((char)ch)) {
                        this.reader.consume();
                        this.addToken(TokenType.SPECIAL_CHAR, String.valueOf((char)ch), filePos, line, col);
                        continue;
                    }
                    if (ch == 34) {
                        this.reader.consume();
                        int chNext = this.reader.peek();
                        if (chNext != 34) {
                            String s = this.readSingleQuotedString(filePos, line, col);
                            this.addToken(TokenType.STRING, s, filePos, line, col);
                            continue;
                        }
                        this.reader.consume();
                        int chNextNext = this.reader.peek();
                        if (chNextNext != 34) {
                            this.addToken(TokenType.STRING, "\"\"", filePos, line, col);
                            continue;
                        }
                        this.reader.consume();
                        this.addToken(TokenType.STRING_BLOCK, this.readTripleQuotedString(filePos, line, col), filePos, line, col);
                        continue;
                    }
                    if (ch == 59) {
                        this.reader.consume();
                        sb = new StringBuilder();
                        sb.append(';');
                        while (10 != this.reader.peek() && -1 != this.reader.peek()) {
                            sb.append((char)this.reader.peek());
                            this.reader.consume();
                        }
                        this.addToken(TokenType.COMMENT, sb.toString(), filePos, line, col);
                        continue;
                    }
                    if (ch == 44) {
                        this.addToken(TokenType.WHITESPACES, ",", filePos, line, col);
                        this.reader.consume();
                        continue;
                    }
                    this.reader.consume();
                    sb = new StringBuilder();
                    sb.append((char)ch);
                    ch = this.reader.peek();
                    while (ch != -1 && !this.isWhitespace((char)ch) && ch != 44 && ch != 59 && ch != 34 && !this.isSpecialChar((char)ch)) {
                        sb.append((char)ch);
                        this.reader.consume();
                        ch = this.reader.peek();
                    }
                    this.addToken(TokenType.ANY, sb.toString(), filePos, line, col);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new ParseError("Parse error (tokenizer phase) while reading from input", ex);
        }
        return this.tokens;
    }

    private String readSingleQuotedString(int filePosStart, int lineStart, int colStart) throws IOException {
        StringBuilder sb = new StringBuilder("\"");
        while (true) {
            int ch;
            if ((ch = this.reader.peek()) == -1) {
                if (!this.errorOnUnbalancedStringQuotes) break;
                throw new ParseError(this.formatParseError(new Token(TokenType.STRING, sb.toString(), this.fileName, filePosStart, lineStart, colStart), "Expected closing \" for single quoted string but got EOF", new Object[0]));
            }
            if (ch == 34) {
                this.reader.consume();
                sb.append((char)ch);
                break;
            }
            if (ch == 92) {
                int filePos = this.reader.getPos();
                int line = this.reader.getLineNumber();
                int col = this.reader.getColumnNumber();
                this.reader.consume();
                sb.append((char)ch);
                this.readStringEscapeChar(TokenType.STRING, filePos, line, col, sb);
                continue;
            }
            this.reader.consume();
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private String readTripleQuotedString(int filePosStart, int lineStart, int colStart) throws IOException {
        StringBuilder sb = new StringBuilder("\"\"\"");
        while (true) {
            int ch;
            if ((ch = this.reader.peek()) == -1) {
                if (!this.errorOnUnbalancedStringQuotes) break;
                throw new ParseError(this.formatParseError(new Token(TokenType.STRING_BLOCK, sb.toString(), this.fileName, filePosStart, lineStart, colStart), "Expected closing \" for triple quoted string but got EOF", new Object[0]));
            }
            if (ch == 34) {
                this.reader.consume();
                sb.append('\"');
                int chNext = this.reader.peek();
                if (chNext != 34) continue;
                this.reader.consume();
                sb.append('\"');
                int chNextNext = this.reader.peek();
                if (chNextNext != 34) continue;
                this.reader.consume();
                sb.append('\"');
                break;
            }
            if (ch == 92) {
                int filePos = this.reader.getPos();
                int line = this.reader.getLineNumber();
                int col = this.reader.getColumnNumber();
                this.reader.consume();
                int chNext = this.reader.peek();
                if (chNext == 10 || chNext == 13) {
                    this.reader.consume();
                    sb.append((char)ch);
                    sb.append((char)chNext);
                    continue;
                }
                sb.append((char)ch);
                this.readStringEscapeChar(TokenType.STRING, filePos, line, col, sb);
                continue;
            }
            this.reader.consume();
            sb.append((char)ch);
        }
        return sb.toString();
    }

    private boolean isSpecialChar(char ch) {
        switch (ch) {
            case '\'': 
            case '(': 
            case ')': 
            case '@': 
            case '[': 
            case ']': 
            case '^': 
            case '`': 
            case '{': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private boolean isWhitespace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private void addToken(TokenType type, String token, int filePos, int line, int col) {
        if (!this.skipWhitespaces || type != TokenType.WHITESPACES && type != TokenType.COMMENT) {
            this.tokens.add(new Token(type, token, this.fileName, filePos, line, col));
        }
    }

    private void readStringEscapeChar(TokenType type, int filePos, int line, int col, StringBuilder sb) throws IOException {
        int ch = this.reader.peek();
        this.reader.consume();
        if (ch == 10 || ch == 13) {
            if (this.errorOnIncompleteEscapeChars) {
                throw new ParseError(this.formatParseError(new Token(type, "\\", this.fileName, filePos, line, col), "Expected escaped char in a string but got EOL", new Object[0]));
            }
        } else if (ch == -1) {
            if (this.errorOnIncompleteEscapeChars) {
                throw new EofException(this.formatParseError(new Token(type, "\\", this.fileName, filePos, line, col), "Expected escaped char in a string but got EOF", new Object[0]));
            }
        } else {
            sb.append((char)ch);
        }
    }

    private String formatParseError(Token token, String format, Object ... args) {
        return String.format(format, args) + ". " + ErrorMessage.buildErrLocation(token);
    }
}

