/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.specialforms;

import com.github.jlangch.venice.VncException;
import com.github.jlangch.venice.impl.CustomWrappableTypes;
import com.github.jlangch.venice.impl.Env;
import com.github.jlangch.venice.impl.Namespaces;
import com.github.jlangch.venice.impl.ReadEvalFunction;
import com.github.jlangch.venice.impl.Var;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncHashSet;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.collections.VncMap;
import com.github.jlangch.venice.impl.types.collections.VncOrderedMap;
import com.github.jlangch.venice.impl.types.collections.VncVector;
import com.github.jlangch.venice.impl.types.custom.VncChoiceTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomType;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeDef;
import com.github.jlangch.venice.impl.types.custom.VncCustomTypeFieldDef;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Coerce;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class DefTypeForm {
    public static VncVal defineCustomType(VncKeyword type, VncVector fields, VncFunction validationFn, ReadEvalFunction interpreter, Env env) {
        if (fields.isEmpty() || fields.size() % 2 != 0) {
            throw new VncException("deftype invalid field definition.");
        }
        ArrayList<VncCustomTypeFieldDef> fieldDefs = new ArrayList<VncCustomTypeFieldDef>();
        List<VncVal> fieldItems = fields.getList();
        for (int ii = 0; ii < fieldItems.size() / 2; ++ii) {
            fieldDefs.add(new VncCustomTypeFieldDef(new VncKeyword(Coerce.toVncSymbol(fieldItems.get(ii * 2)).getName()), DefTypeForm.qualifyBaseType(Coerce.toVncKeyword(fieldItems.get(ii * 2 + 1)), env), new VncInteger(ii)));
        }
        VncKeyword qualifiedType = DefTypeForm.qualifyMainTypeWithCurrentNS(type, "deftype");
        DefTypeForm.validateCustomTypeName(qualifiedType);
        if (DefTypeForm.isCustomType(qualifiedType, env)) {
            throw new VncException(String.format("deftype: the type %s already exists.", qualifiedType.toString()));
        }
        VncCustomTypeDef typeDef = new VncCustomTypeDef(qualifiedType, fieldDefs, validationFn);
        env.setGlobal(new Var(qualifiedType.toSymbol(), typeDef));
        DefTypeForm.createBuildAndCheckFn(qualifiedType.toSymbol().getName(), fieldDefs.size(), interpreter, env);
        return qualifiedType;
    }

    public static VncVal defineCustomWrapperType(VncKeyword type, VncKeyword baseType, VncFunction validationFn, ReadEvalFunction interpreter, Env env, CustomWrappableTypes wrappableTypes) {
        VncKeyword qualifiedType = DefTypeForm.qualifyMainTypeWithCurrentNS(type, "deftype-of");
        DefTypeForm.validateCustomTypeName(qualifiedType);
        VncKeyword qualifiedBaseType = DefTypeForm.qualifyBaseType(baseType, env);
        if (!wrappableTypes.isWrappable(qualifiedBaseType)) {
            throw new VncException(String.format("deftype-of: the type %s can not be wrapped.", baseType.toString()));
        }
        if (DefTypeForm.isCustomType(qualifiedType, env)) {
            throw new VncException(String.format("deftype: the type %s already exists.", qualifiedType.toString()));
        }
        VncWrappingTypeDef typeDef = new VncWrappingTypeDef(qualifiedType, qualifiedBaseType, validationFn);
        env.setGlobal(new Var(qualifiedType.toSymbol(), typeDef));
        DefTypeForm.createBuildAndCheckFn(qualifiedType.toSymbol().getName(), 1, interpreter, env);
        return qualifiedType;
    }

    public static VncVal defineCustomChoiceType(VncKeyword type, VncList choiceVals, ReadEvalFunction interpreter, Env env) {
        VncKeyword qualifiedType = DefTypeForm.qualifyMainTypeWithCurrentNS(type, "deftype-or");
        DefTypeForm.validateCustomTypeName(qualifiedType);
        if (choiceVals.isEmpty()) {
            throw new VncException("There is at least one value required for a choice type.");
        }
        if (DefTypeForm.isCustomType(qualifiedType, env)) {
            throw new VncException(String.format("deftype-or: the type %s already exists.", qualifiedType.toString()));
        }
        HashSet<VncKeyword> choiceTypes = new HashSet<VncKeyword>();
        HashSet<VncVal> choiceValues = new HashSet<VncVal>();
        for (VncVal v : choiceVals.getList()) {
            if (Types.isVncKeyword(v)) {
                VncKeyword k = (VncKeyword)v;
                if (k.hasNamespace()) {
                    if (DefTypeForm.isCustomType(k, env)) {
                        choiceTypes.add(k);
                        continue;
                    }
                    throw new VncException(String.format("The type %s is not defined.", k.toString()));
                }
                VncKeyword qualified = DefTypeForm.qualifyBaseType(k, env);
                if (DefTypeForm.isCustomType(qualified, env)) {
                    choiceTypes.add(qualified);
                    continue;
                }
                if (Types.isCorePrimitiveType(qualified)) {
                    choiceTypes.add(qualified);
                    continue;
                }
                choiceValues.add(v);
                continue;
            }
            choiceValues.add(v);
        }
        VncChoiceTypeDef typeDef = new VncChoiceTypeDef(qualifiedType, VncHashSet.ofAll(choiceTypes), VncHashSet.ofAll(choiceValues));
        env.setGlobal(new Var(qualifiedType.toSymbol(), typeDef));
        DefTypeForm.createBuildAndCheckFn(qualifiedType.toSymbol().getName(), 1, interpreter, env);
        return qualifiedType;
    }

    public static boolean isCustomType(VncKeyword typeDef, Env env) {
        return env.getGlobalOrNull(typeDef.toSymbol()) != null;
    }

    public static boolean isCustomType(VncVal val, Env env) {
        if (Types.isVncKeyword(val)) {
            VncKeyword type = (VncKeyword)val;
            VncKeyword qualifiedType = type.hasNamespace() ? type : type.withNamespace(Namespaces.getCurrentNS());
            return env.getGlobalOrNull(qualifiedType.toSymbol()) != null;
        }
        if (Types.isVncCustomType(val)) {
            return true;
        }
        if (val.isWrapped()) {
            VncKeyword type = val.getWrappingTypeDef().getType();
            return env.getGlobalOrNull(type.toSymbol()) != null;
        }
        return false;
    }

    public static VncVal createType(List<VncVal> args, Env env) {
        VncKeyword type = Coerce.toVncKeyword(args.get(0));
        VncKeyword qualifiedType = type.hasNamespace() ? type : type.withNamespace(Namespaces.getCurrentNS());
        VncVal typeDef = env.getGlobalOrNull(qualifiedType.toSymbol());
        if (typeDef == null) {
            throw new VncException(String.format("The custom type %s is not defined.", qualifiedType.toString()));
        }
        if (typeDef instanceof VncCustomTypeDef) {
            List<VncVal> typeArgs = args.subList(1, args.size());
            return DefTypeForm.createCustomType((VncCustomTypeDef)typeDef, typeArgs);
        }
        if (typeDef instanceof VncWrappingTypeDef) {
            return DefTypeForm.createWrappedType((VncWrappingTypeDef)typeDef, args.get(1));
        }
        if (typeDef instanceof VncChoiceTypeDef) {
            return DefTypeForm.createChoiceType((VncChoiceTypeDef)typeDef, args.get(1));
        }
        throw new VncException(String.format("The type %s is not a custom type.", qualifiedType.toString()));
    }

    public static VncCustomType createCustomType(VncCustomTypeDef typeDef, List<VncVal> typeArgs) {
        if (typeDef.count() != typeArgs.size()) {
            throw new VncException(String.format("The custom type %s requires %d args. %d have been passed", typeDef.getType().toString(), typeDef.count(), typeArgs.size()));
        }
        LinkedHashMap<VncVal, VncVal> fields = new LinkedHashMap<VncVal, VncVal>();
        for (int ii = 0; ii < typeDef.count(); ++ii) {
            VncCustomTypeFieldDef fieldDef = typeDef.getFieldDef(ii);
            VncVal arg = typeArgs.get(ii);
            DefTypeForm.validateTypeCompatibility(typeDef.getType(), fieldDef, arg);
            fields.put(fieldDef.getName(), arg);
        }
        VncOrderedMap data = new VncOrderedMap(fields, (VncVal)Constants.Nil);
        typeDef.validate(data);
        return new VncCustomType(typeDef, data, Constants.Nil);
    }

    public static VncCustomType createCustomType(VncCustomTypeDef typeDef, VncMap fields) {
        if (typeDef.count() != fields.size()) {
            throw new VncException(String.format("The custom type %s requires %d args. %d have been passed", typeDef.getType().toString(), typeDef.count(), fields.size()));
        }
        LinkedHashMap<VncVal, VncVal> fieldsNew = new LinkedHashMap<VncVal, VncVal>();
        for (int ii = 0; ii < typeDef.count(); ++ii) {
            VncCustomTypeFieldDef fieldDef = typeDef.getFieldDef(ii);
            VncVal arg = fields.get(fieldDef.getName());
            DefTypeForm.validateTypeCompatibility(typeDef.getType(), fieldDef, arg);
            fieldsNew.put(fieldDef.getName(), arg);
        }
        VncOrderedMap data = new VncOrderedMap(fieldsNew, (VncVal)Constants.Nil);
        typeDef.validate(data);
        return new VncCustomType(typeDef, data, Constants.Nil);
    }

    public static VncVal createWrappedType(VncWrappingTypeDef typeDef, VncVal val) {
        DefTypeForm.validateTypeCompatibility(typeDef, val);
        typeDef.validate(val);
        return val.wrap(typeDef, val.getMeta());
    }

    public static VncVal createChoiceType(VncChoiceTypeDef typeDef, VncVal val) {
        VncKeyword type;
        if (typeDef.valuesOnly().contains(val)) {
            if (val == Constants.Nil) {
                return val;
            }
            return val.wrap(new VncWrappingTypeDef(typeDef.getType(), val.getType()), val.getMeta());
        }
        VncKeyword vncKeyword = type = val.isWrapped() ? val.getWrappingTypeDef().getType() : val.getType();
        if (typeDef.typesOnly().contains(type)) {
            return val.wrap(new VncWrappingTypeDef(typeDef.getType(), val.getType()), val.getMeta());
        }
        if (Types.isCorePrimitiveType(val)) {
            throw new VncException(String.format("The choice type %s is not compatible with the value %s", typeDef.getType().toString(), val.toString(true)));
        }
        throw new VncException(String.format("The choice type %s is not compatible with a value of type %s", typeDef.getType().toString(), type.toString()));
    }

    private static void validateTypeCompatibility(VncKeyword type, VncCustomTypeFieldDef fieldDef, VncVal arg) {
        if (Types.ANY.equals(fieldDef.getType())) {
            return;
        }
        VncKeyword argType = Types.getType(arg);
        if (Types.isInstanceOf(fieldDef.getType(), arg)) {
            return;
        }
        throw new VncException(String.format("The type %s requires arg %d of type %s instead of the passed %s", type.toString(), fieldDef.getIndex().getValue() + 1, fieldDef.getType().toString(), argType.toString()));
    }

    private static void validateTypeCompatibility(VncWrappingTypeDef typeDef, VncVal arg) {
        if (Types.ANY.equals(typeDef.getBaseType())) {
            return;
        }
        if (Types.isInstanceOf(typeDef.getBaseType(), arg)) {
            return;
        }
        throw new VncException(String.format("The type %s requires an arg of type %s instead of the passed %s", typeDef.getType().toString(), typeDef.getBaseType().toString(), arg.getType().toString()));
    }

    private static VncKeyword qualifyBaseType(VncKeyword type, Env env) {
        if (type.hasNamespace()) {
            return type;
        }
        VncKeyword type_ = type.withNamespace(Namespaces.getCurrentNS());
        if (DefTypeForm.isCustomType(type_, env)) {
            return type_;
        }
        return type.withNamespace(Namespaces.NS_CORE);
    }

    public static VncKeyword qualifyMainTypeWithCurrentNS(VncKeyword type, String fnName) {
        if (type.hasNamespace()) {
            String ns = type.getNamespace();
            if (!ns.equals(Namespaces.getCurrentNS().getName())) {
                throw new VncException(String.format("function %s: Invalid use of namespace. The type '%s' can only be defined for the current namespace '%s'.", fnName, type.getSimpleName(), Namespaces.getCurrentNS().toString()));
            }
            return type;
        }
        return type.withNamespace(Namespaces.getCurrentNS());
    }

    private static void createBuildAndCheckFn(String qualifiedTypeName, int builderNumArgs, ReadEvalFunction interpreter, Env env) {
        String typeBuildFn = DefTypeForm.createBuildTypeFn(qualifiedTypeName, builderNumArgs);
        String typeCheckFn = DefTypeForm.createCheckTypeFn(qualifiedTypeName);
        interpreter.eval(typeBuildFn, "custom-types", env);
        interpreter.eval(typeCheckFn, "custom-types", env);
    }

    private static String createBuildTypeFn(String qualifiedTypeName, int builderNumArgs) {
        StringBuilder args = new StringBuilder();
        args.append("x0");
        for (int ii = 1; ii < builderNumArgs; ++ii) {
            args.append(" ").append("x").append(ii);
        }
        return String.format("(defn %s. [%s] (.: :%s %s))", qualifiedTypeName, args, qualifiedTypeName, args);
    }

    private static String createCheckTypeFn(String qualifiedTypeName) {
        return String.format("(defn %s? [v] (= :%s (type v)))", qualifiedTypeName, qualifiedTypeName);
    }

    private static void validateCustomTypeName(VncKeyword type) {
        String name = type.getValue();
        if (name.endsWith(".")) {
            throw new VncException(String.format("A custom type %s name must not end with '.'.", name));
        }
    }
}

