/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.List;

public class VncBoolean
extends VncVal {
    public static final VncBoolean True = new VncBoolean(true);
    public static final VncBoolean False = new VncBoolean(false);
    public static final VncKeyword TYPE = new VncKeyword(":core/boolean");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Boolean value;

    private VncBoolean(Boolean v) {
        this(v, null);
    }

    private VncBoolean(Boolean v, VncWrappingTypeDef wrappingTypeDef) {
        super(wrappingTypeDef, Constants.Nil);
        this.value = v;
    }

    public static VncBoolean of(boolean bool) {
        return bool ? True : False;
    }

    public static boolean isTrue(VncVal val) {
        return val instanceof VncBoolean && ((VncBoolean)val).getValue() == Boolean.TRUE;
    }

    public static boolean isFalse(VncVal val) {
        return val instanceof VncBoolean && ((VncBoolean)val).getValue() == Boolean.FALSE;
    }

    @Override
    public VncBoolean withMeta(VncVal meta) {
        return this;
    }

    @Override
    public VncBoolean wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncBoolean(this.value, wrappingTypeDef);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.BOOLEAN;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncBoolean(o)) {
            return this.value.compareTo(((VncBoolean)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncBoolean)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }
}

