/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncInteger;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.List;

public class VncDouble
extends VncNumber {
    public static final VncKeyword TYPE = new VncKeyword(":core/double");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Double value;

    public VncDouble(Double v) {
        this(v, null, Constants.Nil);
    }

    public VncDouble(Float v) {
        this(v.doubleValue(), null, Constants.Nil);
    }

    public VncDouble(Long v) {
        this(v.doubleValue(), null, Constants.Nil);
    }

    public VncDouble(Integer v) {
        this(v.doubleValue(), null, Constants.Nil);
    }

    public VncDouble(Double v, VncVal meta) {
        this(v, null, meta);
    }

    public VncDouble(Double v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    @Override
    public VncDouble withMeta(VncVal meta) {
        return new VncDouble(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncDouble wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncDouble(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public VncDouble negate() {
        return new VncDouble(this.value * -1.0);
    }

    public Double getValue() {
        return this.value;
    }

    public Float getFloatValue() {
        return Float.valueOf(this.value.floatValue());
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.DOUBLE;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(((VncDouble)o).getValue());
        }
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(Numeric.intToDouble((VncInteger)o).getValue());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(Numeric.longToDouble((VncLong)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToDouble((VncBigDecimal)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncDouble)obj).value);
    }

    public String toString() {
        return this.value.toString();
    }
}

