/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types;

import com.github.jlangch.venice.impl.functions.Numeric;
import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.TypeRank;
import com.github.jlangch.venice.impl.types.VncBigDecimal;
import com.github.jlangch.venice.impl.types.VncDouble;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncLong;
import com.github.jlangch.venice.impl.types.VncNumber;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.custom.VncWrappingTypeDef;
import com.github.jlangch.venice.impl.types.util.Types;
import java.util.Arrays;
import java.util.List;

public class VncInteger
extends VncNumber {
    public static final VncKeyword TYPE = new VncKeyword(":core/integer");
    private static final long serialVersionUID = -1848883965231344442L;
    private final Integer value;

    public VncInteger(Integer v) {
        this(v, null, Constants.Nil);
    }

    public VncInteger(Long v) {
        this(v.intValue(), null, Constants.Nil);
    }

    public VncInteger(Integer v, VncVal meta) {
        this(v, null, meta);
    }

    public VncInteger(Integer v, VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        super(wrappingTypeDef, meta);
        this.value = v;
    }

    @Override
    public VncInteger withMeta(VncVal meta) {
        return new VncInteger(this.value, this.getWrappingTypeDef(), meta);
    }

    @Override
    public VncInteger wrap(VncWrappingTypeDef wrappingTypeDef, VncVal meta) {
        return new VncInteger(this.value, wrappingTypeDef, meta);
    }

    @Override
    public VncKeyword getType() {
        return this.isWrapped() ? this.getWrappingTypeDef().getType() : TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return this.isWrapped() ? TYPE : VncVal.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return this.isWrapped() ? Arrays.asList(TYPE, VncVal.TYPE) : Arrays.asList(VncVal.TYPE);
    }

    public VncInteger negate() {
        return new VncInteger(this.value * -1);
    }

    public Integer getValue() {
        return this.value;
    }

    public Long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public TypeRank typeRank() {
        return TypeRank.INTEGER;
    }

    @Override
    public Object convertToJavaObject() {
        return this.value;
    }

    @Override
    public int compareTo(VncVal o) {
        if (Types.isVncInteger(o)) {
            return this.value.compareTo(((VncInteger)o).getValue());
        }
        if (Types.isVncLong(o)) {
            return this.value.compareTo(((VncLong)o).getIntValue());
        }
        if (Types.isVncDouble(o)) {
            return this.value.compareTo(Numeric.doubleToInt((VncDouble)o).getValue());
        }
        if (Types.isVncBigDecimal(o)) {
            return this.value.compareTo(Numeric.decimalToInt((VncBigDecimal)o).getValue());
        }
        if (o == Constants.Nil) {
            return 1;
        }
        return super.compareTo(o);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((VncInteger)obj).value);
    }

    public String toString() {
        return this.value.toString() + "I";
    }
}

