/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.types.collections;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncKeyword;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public abstract class VncSequence
extends VncCollection {
    public static final VncKeyword TYPE = new VncKeyword(":core/sequence");
    private static final long serialVersionUID = -1848883965231344442L;

    public VncSequence(VncVal meta) {
        super(meta);
    }

    @Override
    public abstract VncSequence emptyWithMeta();

    public abstract VncSequence withVariadicValues(VncVal ... var1);

    public abstract VncSequence withValues(List<? extends VncVal> var1);

    public abstract VncSequence withValues(List<? extends VncVal> var1, VncVal var2);

    @Override
    public abstract VncSequence withMeta(VncVal var1);

    @Override
    public VncKeyword getType() {
        return TYPE;
    }

    @Override
    public VncKeyword getSupertype() {
        return VncCollection.TYPE;
    }

    @Override
    public List<VncKeyword> getAllSupertypes() {
        return Arrays.asList(VncCollection.TYPE, VncVal.TYPE);
    }

    public abstract Iterator<VncVal> iterator();

    public abstract List<VncVal> getList();

    public abstract VncVal nth(int var1);

    public abstract VncVal nthOrDefault(int var1, VncVal var2);

    public VncVal first() {
        return this.nthOrDefault(0, Constants.Nil);
    }

    public VncVal second() {
        return this.nthOrDefault(1, Constants.Nil);
    }

    public VncVal third() {
        return this.nthOrDefault(2, Constants.Nil);
    }

    public VncVal fourth() {
        return this.nthOrDefault(3, Constants.Nil);
    }

    public abstract VncVal last();

    public abstract VncSequence rest();

    public abstract VncSequence butlast();

    public abstract VncSequence slice(int var1, int var2);

    public abstract VncSequence slice(int var1);

    public abstract VncSequence setAt(int var1, VncVal var2);

    public abstract VncSequence addAtStart(VncVal var1);

    public abstract VncSequence addAllAtStart(VncSequence var1);

    public abstract VncSequence addAtEnd(VncVal var1);

    public abstract VncSequence addAllAtEnd(VncSequence var1);

    public abstract VncSequence removeAt(int var1);

    public abstract void forEach(Consumer<? super VncVal> var1);

    public Stream<VncVal> stream() {
        return this.getList().stream();
    }
}

