/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.collections.VncList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CommandLineArgs {
    private final String[] args;
    private Map<String, Integer> switchIndexes = new HashMap<String, Integer>();
    private Set<Integer> takenIndexes = new HashSet<Integer>();

    public CommandLineArgs(String[] args) {
        this.args = args;
        this.parse(args);
    }

    public static CommandLineArgs of(String ... args) {
        return new CommandLineArgs(args);
    }

    public void parse(String[] arguments) {
        this.switchIndexes.clear();
        this.takenIndexes.clear();
        for (int ii = 0; ii < this.args.length; ++ii) {
            if (!this.args[ii].startsWith("-")) continue;
            this.switchIndexes.put(this.args[ii], ii);
            this.takenIndexes.add(ii);
        }
    }

    public String[] args() {
        return this.args;
    }

    public VncList argsAsList() {
        return VncList.ofList(Arrays.asList(this.args).stream().map(s -> new VncString((String)s)).collect(Collectors.toList()));
    }

    public String arg(int index) {
        return this.args[index];
    }

    public boolean switchPresent(String switchName) {
        return this.switchIndexes.containsKey(switchName);
    }

    public String switchValue(String switchName) {
        return this.switchValue(switchName, null);
    }

    public String switchValue(String switchName, String defaultValue) {
        if (!this.switchIndexes.containsKey(switchName)) {
            return defaultValue;
        }
        int switchIndex = this.switchIndexes.get(switchName);
        if (switchIndex + 1 < this.args.length) {
            this.takenIndexes.add(switchIndex + 1);
            return this.args[switchIndex + 1];
        }
        return defaultValue;
    }

    public Long switchLongValue(String switchName) {
        return this.switchLongValue(switchName, null);
    }

    public Long switchLongValue(String switchName, Long defaultValue) {
        String switchValue = this.switchValue(switchName, null);
        return switchValue == null ? defaultValue : Long.parseLong(switchValue);
    }

    public Double switchDoubleValue(String switchName) {
        return this.switchDoubleValue(switchName, null);
    }

    public Double switchDoubleValue(String switchName, Double defaultValue) {
        String switchValue = this.switchValue(switchName, null);
        return switchValue == null ? defaultValue : Double.parseDouble(switchValue);
    }

    public String[] switchValues(String switchName) {
        int nextArgIndex;
        if (!this.switchIndexes.containsKey(switchName)) {
            return new String[0];
        }
        int switchIndex = this.switchIndexes.get(switchName);
        for (nextArgIndex = switchIndex + 1; nextArgIndex < this.args.length && !this.args[nextArgIndex].startsWith("-"); ++nextArgIndex) {
            this.takenIndexes.add(nextArgIndex);
        }
        String[] values = new String[nextArgIndex - switchIndex - 1];
        for (int jj = 0; jj < values.length; ++jj) {
            values[jj] = this.args[switchIndex + jj + 1];
        }
        return values;
    }

    public String[] targets() {
        String[] targetArray = new String[this.args.length - this.takenIndexes.size()];
        int targetIndex = 0;
        for (int ii = 0; ii < this.args.length; ++ii) {
            if (this.takenIndexes.contains(ii)) continue;
            targetArray[targetIndex++] = this.args[ii];
        }
        return targetArray;
    }
}

