/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.types.Constants;
import com.github.jlangch.venice.impl.types.VncFunction;
import com.github.jlangch.venice.impl.types.VncString;
import com.github.jlangch.venice.impl.types.VncVal;
import com.github.jlangch.venice.impl.types.collections.VncList;
import com.github.jlangch.venice.impl.types.util.Types;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.util.stream.Collectors;

public class Doc {
    public static VncString getDoc(VncVal val) {
        if (val != null && Types.isVncFunction(val)) {
            VncFunction fn = (VncFunction)val;
            VncList argsList = fn.getArgLists();
            VncList examples = fn.getExamples();
            StringBuilder sb = new StringBuilder();
            sb.append(argsList.getList().stream().map(s -> Doc.toString(s)).collect(Collectors.joining(", ")));
            sb.append("\n\n");
            sb.append(Doc.toString(fn.getDoc()));
            if (!examples.isEmpty()) {
                sb.append("\n\n");
                sb.append("Examples:\n");
                sb.append(examples.getList().stream().map(s -> Doc.toString(s)).map(e -> Doc.indent(e, "    ")).collect(Collectors.joining("\n\n")));
            }
            sb.append("\n");
            return new VncString(sb.toString());
        }
        return new VncString("<no documentation available>");
    }

    private static String indent(String text, String indent) {
        if (StringUtil.isBlank(text)) {
            return text;
        }
        return StringUtil.splitIntoLines(text).stream().map(s -> indent + s).collect(Collectors.joining("\n"));
    }

    private static String toString(VncVal val) {
        return val == Constants.Nil ? "" : ((VncString)val).getValue();
    }
}

