/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util;

import com.github.jlangch.venice.impl.util.IOStreamUtil;
import com.github.jlangch.venice.impl.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Zipper {
    private static final String ziplist_format = "%10s  %6s  %10s  %4s  %16s  %8s  %s";
    private static final String ziplist_format_short = "%10s  %16s %s";
    private static final DateTimeFormatter ziplist_formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    public static final int ZIP_HEADER = 1347093252;
    public static final short GZIP_HEADER = 8075;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zip(byte[] binary, String entryName) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                if ("/".equals(entryName)) {
                    throw new IllegalArgumentException("A 'entryName' must not be \"/\"");
                }
                String name = Zipper.normalizeAndValidateEntryName(entryName);
                if (name.endsWith("/")) {
                    ZipEntry e = new ZipEntry(name);
                    e.setMethod(0);
                    e.setSize(0L);
                    e.setCrc(0L);
                    zos.putNextEntry(e);
                    zos.closeEntry();
                } else {
                    ZipEntry e = new ZipEntry(name);
                    e.setMethod(8);
                    zos.putNextEntry(e);
                    zos.write(binary);
                    zos.closeEntry();
                }
                zos.finish();
                zos.flush();
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zip(Map<String, Object> entries) {
        if (entries == null) {
            throw new IllegalArgumentException("An 'entries' map must not be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                for (Map.Entry<String, Object> entry : entries.entrySet()) {
                    String entryName = Zipper.normalizeAndValidateEntryName(entry.getKey());
                    if (entryName.endsWith("/")) {
                        ZipEntry e = new ZipEntry(entryName);
                        e.setMethod(0);
                        e.setSize(0L);
                        e.setCrc(0L);
                        zos.putNextEntry(e);
                        zos.closeEntry();
                        continue;
                    }
                    if (entry.getValue() == null) continue;
                    byte[] entryBytes = Zipper.slurpBytes(entry.getValue());
                    ZipEntry e = new ZipEntry(entryName);
                    e.setMethod(8);
                    zos.putNextEntry(e);
                    zos.write(entryBytes);
                    zos.closeEntry();
                }
                zos.finish();
                zos.flush();
            }
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipAppend(File zip, Map<String, Object> entries) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (entries == null) {
            throw new IllegalArgumentException("An 'entries' map must not be null");
        }
        try {
            Path zipFile = Paths.get(zip.getPath(), new String[0]);
            try (FileSystem fs = FileSystems.newFileSystem(zipFile, null);){
                for (Map.Entry<String, Object> entry : entries.entrySet()) {
                    Path nf;
                    String entryName = Zipper.normalizeAndValidateEntryName(entry.getKey());
                    if (entry.getValue() == null) continue;
                    byte[] entryBytes = Zipper.slurpBytes(entry.getValue());
                    if (entryName.endsWith("/")) {
                        nf = fs.getPath(entryName, new String[0]);
                        if (!Files.notExists(nf, new LinkOption[0])) continue;
                        Files.createDirectories(nf, new FileAttribute[0]);
                        continue;
                    }
                    nf = fs.getPath(entryName, new String[0]);
                    Path dir = nf.getParent();
                    if (dir != null && Files.notExists(dir, new LinkOption[0])) {
                        Files.createDirectories(dir, new FileAttribute[0]);
                    }
                    Files.deleteIfExists(nf);
                    OutputStream os = Files.newOutputStream(nf, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        os.write(entryBytes);
                        os.flush();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (os == null) continue;
                        if (throwable != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        os.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipRemove(File zip, List<String> entryNames) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (entryNames == null || entryNames.isEmpty()) {
            return;
        }
        try {
            Path zipFile = Paths.get(zip.getPath(), new String[0]);
            try (FileSystem fs = FileSystems.newFileSystem(zipFile, null);){
                for (String entryName : entryNames) {
                    Path nf = fs.getPath(entryName, new String[0]);
                    if (entryName.endsWith("/")) {
                        if (!Files.isDirectory(nf, new LinkOption[0])) continue;
                        try {
                            List<Path> tree = Files.walk(nf, new FileVisitOption[0]).collect(Collectors.toList());
                            Collections.reverse(tree);
                            tree.forEach(p -> Zipper.deletePath(p));
                            continue;
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex.getMessage(), ex);
                        }
                    }
                    if (!Files.isRegularFile(nf, new LinkOption[0])) continue;
                    Files.deleteIfExists(nf);
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(File zip, String entryName) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        try (FileInputStream is = new FileInputStream(zip);){
            byte[] byArray = Zipper.unzip(is, entryName);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(byte[] binary, String entryName) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            byte[] byArray = Zipper.unzip(is, entryName);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzip(InputStream is, String entryName) {
        if (is == null) {
            throw new IllegalArgumentException("A 'is' must not be null");
        }
        String name = Zipper.normalizeAndValidateEntryName(entryName);
        try (ZipInputStream zis = new ZipInputStream(is);){
            byte[] data;
            ZipEntry entry;
            do {
                if ((entry = zis.getNextEntry()) == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                data = Zipper.slurpBytes(zis);
                zis.closeEntry();
            } while (!name.equals(entry.getName()));
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipNthEntry(File zip, int nth) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        try (FileInputStream is = new FileInputStream(zip);){
            byte[] byArray = Zipper.unzipNthEntry(is, nth);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipNthEntry(byte[] binary, int nth) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            byte[] byArray = Zipper.unzipNthEntry(is, nth);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipNthEntry(InputStream is, int nth) {
        if (is == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ZipInputStream zis = new ZipInputStream(is);){
            int entryIdx = 0;
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] data = Zipper.slurpBytes(zis);
                if (entryIdx == nth) {
                    byte[] byArray = data;
                    return byArray;
                }
                zis.closeEntry();
                ++entryIdx;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream unzipToStream(byte[] binary, String entryName) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        String name = Zipper.normalizeAndValidateEntryName(entryName);
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(binary));){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                if (name.equals(entry.getName())) {
                    ZipInputStream zipInputStream = zis;
                    return zipInputStream;
                }
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static InputStream unzipFirstToStream(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        return Zipper.unzipFirstToStream(new ByteArrayInputStream(binary));
    }

    public static InputStream unzipFirstToStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("An 'inputStream' must not be null");
        }
        try {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(inputStream);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                return zis;
            }
            return null;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> unzipAll(File zip) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        try (FileInputStream is = new FileInputStream(zip);){
            Map<String, byte[]> map = Zipper.unzipAll(is);
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> unzipAll(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            Map<String, byte[]> map = Zipper.unzipAll(is);
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, byte[]> unzipAll(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("A 'is' must not be null");
        }
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    HashMap<String, byte[]> hashMap = files;
                    return hashMap;
                }
                byte[] data = Zipper.slurpBytes(zis);
                files.put(entry.getName(), entry.isDirectory() ? null : data);
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gzip(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                gzos.write(binary, 0, binary.length);
                gzos.flush();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipFileOrDir(File zip, List<File> sourceFileOrDirs, FilenameFilter filter) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (sourceFileOrDirs == null || sourceFileOrDirs.isEmpty()) {
            throw new IllegalArgumentException("A 'sourceFileOrDirs' must not be null or empty");
        }
        try (FileOutputStream fos = new FileOutputStream(zip);){
            Zipper.zipFileOrDir(fos, sourceFileOrDirs, filter);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void zipFileOrDir(OutputStream os, List<File> sourceFileOrDirs, FilenameFilter filter) {
        if (os == null) {
            throw new IllegalArgumentException("An 'os' must not be null");
        }
        if (sourceFileOrDirs == null || sourceFileOrDirs.isEmpty()) {
            throw new IllegalArgumentException("A 'sourceFileOrDirs' must not be null or empty");
        }
        try (ZipOutputStream zipOut = new ZipOutputStream(os);){
            for (File f : sourceFileOrDirs) {
                if (f.isDirectory()) {
                    Zipper.zipFile(f, f.getName(), filter, zipOut);
                    continue;
                }
                if (!f.isFile()) continue;
                Zipper.zipFile(f, f.getName(), filter, zipOut);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void listZip(byte[] binary, PrintStream ps, boolean verbose) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            Zipper.listZip(is, ps, verbose);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void listZip(File zip, PrintStream ps, boolean verbose) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        try (FileInputStream fis = new FileInputStream(zip);){
            Zipper.listZip(fis, ps, verbose);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void listZip(InputStream is, PrintStream ps, boolean verbose) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try {
            ZipEntry entry;
            Zipper.printZipListLineHead(ps, verbose);
            Zipper.printZipListLineDelim(ps, verbose);
            long totCount = 0L;
            long totSize = 0L;
            long totCompressedSize = 0L;
            ZipInputStream zis = new ZipInputStream(is);
            while ((entry = zis.getNextEntry()) != null) {
                zis.closeEntry();
                long size = entry.isDirectory() ? 0L : entry.getSize();
                long compressedSize = entry.isDirectory() ? 0L : entry.getCompressedSize();
                ++totCount;
                totSize += Math.max(0L, size);
                totCompressedSize += Math.max(0L, compressedSize);
                Zipper.printZipListLine(ps, verbose, size, entry.getMethod(), compressedSize, entry.getLastModifiedTime(), entry.getCrc(), entry.getName());
            }
            zis.close();
            Zipper.printZipListLineDelim(ps, verbose);
            Zipper.printZipListLine(ps, verbose, totSize, null, totCompressedSize, null, null, totCount == 1L ? "1 file" : String.format("%d files", totCount));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void unzipToDir(File zip, File destDir) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("A 'dir' must not be null");
        }
        try (FileInputStream fis = new FileInputStream(zip);){
            Zipper.unzipToDir(fis, destDir);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void unzipToDir(byte[] zipBinary, File destDir) {
        if (zipBinary == null) {
            throw new IllegalArgumentException("A 'zipBinary' must not be null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("A 'dir' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(zipBinary);){
            Zipper.unzipToDir(is, destDir);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void unzipToDir(InputStream zipIS, File destDir) {
        if (zipIS == null) {
            throw new IllegalArgumentException("A 'zipIS' must not be null");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("A 'dir' must not be null");
        }
        try {
            ZipInputStream zis = new ZipInputStream(zipIS);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File f = Zipper.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    f.mkdirs();
                } else {
                    f.getParentFile().mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(f);){
                        IOStreamUtil.copy(zis, fos);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gzip(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = Zipper.gzip(is);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] gzip(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                IOStreamUtil.copy(is, gzos);
                gzos.flush();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void gzip(byte[] binary, OutputStream os) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("An 'os' must not be null");
        }
        try (GZIPOutputStream gzos = new GZIPOutputStream(os);){
            gzos.write(binary, 0, binary.length);
            gzos.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static void gzip(InputStream is, OutputStream os) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        if (os == null) {
            throw new IllegalArgumentException("An 'os' must not be null");
        }
        try (GZIPOutputStream gzos = new GZIPOutputStream(os);){
            IOStreamUtil.copy(is, gzos);
            gzos.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(binary);
        try (GZIPInputStream gzis = new GZIPInputStream(bais);){
            byte[] byArray = Zipper.slurpBytes(gzis);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            byte[] byArray = Zipper.ungzip(is);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] ungzip(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("A 'inputStream' must not be null");
        }
        try (GZIPInputStream gzis = new GZIPInputStream(inputStream);){
            byte[] byArray = Zipper.slurpBytes(gzis);
            return byArray;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static InputStream ungzipToStream(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        return Zipper.ungzipToStream(new ByteArrayInputStream(binary));
    }

    public static InputStream ungzipToStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("An 'inputStream' must not be null");
        }
        try {
            return new GZIPInputStream(inputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static byte[] getZipEntryData(ZipInputStream zipInputStream) {
        if (zipInputStream == null) {
            throw new IllegalArgumentException("A 'zipInputStream' must not be null");
        }
        try {
            return Zipper.slurpBytes(zipInputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            boolean bl = Zipper.isZipFile(is);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isZipFile(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try {
            is.mark(4);
            byte[] bytes = IOStreamUtil.copyIStoByteArray(is, 4);
            is.reset();
            return Zipper.isZipFile(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isZipFile(byte[] bytes) {
        if (bytes == null || bytes.length < 4) {
            return false;
        }
        return ByteBuffer.wrap(bytes).getInt() == 1347093252;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGZipFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("A 'file' must not be null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            boolean bl = Zipper.isGZipFile(is);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isGZipFile(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("An 'is' must not be null");
        }
        try {
            is.mark(2);
            byte[] bytes = IOStreamUtil.copyIStoByteArray(is, 2);
            is.reset();
            return Zipper.isGZipFile(bytes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static boolean isGZipFile(byte[] bytes) {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return ByteBuffer.wrap(bytes).getShort() == 8075;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listZipEntryNames(File zip) {
        if (zip == null) {
            throw new IllegalArgumentException("A 'zip' must not be null");
        }
        try (FileInputStream is = new FileInputStream(zip);){
            List<String> list = Zipper.listZipEntryNames(is);
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listZipEntryNames(byte[] binary) {
        if (binary == null) {
            throw new IllegalArgumentException("A 'binary' must not be null");
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(binary);){
            List<String> list = Zipper.listZipEntryNames(is);
            return list;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listZipEntryNames(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException("A 'is' must not be null");
        }
        ArrayList<String> entries = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(is);){
            while (true) {
                ZipEntry entry;
                if ((entry = zis.getNextEntry()) == null) {
                    ArrayList<String> arrayList = entries;
                    return arrayList;
                }
                entries.add(entry.getName());
                zis.closeEntry();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private static void zipFile(File fileToZip, String fileName, FilenameFilter filter, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            ZipEntry e;
            if (fileName.endsWith("/")) {
                e = new ZipEntry(fileName);
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
                zipOut.putNextEntry(e);
                zipOut.closeEntry();
            } else {
                e = new ZipEntry(fileName + "/");
                e.setMethod(0);
                e.setSize(0L);
                e.setCrc(0L);
                zipOut.putNextEntry(e);
                zipOut.closeEntry();
            }
            for (File childFile : children = fileToZip.listFiles()) {
                Zipper.zipFile(childFile, fileName + "/" + childFile.getName(), filter, zipOut);
            }
        } else if (fileToZip.isFile() && (filter == null || filter.accept(fileToZip.getParentFile(), fileToZip.getName()))) {
            try (FileInputStream fis = new FileInputStream(fileToZip);){
                ZipEntry zipEntry = new ZipEntry(fileName);
                zipEntry.setMethod(8);
                zipOut.putNextEntry(zipEntry);
                IOStreamUtil.copy(new FileInputStream(fileToZip), zipOut);
                zipOut.closeEntry();
            }
        }
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    private static String normalizeAndValidateEntryName(String entryName) {
        if (StringUtil.isEmpty(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be null or empty");
        }
        if ("/".equals(entryName)) {
            throw new IllegalArgumentException("A 'entryName' must not be \"/\"");
        }
        return entryName.startsWith("/") ? entryName.substring(1) : entryName;
    }

    private static byte[] slurpBytes(Object source) throws IOException {
        if (source == null) {
            return new byte[0];
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (source instanceof InputStream) {
            return IOStreamUtil.copyIStoByteArray((InputStream)source);
        }
        if (source instanceof File) {
            try (FileInputStream fis = new FileInputStream((File)source);){
                byte[] byArray = IOStreamUtil.copyIStoByteArray(fis);
                return byArray;
            }
        }
        throw new IllegalArgumentException("Only entry values of type byte[], File or InputStream are supported!");
    }

    private static void printZipListLine(PrintStream ps, boolean verbose, long size, Integer method, long compressedSize, FileTime time, Long crc, String name) {
        String sTime;
        String sCompression = String.valueOf(Zipper.compressionPercentage(size, compressedSize)) + "%";
        String sMethod = method == null ? "" : (method == 0 ? "Stored" : "Defl:N");
        String string = sTime = time == null ? "-" : LocalDateTime.ofInstant(time.toInstant(), ZoneOffset.UTC).format(ziplist_formatter);
        String sCrc = crc == null ? "" : (crc == -1L ? "-" : String.format("%08X", crc & 0xFFFFFFFFFFFFFFFFL));
        Zipper.printZipListLine(ps, verbose, String.valueOf(size), sMethod, String.valueOf(compressedSize), sCompression, sTime, sCrc, name);
    }

    private static void printZipListLine(PrintStream ps, boolean verbose, String length, String method, String size, String compression, String time, String crc, String name) {
        if (verbose) {
            ps.println(String.format(ziplist_format, length, method, size, compression, time, crc, name));
        } else {
            ps.println(String.format(ziplist_format_short, length, time, name));
        }
    }

    private static void printZipListLineHead(PrintStream ps, boolean verbose) {
        Zipper.printZipListLine(ps, verbose, "Length", "Method", "Size", "Cmpr", "Date/Time", "CRC-32", "Name");
    }

    private static void printZipListLineDelim(PrintStream ps, boolean verbose) {
        Zipper.printZipListLine(ps, verbose, "----------", "------", "----------", "----", "----------------", "--------", "----");
    }

    private static long compressionPercentage(long size, long compressedSize) {
        return size <= 0L || compressedSize <= 0L ? 0L : ((size - compressedSize) * 100L + size / 2L) / size;
    }

    private static void deletePath(Path p) {
        try {
            Files.delete(p);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

