/*
 * Decompiled with CFR 0.152.
 */
package com.github.jlangch.venice.impl.util.cidr;

import com.github.jlangch.venice.VncException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public class CIDR
implements Comparable<CIDR> {
    private final String cidrNotation;
    private final int cidrRange;
    private final boolean ip4;
    private final InetAddress lowInet;
    private final InetAddress highInet;
    private final BigInteger lowBigInt;
    private final BigInteger highBigInt;

    private CIDR(String cidrNotation, int cidrRange, InetAddress startAddress, InetAddress endAddress, boolean ip4) {
        this.cidrNotation = cidrNotation;
        this.cidrRange = cidrRange;
        this.ip4 = ip4;
        this.lowInet = startAddress;
        this.highInet = endAddress;
        this.lowBigInt = new BigInteger(1, startAddress.getAddress());
        this.highBigInt = new BigInteger(1, endAddress.getAddress());
    }

    public static CIDR parse(String cidr) {
        try {
            int targetSize;
            ByteBuffer maskBuffer;
            int index = cidr.indexOf("/");
            String addressPart = index < 0 ? cidr : cidr.substring(0, index);
            InetAddress inetAddress = InetAddress.getByName(addressPart);
            if (inetAddress.getAddress().length == 4) {
                maskBuffer = ByteBuffer.allocate(4).putInt(-1);
                targetSize = 4;
            } else {
                maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
                targetSize = 16;
            }
            String cidrRangePart = index < 0 ? (targetSize == 4 ? "32" : "128") : cidr.substring(index + 1);
            int cidrRange = Integer.parseInt(cidrRangePart);
            BigInteger mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(cidrRange);
            ByteBuffer buffer = ByteBuffer.wrap(inetAddress.getAddress());
            BigInteger ipVal = new BigInteger(1, buffer.array());
            BigInteger startIp = ipVal.and(mask);
            BigInteger endIp = startIp.add(mask.not());
            byte[] startIpArr = CIDR.toBytes(startIp.toByteArray(), targetSize);
            byte[] endIpArr = CIDR.toBytes(endIp.toByteArray(), targetSize);
            return new CIDR(cidr, cidrRange, InetAddress.getByAddress(startIpArr), InetAddress.getByAddress(endIpArr), targetSize == 4);
        }
        catch (UnknownHostException ex) {
            throw new VncException("Invalid CIDR IP block '" + cidr + "'", ex);
        }
    }

    public String getNotation() {
        return this.cidrNotation;
    }

    public int getRange() {
        return this.cidrRange;
    }

    public InetAddress getLowInetAddress() {
        return this.lowInet;
    }

    public InetAddress getHighInetAddress() {
        return this.highInet;
    }

    public String getLowHostAddress() {
        return this.lowInet.getHostAddress();
    }

    public String getHighHostAddress() {
        return this.highInet.getHostAddress();
    }

    public boolean isIP4() {
        return this.ip4;
    }

    public boolean getLowAddressBit(int n) {
        return this.lowBigInt.testBit(n);
    }

    public boolean getHighAddressBit(int n) {
        return this.highBigInt.testBit(n);
    }

    public boolean isInRange(InetAddress ipAddress) {
        BigInteger target = new BigInteger(1, ipAddress.getAddress());
        int st = this.lowBigInt.compareTo(target);
        if (st <= 0) {
            int te = target.compareTo(this.highBigInt);
            return te <= 0;
        }
        return false;
    }

    public boolean isInRange(String ipAddress) {
        try {
            return this.isInRange(InetAddress.getByName(ipAddress));
        }
        catch (Exception ex) {
            throw new VncException("Invalid IP address '" + ipAddress + "'", ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.highBigInt == null ? 0 : this.highBigInt.hashCode());
        result = 31 * result + (this.lowBigInt == null ? 0 : this.lowBigInt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CIDR other = (CIDR)obj;
        if (this.highBigInt == null ? other.highBigInt != null : !this.highBigInt.equals(other.highBigInt)) {
            return false;
        }
        return !(this.lowBigInt == null ? other.lowBigInt != null : !this.lowBigInt.equals(other.lowBigInt));
    }

    @Override
    public final int compareTo(CIDR other) {
        int lowDiff = this.lowBigInt.compareTo(other.lowBigInt);
        if (lowDiff != 0) {
            return lowDiff;
        }
        int highDiff = this.highBigInt.compareTo(other.highBigInt);
        if (highDiff != 0) {
            return -highDiff;
        }
        return 0;
    }

    public String toString() {
        return String.format("%s: [%s .. %s]", this.cidrNotation, this.lowInet, this.highInet);
    }

    public static String toBinaryString(InetAddress inet, boolean octetSpacing) {
        byte[] bytes = inet.getAddress();
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < bytes.length; ++ii) {
            int b = bytes[ii] & 0xFF;
            if (octetSpacing && ii > 0) {
                sb.append(" ");
            }
            String s = Integer.toString(b, 2);
            for (int jj = s.length(); jj < 8; ++jj) {
                sb.append('0');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static byte[] toBytes(byte[] array, int targetSize) {
        int arr_len = array.length > targetSize ? targetSize : array.length;
        int arr_off = array.length > targetSize ? array.length - targetSize : 0;
        ByteBuffer buf = ByteBuffer.allocate(targetSize);
        buf.position(targetSize - arr_len);
        buf.put(array, arr_off, arr_len);
        return buf.array();
    }
}

